/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.fs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.catacombae.hfsexplorer.fs.BaseHFSAllocationFileView;
import org.catacombae.hfsexplorer.fs.ProgressMonitor;
import org.catacombae.hfsexplorer.io.ForkFilter;
import org.catacombae.hfsexplorer.io.ReadableBlockCachingStream;
import org.catacombae.hfsexplorer.io.ReadableRandomAccessSubstream;
import org.catacombae.hfsexplorer.io.SynchronizedReadableRandomAccess;
import org.catacombae.hfsexplorer.io.SynchronizedReadableRandomAccessStream;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTHeaderNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTHeaderRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTIndexNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTIndexRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTKey;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTNodeDescriptor;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFile;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFileRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFileThreadRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFolder;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFolderRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFolderThread;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFolderThreadRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogIndexNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogKey;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogLeafNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogString;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentDescriptor;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentIndexNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentKey;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentLeafNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentLeafRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSForkData;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSForkType;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.hfsexplorer.types.hfsplus.JournalInfoBlock;
import org.catacombae.io.Readable;
import org.catacombae.io.ReadableRandomAccessStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseHFSFileSystemView {
    public static volatile long fileReadOffset = 0L;
    protected volatile SynchronizedReadableRandomAccess hfsFile;
    private volatile SynchronizedReadableRandomAccessStream hfsStream;
    private final ReadableRandomAccessStream sourceStream;
    protected final long fsOffset;
    protected final CatalogOperations catOps;
    protected final int physicalBlockSize;

    public void close() {
    }

    protected BaseHFSFileSystemView(ReadableRandomAccessStream hfsFile, long fsOffset, CatalogOperations ops, boolean cachingEnabled) {
        this.sourceStream = hfsFile;
        this.hfsStream = new SynchronizedReadableRandomAccessStream(this.sourceStream);
        this.hfsFile = this.hfsStream;
        this.fsOffset = fsOffset;
        this.catOps = ops;
        this.physicalBlockSize = 512;
        if (cachingEnabled) {
            this.enableFileSystemCaching();
        }
    }

    public void enableFileSystemCaching() {
        this.enableFileSystemCaching(262144, 64);
    }

    public void enableFileSystemCaching(int blockSize, int blocksInCache) {
        this.hfsStream = new SynchronizedReadableRandomAccessStream(new ReadableBlockCachingStream(this.sourceStream, blockSize, blocksInCache));
        this.hfsFile = this.hfsStream;
    }

    public void disableFileSystemCaching() {
        this.hfsStream = new SynchronizedReadableRandomAccessStream(this.sourceStream);
        this.hfsFile = this.hfsStream;
    }

    public abstract CommonHFSVolumeHeader getVolumeHeader();

    protected abstract CommonBTHeaderNode createCommonBTHeaderNode(byte[] var1, int var2, int var3);

    protected abstract CommonBTNodeDescriptor getNodeDescriptor(Readable var1);

    protected abstract CommonBTHeaderRecord getHeaderRecord(Readable var1);

    protected abstract CommonBTNodeDescriptor createCommonBTNodeDescriptor(byte[] var1, int var2);

    protected abstract CommonHFSExtentIndexNode createCommonHFSExtentIndexNode(byte[] var1, int var2, int var3);

    protected abstract CommonHFSExtentLeafNode createCommonHFSExtentLeafNode(byte[] var1, int var2, int var3);

    protected abstract CommonHFSExtentKey createCommonHFSExtentKey(CommonHFSForkType var1, CommonHFSCatalogNodeID var2, int var3);

    protected abstract CommonHFSCatalogNodeID getCommonHFSCatalogNodeID(CommonHFSCatalogNodeID.ReservedID var1);

    public abstract BaseHFSAllocationFileView getAllocationFileView();

    public abstract CommonHFSCatalogString getEmptyString();

    public abstract String decodeString(CommonHFSCatalogString var1);

    public abstract CommonHFSCatalogString encodeString(String var1);

    public CommonHFSCatalogFolderRecord getRoot() {
        CatalogInitProcedure init = new CatalogInitProcedure();
        CommonHFSCatalogNodeID parentID = this.getCommonHFSCatalogNodeID(CommonHFSCatalogNodeID.ReservedID.ROOT_PARENT);
        int nodeSize = init.bthr.getNodeSize();
        long currentNodeOffset = init.bthr.getRootNodeNumber() * (long)init.bthr.getNodeSize();
        byte[] currentNodeData = new byte[nodeSize];
        init.catalogFile.seek(currentNodeOffset);
        init.catalogFile.readFully(currentNodeData);
        CommonBTNodeDescriptor nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        while (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.INDEX) {
            CommonHFSCatalogIndexNode currentNode = this.catOps.newCatalogIndexNode(currentNodeData, 0, init.bthr.getNodeSize(), init.bthr);
            CommonBTIndexRecord<CommonHFSCatalogKey> matchingRecord = BaseHFSFileSystemView.findKey(currentNode, parentID);
            currentNodeOffset = matchingRecord.getIndex() * (long)nodeSize;
            init.catalogFile.seek(currentNodeOffset);
            init.catalogFile.readFully(currentNodeData);
            nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.LEAF) {
            CommonHFSCatalogLeafRecord[] recs;
            CommonHFSCatalogLeafNode leaf = this.catOps.newCatalogLeafNode(currentNodeData, 0, nodeSize, init.bthr);
            for (CommonHFSCatalogLeafRecord rec : recs = leaf.getLeafRecords()) {
                if (rec.getKey().getParentID().toLong() != parentID.toLong()) continue;
                if (rec instanceof CommonHFSCatalogFolderRecord) {
                    return (CommonHFSCatalogFolderRecord)rec;
                }
                throw new RuntimeException("Error in internal structures:  root node is not a folder record, but a " + rec.getClass());
            }
            return null;
        }
        throw new RuntimeException("Expected leaf node. Found other kind: " + (Object)((Object)nodeDescriptor.getNodeType()));
    }

    public CommonBTHeaderNode getCatalogHeaderNode() {
        CommonBTNode firstNode = this.getCatalogNode(0L);
        if (firstNode instanceof CommonBTHeaderNode) {
            return (CommonBTHeaderNode)firstNode;
        }
        throw new RuntimeException("Unexpected node type at catalog node 0: " + firstNode.getClass());
    }

    public CommonBTNode getCatalogNode(long nodeNumber) {
        long currentNodeNumber;
        CatalogInitProcedure init = new CatalogInitProcedure();
        if (nodeNumber < 0L) {
            currentNodeNumber = init.bthr.getRootNodeNumber();
            if (currentNodeNumber == 0L) {
                return null;
            }
        } else {
            currentNodeNumber = nodeNumber;
        }
        int nodeSize = init.bthr.getNodeSize();
        byte[] currentNodeData = new byte[nodeSize];
        try {
            init.catalogFile.seek(currentNodeNumber * (long)nodeSize);
            init.catalogFile.readFully(currentNodeData);
        }
        catch (RuntimeException e) {
            System.err.println("RuntimeException in getCatalogNode. Printing additional information:");
            System.err.println("  nodeNumber=" + nodeNumber);
            System.err.println("  currentNodeNumber=" + currentNodeNumber);
            System.err.println("  nodeSize=" + nodeSize);
            System.err.println("  init.catalogFile.length()=" + init.catalogFile.length());
            System.err.println("  (currentNodeNumber * nodeSize)=" + currentNodeNumber * (long)nodeSize);
            throw e;
        }
        CommonBTNodeDescriptor nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.HEADER) {
            return this.createCommonBTHeaderNode(currentNodeData, 0, init.bthr.getNodeSize());
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.INDEX) {
            return this.catOps.newCatalogIndexNode(currentNodeData, 0, init.bthr.getNodeSize(), init.bthr);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.LEAF) {
            return this.catOps.newCatalogLeafNode(currentNodeData, 0, init.bthr.getNodeSize(), init.bthr);
        }
        return null;
    }

    public CommonBTNode getExtentsOverflowNode(long nodeNumber) {
        long currentNodeNumber;
        ExtentsInitProcedure init = new ExtentsInitProcedure();
        if (nodeNumber < 0L) {
            currentNodeNumber = init.bthr.getRootNodeNumber();
            if (currentNodeNumber == 0L) {
                return null;
            }
        } else {
            currentNodeNumber = nodeNumber;
        }
        int nodeSize = init.bthr.getNodeSize();
        byte[] currentNodeData = new byte[nodeSize];
        try {
            init.extentsFile.seek(currentNodeNumber * (long)nodeSize);
            init.extentsFile.readFully(currentNodeData);
        }
        catch (RuntimeException e) {
            System.err.println("RuntimeException in getCatalogNode. Printing additional information:");
            System.err.println("  nodeNumber=" + nodeNumber);
            System.err.println("  currentNodeNumber=" + currentNodeNumber);
            System.err.println("  nodeSize=" + nodeSize);
            System.err.println("  init.extentsFile.length()=" + init.extentsFile.length());
            System.err.println("  (currentNodeNumber * nodeSize)=" + currentNodeNumber * (long)nodeSize);
            throw e;
        }
        CommonBTNodeDescriptor nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.HEADER) {
            return this.createCommonBTHeaderNode(currentNodeData, 0, nodeSize);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.INDEX) {
            return this.createCommonHFSExtentIndexNode(currentNodeData, 0, nodeSize);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.LEAF) {
            return this.createCommonHFSExtentLeafNode(currentNodeData, 0, nodeSize);
        }
        return null;
    }

    public LinkedList<CommonHFSCatalogLeafRecord> getPathTo(CommonHFSCatalogNodeID leafID) {
        CommonHFSCatalogLeafRecord leafRec = this.getRecord(leafID, this.getEmptyString());
        if (leafRec != null) {
            return this.getPathTo(leafRec);
        }
        throw new RuntimeException("No folder thread found for leaf id " + leafID.toLong() + "!");
    }

    public LinkedList<CommonHFSCatalogLeafRecord> getPathTo(CommonHFSCatalogLeafRecord leaf) {
        if (leaf == null) {
            throw new IllegalArgumentException("argument \"leaf\" must not be null!");
        }
        LinkedList<CommonHFSCatalogLeafRecord> pathList = new LinkedList<CommonHFSCatalogLeafRecord>();
        pathList.addLast(leaf);
        CommonHFSCatalogNodeID parentID = leaf.getKey().getParentID();
        while (!parentID.equals(parentID.getReservedID(CommonHFSCatalogNodeID.ReservedID.ROOT_PARENT))) {
            CommonHFSCatalogLeafRecord parent = this.getRecord(parentID, this.getEmptyString());
            if (parent == null) {
                throw new RuntimeException("No folder thread found!");
            }
            if (parent instanceof CommonHFSCatalogFolderThreadRecord) {
                CommonHFSCatalogFolderThreadRecord threadRec = (CommonHFSCatalogFolderThreadRecord)parent;
                CommonHFSCatalogFolderThread thread = threadRec.getData();
                pathList.addFirst(this.getRecord(thread.getParentID(), thread.getNodeName()));
                parentID = thread.getParentID();
                continue;
            }
            if (parent instanceof CommonHFSCatalogFileThreadRecord) {
                throw new RuntimeException("Tried to get folder thread (" + parentID + ",\"\") but found a file thread!");
            }
            throw new RuntimeException("Tried to get folder thread (" + parentID + ",\"\") but found a " + parent.getClass() + "!");
        }
        return pathList;
    }

    public CommonHFSCatalogLeafRecord getRecord(CommonHFSCatalogNodeID parentID, CommonHFSCatalogString nodeName) {
        CatalogInitProcedure init = new CatalogInitProcedure();
        int nodeSize = init.bthr.getNodeSize();
        long currentNodeOffset = init.bthr.getRootNodeNumber() * (long)nodeSize;
        byte[] currentNodeData = new byte[init.bthr.getNodeSize()];
        init.catalogFile.seek(currentNodeOffset);
        init.catalogFile.readFully(currentNodeData);
        CommonBTNodeDescriptor nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        while (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.INDEX) {
            CommonHFSCatalogIndexNode currentNode = this.catOps.newCatalogIndexNode(currentNodeData, 0, nodeSize, init.bthr);
            CommonBTIndexRecord<CommonHFSCatalogKey> matchingRecord = BaseHFSFileSystemView.findLEKey(currentNode, this.catOps.newCatalogKey(parentID, nodeName, init.bthr));
            if (matchingRecord == null) {
                return null;
            }
            currentNodeOffset = matchingRecord.getIndex() * (long)nodeSize;
            init.catalogFile.seek(currentNodeOffset);
            init.catalogFile.readFully(currentNodeData);
            nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.LEAF) {
            CommonHFSCatalogLeafRecord[] recs;
            CommonHFSCatalogLeafNode leaf = this.catOps.newCatalogLeafNode(currentNodeData, 0, init.bthr.getNodeSize(), init.bthr);
            for (CommonHFSCatalogLeafRecord rec : recs = leaf.getLeafRecords()) {
                if (rec.getKey().compareTo(this.catOps.newCatalogKey(parentID, nodeName, init.bthr)) != 0) continue;
                return rec;
            }
            return null;
        }
        throw new RuntimeException("Expected leaf node. Found other kind: " + (Object)((Object)nodeDescriptor.getNodeType()));
    }

    public CommonHFSCatalogLeafRecord[] listRecords(CommonHFSCatalogLeafRecord folderRecord) {
        if (folderRecord instanceof CommonHFSCatalogFolderRecord) {
            CommonHFSCatalogFolder folder = ((CommonHFSCatalogFolderRecord)folderRecord).getData();
            return this.listRecords(folder.getFolderID());
        }
        throw new RuntimeException("Invalid input (not a folder record).");
    }

    public CommonHFSCatalogLeafRecord[] listRecords(CommonHFSCatalogNodeID folderID) {
        CatalogInitProcedure init = new CatalogInitProcedure();
        ReadableRandomAccessStream catalogFile = init.forkFilterFile;
        return this.collectFilesInDir(folderID, init.bthr.getRootNodeNumber(), new ReadableRandomAccessSubstream(this.hfsFile), this.fsOffset, init.header, init.bthr, catalogFile);
    }

    public long extractDataForkToStream(CommonHFSCatalogLeafRecord fileRecord, OutputStream os, ProgressMonitor pm) throws IOException {
        if (fileRecord instanceof CommonHFSCatalogFileRecord) {
            CommonHFSCatalogFile catFile = ((CommonHFSCatalogFileRecord)fileRecord).getData();
            CommonHFSForkData dataFork = catFile.getDataFork();
            return this.extractForkToStream(dataFork, this.getAllDataExtentDescriptors(fileRecord), os, pm);
        }
        throw new IllegalArgumentException("fileRecord.getData() it not of type RECORD_TYPE_FILE");
    }

    public long extractResourceForkToStream(CommonHFSCatalogLeafRecord fileRecord, OutputStream os, ProgressMonitor pm) throws IOException {
        if (fileRecord instanceof CommonHFSCatalogFileRecord) {
            CommonHFSCatalogFile catFile = ((CommonHFSCatalogFileRecord)fileRecord).getData();
            CommonHFSForkData resFork = catFile.getResourceFork();
            return this.extractForkToStream(resFork, this.getAllResourceExtentDescriptors(fileRecord), os, pm);
        }
        throw new IllegalArgumentException("fileRecord.getData() it not of type RECORD_TYPE_FILE");
    }

    public long extractForkToStream(CommonHFSForkData forkData, CommonHFSExtentDescriptor[] extentDescriptors, OutputStream os, ProgressMonitor pm) throws IOException {
        long bytesToRead;
        int bytesRead;
        CommonHFSVolumeHeader header = this.getVolumeHeader();
        ForkFilter forkFilter = new ForkFilter(forkData, extentDescriptors, (ReadableRandomAccessStream)new ReadableRandomAccessSubstream(this.hfsFile), this.fsOffset, header.getAllocationBlockSize(), header.getAllocationBlockStart() * (long)this.physicalBlockSize);
        byte[] buffer = new byte[4096];
        for (bytesToRead = forkData.getLogicalSize(); bytesToRead > 0L && !pm.cancelSignaled() && (bytesRead = forkFilter.read(buffer, 0, bytesToRead < (long)buffer.length ? (int)bytesToRead : buffer.length)) >= 0; bytesToRead -= (long)bytesRead) {
            pm.addDataProgress(bytesRead);
            os.write(buffer, 0, bytesRead);
        }
        return forkData.getLogicalSize() - bytesToRead;
    }

    public ReadableRandomAccessStream getReadableDataForkStream(CommonHFSCatalogLeafRecord fileRecord) {
        if (fileRecord instanceof CommonHFSCatalogFileRecord) {
            CommonHFSCatalogFile catFile = ((CommonHFSCatalogFileRecord)fileRecord).getData();
            CommonHFSForkData fork = catFile.getDataFork();
            return this.getReadableForkStream(fork, this.getAllDataExtentDescriptors(fileRecord));
        }
        throw new IllegalArgumentException("fileRecord.getData() it not of type RECORD_TYPE_FILE");
    }

    public ReadableRandomAccessStream getReadableResourceForkStream(CommonHFSCatalogLeafRecord fileRecord) {
        if (fileRecord instanceof CommonHFSCatalogFileRecord) {
            CommonHFSCatalogFile catFile = ((CommonHFSCatalogFileRecord)fileRecord).getData();
            CommonHFSForkData fork = catFile.getResourceFork();
            return this.getReadableForkStream(fork, this.getAllResourceExtentDescriptors(fileRecord));
        }
        throw new IllegalArgumentException("fileRecord.getData() it not of type RECORD_TYPE_FILE");
    }

    private ReadableRandomAccessStream getReadableForkStream(CommonHFSForkData forkData, CommonHFSExtentDescriptor[] extentDescriptors) {
        CommonHFSVolumeHeader header = this.getVolumeHeader();
        return new ForkFilter(forkData, extentDescriptors, (ReadableRandomAccessStream)new ReadableRandomAccessSubstream(this.hfsFile), this.fsOffset + fileReadOffset, header.getAllocationBlockSize(), header.getAllocationBlockStart() * (long)this.physicalBlockSize);
    }

    private static String getDebugString(CommonHFSExtentKey key) {
        return key.getForkType() + ":" + key.getFileID().toLong() + ":" + key.getStartBlock();
    }

    public CommonHFSExtentLeafRecord getOverflowExtent(CommonHFSExtentKey key) {
        ExtentsInitProcedure init = new ExtentsInitProcedure();
        int nodeSize = init.bthr.getNodeSize();
        long currentNodeOffset = init.bthr.getRootNodeNumber() * (long)nodeSize;
        byte[] currentNodeData = new byte[nodeSize];
        init.extentsFile.seek(currentNodeOffset);
        init.extentsFile.readFully(currentNodeData);
        CommonBTNodeDescriptor nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        while (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.INDEX) {
            CommonHFSExtentIndexNode currentNode = this.createCommonHFSExtentIndexNode(currentNodeData, 0, nodeSize);
            CommonBTIndexRecord<CommonHFSExtentKey> matchingRecord = BaseHFSFileSystemView.findLEKey(currentNode, key);
            currentNodeOffset = matchingRecord.getIndex() * (long)nodeSize;
            init.extentsFile.seek(currentNodeOffset);
            init.extentsFile.readFully(currentNodeData);
            nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.LEAF) {
            CommonHFSExtentLeafRecord[] recs;
            CommonHFSExtentLeafNode leaf = this.createCommonHFSExtentLeafNode(currentNodeData, 0, nodeSize);
            for (CommonHFSExtentLeafRecord rec : recs = leaf.getLeafRecords()) {
                CommonHFSExtentKey curKey = rec.getKey();
                if (curKey.compareTo(key) != 0) continue;
                return rec;
            }
            return null;
        }
        throw new RuntimeException("Expected leaf node. Found other kind: " + (Object)((Object)nodeDescriptor.getNodeType()));
    }

    public CommonHFSExtentDescriptor[] getAllExtents(CommonHFSCatalogLeafRecord requestFile, CommonHFSForkType forkType) {
        if (requestFile instanceof CommonHFSCatalogFileRecord) {
            CommonHFSForkData forkData;
            CommonHFSCatalogFile catFile = ((CommonHFSCatalogFileRecord)requestFile).getData();
            if (forkType == CommonHFSForkType.DATA_FORK) {
                forkData = catFile.getDataFork();
            } else if (forkType == CommonHFSForkType.RESOURCE_FORK) {
                forkData = catFile.getResourceFork();
            } else {
                throw new IllegalArgumentException("Illegal fork type!");
            }
            return this.getAllExtents(catFile.getFileID(), forkData, forkType);
        }
        throw new IllegalArgumentException("Not a file record!");
    }

    public CommonHFSExtentDescriptor[] getAllExtents(CommonHFSCatalogNodeID fileID, CommonHFSForkData forkData, CommonHFSForkType forkType) {
        CommonHFSExtentDescriptor[] result;
        if (fileID == null) {
            throw new IllegalArgumentException("fileID == null");
        }
        if (forkData == null) {
            throw new IllegalArgumentException("forkData == null");
        }
        if (forkType == null) {
            throw new IllegalArgumentException("forkType == null");
        }
        long allocationBlockSize = this.getVolumeHeader().getAllocationBlockSize();
        long basicExtentsBlockCount = 0L;
        CommonHFSExtentDescriptor[] basicExtents = forkData.getBasicExtents();
        for (int i = 0; i < basicExtents.length; ++i) {
            basicExtentsBlockCount += basicExtents[i].getBlockCount();
        }
        if (basicExtentsBlockCount * allocationBlockSize >= forkData.getLogicalSize()) {
            result = forkData.getBasicExtents();
        } else {
            LinkedList<CommonHFSExtentDescriptor> resultList = new LinkedList<CommonHFSExtentDescriptor>();
            for (CommonHFSExtentDescriptor descriptor : forkData.getBasicExtents()) {
                resultList.add(descriptor);
            }
            long totalBlockCount = basicExtentsBlockCount;
            while (totalBlockCount * allocationBlockSize < forkData.getLogicalSize()) {
                CommonHFSExtentDescriptor[] currentRecordData;
                CommonHFSExtentKey extentKey = this.createCommonHFSExtentKey(forkType, fileID, (int)totalBlockCount);
                CommonHFSExtentLeafRecord currentRecord = this.getOverflowExtent(extentKey);
                if (currentRecord == null) {
                    System.err.println("ERROR: currentRecord == null!!");
                    System.err.print("       extentKey");
                    if (extentKey != null) {
                        System.err.println(":");
                        extentKey.print(System.err, "         ");
                    } else {
                        System.err.println(" == null!!");
                    }
                }
                for (CommonHFSExtentDescriptor cur : currentRecordData = currentRecord.getRecordData()) {
                    resultList.add(cur);
                    totalBlockCount += cur.getBlockCount();
                }
            }
            result = resultList.toArray(new CommonHFSExtentDescriptor[resultList.size()]);
        }
        return result;
    }

    public CommonHFSExtentDescriptor[] getAllExtentDescriptors(CommonHFSCatalogLeafRecord requestFile, CommonHFSForkType forkType) {
        return this.getAllExtentDescriptors(this.getAllExtents(requestFile, forkType));
    }

    public CommonHFSExtentDescriptor[] getAllExtentDescriptors(CommonHFSCatalogNodeID fileID, CommonHFSForkData forkData, CommonHFSForkType forkType) {
        return this.getAllExtentDescriptors(this.getAllExtents(fileID, forkData, forkType));
    }

    protected CommonHFSExtentDescriptor[] getAllExtentDescriptors(CommonHFSExtentDescriptor[] descriptors) {
        LinkedList<CommonHFSExtentDescriptor> descTmp = new LinkedList<CommonHFSExtentDescriptor>();
        for (CommonHFSExtentDescriptor desc : descriptors) {
            if (desc.getStartBlock() == 0L && desc.getBlockCount() == 0L) break;
            descTmp.addLast(desc);
        }
        return descTmp.toArray(new CommonHFSExtentDescriptor[descTmp.size()]);
    }

    public CommonHFSExtentDescriptor[] getAllDataExtentDescriptors(CommonHFSCatalogNodeID fileID, CommonHFSForkData forkData) {
        return this.getAllExtentDescriptors(fileID, forkData, CommonHFSForkType.DATA_FORK);
    }

    public CommonHFSExtentDescriptor[] getAllDataExtentDescriptors(CommonHFSCatalogLeafRecord requestFile) {
        return this.getAllExtentDescriptors(requestFile, CommonHFSForkType.DATA_FORK);
    }

    public CommonHFSExtentDescriptor[] getAllResourceExtentDescriptors(CommonHFSCatalogNodeID fileID, CommonHFSForkData forkData) {
        return this.getAllExtentDescriptors(fileID, forkData, CommonHFSForkType.RESOURCE_FORK);
    }

    public CommonHFSExtentDescriptor[] getAllResourceExtentDescriptors(CommonHFSCatalogLeafRecord requestFile) {
        return this.getAllExtentDescriptors(requestFile, CommonHFSForkType.RESOURCE_FORK);
    }

    public abstract JournalInfoBlock getJournalInfoBlock();

    private CommonHFSCatalogLeafRecord[] collectFilesInDir(CommonHFSCatalogNodeID dirID, long currentNodeIndex, ReadableRandomAccessStream hfsFile, long fsOffset, CommonHFSVolumeHeader header, CommonBTHeaderRecord bthr, ReadableRandomAccessStream catalogFile) {
        int nodeSize = bthr.getNodeSize();
        byte[] currentNodeData = new byte[nodeSize];
        catalogFile.seek(currentNodeIndex * (long)nodeSize);
        catalogFile.readFully(currentNodeData);
        CommonBTNodeDescriptor nodeDescriptor = this.createCommonBTNodeDescriptor(currentNodeData, 0);
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.INDEX) {
            CommonHFSCatalogIndexNode currentNode = this.catOps.newCatalogIndexNode(currentNodeData, 0, nodeSize, bthr);
            List<CommonBTIndexRecord<CommonHFSCatalogKey>> matchingRecords = BaseHFSFileSystemView.findLEChildKeys(currentNode, dirID);
            LinkedList<CommonHFSCatalogLeafRecord> results = new LinkedList<CommonHFSCatalogLeafRecord>();
            for (CommonBTIndexRecord<CommonHFSCatalogKey> bir : matchingRecords) {
                CommonHFSCatalogLeafRecord[] partResult;
                for (CommonHFSCatalogLeafRecord curRes : partResult = this.collectFilesInDir(dirID, bir.getIndex(), hfsFile, fsOffset, header, bthr, catalogFile)) {
                    results.addLast(curRes);
                }
            }
            return results.toArray(new CommonHFSCatalogLeafRecord[results.size()]);
        }
        if (nodeDescriptor.getNodeType() == CommonBTNodeDescriptor.NodeType.LEAF) {
            CommonHFSCatalogLeafNode currentNode = this.catOps.newCatalogLeafNode(currentNodeData, 0, nodeSize, bthr);
            return BaseHFSFileSystemView.getChildrenTo(currentNode, dirID);
        }
        throw new RuntimeException("Illegal type for node! (" + (Object)((Object)nodeDescriptor.getNodeType()) + ")");
    }

    private static List<CommonBTIndexRecord<CommonHFSCatalogKey>> findLEChildKeys(CommonBTIndexNode<CommonHFSCatalogKey> indexNode, CommonHFSCatalogNodeID rootFolderID) {
        LinkedList<CommonBTIndexRecord<CommonHFSCatalogKey>> result = new LinkedList<CommonBTIndexRecord<CommonHFSCatalogKey>>();
        CommonBTIndexRecord largestMatchingRecord = null;
        CommonHFSCatalogKey largestMatchingKey = null;
        for (CommonBTIndexRecord record : indexNode.getBTRecords()) {
            CommonHFSCatalogKey key = (CommonHFSCatalogKey)record.getKey();
            if (key.getParentID().toLong() < rootFolderID.toLong() && (largestMatchingKey == null || key.compareTo(largestMatchingKey) > 0)) {
                largestMatchingKey = key;
                largestMatchingRecord = record;
                continue;
            }
            if (key.getParentID().toLong() != rootFolderID.toLong()) continue;
            result.addLast(record);
        }
        if (largestMatchingKey != null) {
            result.addFirst(largestMatchingRecord);
        }
        return result;
    }

    private static CommonBTIndexRecord<CommonHFSCatalogKey> findKey(CommonHFSCatalogIndexNode indexNode, CommonHFSCatalogNodeID parentID) {
        for (CommonBTIndexRecord rec : indexNode.getBTRecords()) {
            CommonHFSCatalogKey key = (CommonHFSCatalogKey)rec.getKey();
            if (key.getParentID().toLong() != parentID.toLong()) continue;
            return rec;
        }
        return null;
    }

    private static <K extends CommonBTKey<K>> CommonBTIndexRecord<K> findLEKey(CommonBTIndexNode<K> indexNode, K searchKey) {
        CommonBTIndexRecord largestMatchingRecord = null;
        for (CommonBTIndexRecord record : indexNode.getBTRecords()) {
            Object recordKey = record.getKey();
            if (recordKey.compareTo(searchKey) > 0 || largestMatchingRecord != null && recordKey.compareTo(largestMatchingRecord.getKey()) <= 0) continue;
            largestMatchingRecord = record;
        }
        return largestMatchingRecord;
    }

    private static CommonHFSCatalogLeafRecord[] getChildrenTo(CommonHFSCatalogLeafNode leafNode, CommonHFSCatalogNodeID nodeID) {
        LinkedList<CommonHFSCatalogLeafRecord> children = new LinkedList<CommonHFSCatalogLeafRecord>();
        CommonHFSCatalogLeafRecord[] records = leafNode.getLeafRecords();
        for (int i = 0; i < records.length; ++i) {
            CommonHFSCatalogLeafRecord curRec = records[i];
            if (curRec.getKey().getParentID().toLong() != nodeID.toLong()) continue;
            children.addLast(curRec);
        }
        return children.toArray(new CommonHFSCatalogLeafRecord[children.size()]);
    }

    protected long calculateDataForkSizeRecursive(CommonHFSCatalogLeafRecord[] recs) {
        return this.calculateForkSizeRecursive(recs, false);
    }

    protected long calculateDataForkSizeRecursive(CommonHFSCatalogLeafRecord rec) {
        return this.calculateForkSizeRecursive(rec, false);
    }

    protected long calculateResourceForkSizeRecursive(CommonHFSCatalogLeafRecord[] recs) {
        return this.calculateForkSizeRecursive(recs, true);
    }

    protected long calculateResourceForkSizeRecursive(CommonHFSCatalogLeafRecord rec) {
        return this.calculateForkSizeRecursive(rec, true);
    }

    protected long calculateForkSizeRecursive(CommonHFSCatalogLeafRecord[] recs, boolean resourceFork) {
        long totalSize = 0L;
        for (CommonHFSCatalogLeafRecord rec : recs) {
            totalSize += this.calculateForkSizeRecursive(rec, resourceFork);
        }
        return totalSize;
    }

    protected long calculateForkSizeRecursive(CommonHFSCatalogLeafRecord rec, boolean resourceFork) {
        if (rec instanceof CommonHFSCatalogFileRecord) {
            if (!resourceFork) {
                return ((CommonHFSCatalogFileRecord)rec).getData().getDataFork().getLogicalSize();
            }
            return ((CommonHFSCatalogFileRecord)rec).getData().getResourceFork().getLogicalSize();
        }
        if (rec instanceof CommonHFSCatalogFolderRecord) {
            CommonHFSCatalogNodeID requestedID = ((CommonHFSCatalogFolderRecord)rec).getData().getFolderID();
            CommonHFSCatalogLeafRecord[] contents = this.listRecords(requestedID);
            long totalSize = 0L;
            for (CommonHFSCatalogLeafRecord outRec : contents) {
                totalSize += this.calculateForkSizeRecursive(outRec, resourceFork);
            }
            return totalSize;
        }
        return 0L;
    }

    protected static interface CatalogOperations {
        public CommonHFSCatalogIndexNode newCatalogIndexNode(byte[] var1, int var2, int var3, CommonBTHeaderRecord var4);

        public CommonHFSCatalogKey newCatalogKey(CommonHFSCatalogNodeID var1, CommonHFSCatalogString var2, CommonBTHeaderRecord var3);

        public CommonHFSCatalogLeafNode newCatalogLeafNode(byte[] var1, int var2, int var3, CommonBTHeaderRecord var4);

        public CommonHFSCatalogLeafRecord newCatalogLeafRecord(byte[] var1, int var2, CommonBTHeaderRecord var3);
    }

    private class ExtentsInitProcedure
    extends InitProcedure {
        public final ReadableRandomAccessStream extentsFile;

        public ExtentsInitProcedure() {
            this.extentsFile = this.forkFilterFile;
        }

        protected ReadableRandomAccessStream getForkFilterFile(CommonHFSVolumeHeader header) {
            return new ForkFilter(header.getExtentsOverflowFile(), header.getExtentsOverflowFile().getBasicExtents(), (ReadableRandomAccessStream)new ReadableRandomAccessSubstream(BaseHFSFileSystemView.this.hfsFile), BaseHFSFileSystemView.this.fsOffset, header.getAllocationBlockSize(), header.getAllocationBlockStart() * (long)BaseHFSFileSystemView.this.physicalBlockSize);
        }
    }

    private class CatalogInitProcedure
    extends InitProcedure {
        public final ReadableRandomAccessStream catalogFile;

        public CatalogInitProcedure() {
            this.catalogFile = this.forkFilterFile;
        }

        protected ReadableRandomAccessStream getForkFilterFile(CommonHFSVolumeHeader header) {
            CommonHFSExtentDescriptor[] allCatalogFileDescriptors = BaseHFSFileSystemView.this.getAllDataExtentDescriptors(BaseHFSFileSystemView.this.getCommonHFSCatalogNodeID(CommonHFSCatalogNodeID.ReservedID.CATALOG_FILE), header.getCatalogFile());
            return new ForkFilter(header.getCatalogFile(), allCatalogFileDescriptors, (ReadableRandomAccessStream)new ReadableRandomAccessSubstream(BaseHFSFileSystemView.this.hfsFile), BaseHFSFileSystemView.this.fsOffset, header.getAllocationBlockSize(), header.getAllocationBlockStart() * (long)BaseHFSFileSystemView.this.physicalBlockSize);
        }
    }

    private abstract class InitProcedure {
        public final CommonHFSVolumeHeader header;
        public final ReadableRandomAccessStream forkFilterFile;
        public final CommonBTNodeDescriptor btnd;
        public final CommonBTHeaderRecord bthr;

        public InitProcedure() {
            this.header = BaseHFSFileSystemView.this.getVolumeHeader();
            this.forkFilterFile = this.getForkFilterFile(this.header);
            this.forkFilterFile.seek(0L);
            this.btnd = BaseHFSFileSystemView.this.getNodeDescriptor(this.forkFilterFile);
            this.bthr = BaseHFSFileSystemView.this.getHeaderRecord(this.forkFilterFile);
        }

        protected abstract ReadableRandomAccessStream getForkFilterFile(CommonHFSVolumeHeader var1);
    }
}

