/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.expression;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.AndExpression;
import ghidra.app.plugin.processors.sleigh.expression.ConstantValue;
import ghidra.app.plugin.processors.sleigh.expression.ContextField;
import ghidra.app.plugin.processors.sleigh.expression.DivExpression;
import ghidra.app.plugin.processors.sleigh.expression.EndInstructionValue;
import ghidra.app.plugin.processors.sleigh.expression.LeftShiftExpression;
import ghidra.app.plugin.processors.sleigh.expression.MinusExpression;
import ghidra.app.plugin.processors.sleigh.expression.MultExpression;
import ghidra.app.plugin.processors.sleigh.expression.Next2InstructionValue;
import ghidra.app.plugin.processors.sleigh.expression.NotExpression;
import ghidra.app.plugin.processors.sleigh.expression.OperandValue;
import ghidra.app.plugin.processors.sleigh.expression.OrExpression;
import ghidra.app.plugin.processors.sleigh.expression.PlusExpression;
import ghidra.app.plugin.processors.sleigh.expression.RightShiftExpression;
import ghidra.app.plugin.processors.sleigh.expression.StartInstructionValue;
import ghidra.app.plugin.processors.sleigh.expression.SubExpression;
import ghidra.app.plugin.processors.sleigh.expression.TokenField;
import ghidra.app.plugin.processors.sleigh.expression.XorExpression;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;

public abstract class PatternExpression {
    public abstract long getValue(ParserWalker var1) throws MemoryAccessException;

    public abstract void decode(Decoder var1, SleighLanguage var2) throws DecoderException;

    public static PatternExpression decodeExpression(Decoder decoder, SleighLanguage lang) throws DecoderException {
        PatternExpression res;
        int el = decoder.peekElement();
        if (el == SlaFormat.ELEM_TOKENFIELD.id()) {
            res = new TokenField();
        } else if (el == SlaFormat.ELEM_CONTEXTFIELD.id()) {
            res = new ContextField();
        } else if (el == SlaFormat.ELEM_INTB.id()) {
            res = new ConstantValue();
        } else if (el == SlaFormat.ELEM_OPERAND_EXP.id()) {
            res = new OperandValue();
        } else if (el == SlaFormat.ELEM_START_EXP.id()) {
            res = new StartInstructionValue();
        } else if (el == SlaFormat.ELEM_END_EXP.id()) {
            res = new EndInstructionValue();
        } else if (el == SlaFormat.ELEM_NEXT2_EXP.id()) {
            res = new Next2InstructionValue();
        } else if (el == SlaFormat.ELEM_PLUS_EXP.id()) {
            res = new PlusExpression();
        } else if (el == SlaFormat.ELEM_SUB_EXP.id()) {
            res = new SubExpression();
        } else if (el == SlaFormat.ELEM_MULT_EXP.id()) {
            res = new MultExpression();
        } else if (el == SlaFormat.ELEM_LSHIFT_EXP.id()) {
            res = new LeftShiftExpression();
        } else if (el == SlaFormat.ELEM_RSHIFT_EXP.id()) {
            res = new RightShiftExpression();
        } else if (el == SlaFormat.ELEM_AND_EXP.id()) {
            res = new AndExpression();
        } else if (el == SlaFormat.ELEM_OR_EXP.id()) {
            res = new OrExpression();
        } else if (el == SlaFormat.ELEM_XOR_EXP.id()) {
            res = new XorExpression();
        } else if (el == SlaFormat.ELEM_DIV_EXP.id()) {
            res = new DivExpression();
        } else if (el == SlaFormat.ELEM_MINUS_EXP.id()) {
            res = new MinusExpression();
        } else if (el == SlaFormat.ELEM_NOT_EXP.id()) {
            res = new NotExpression();
        } else {
            return null;
        }
        ((PatternExpression)res).decode(decoder, lang);
        return res;
    }

    public abstract String toString();
}

