/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.correlate;

import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.correlate.Hash;
import ghidra.program.model.correlate.HashCalculator;
import ghidra.program.model.correlate.InstructHash;
import ghidra.program.model.mem.MemoryAccessException;

public class Block {
    protected boolean isMatched = false;
    protected boolean isVisited = false;
    protected CodeBlock origBlock;
    private int matchHash;
    protected InstructHash[] instList;

    public Block(CodeBlock codeBlock) {
        this.origBlock = codeBlock;
        this.matchHash = 0;
        this.instList = null;
    }

    protected void clearSort() {
        for (InstructHash element : this.instList) {
            element.clearSort();
        }
    }

    protected void setMatched(int index) {
        this.isMatched = true;
        this.matchHash = index * 7919;
        this.matchHash += 511;
        this.matchHash *= 4691;
    }

    public int getMatchHash() {
        return this.matchHash;
    }

    protected boolean allUnknown(int startindex, int length) {
        for (int i = 0; i < length; ++i) {
            if (!this.instList[startindex + i].isMatched) continue;
            return false;
        }
        return true;
    }

    public int hashGram(int gramSize, InstructHash instHash, HashCalculator hashCalc) throws MemoryAccessException {
        int hashVal = 22222;
        for (int i = 0; i < gramSize; ++i) {
            InstructHash curHash = this.instList[instHash.index + i];
            hashVal = hashCalc.calcHash(hashVal, curHash.instruction);
        }
        return hashVal;
    }

    protected void calcHashes(int minLength, int maxLength, boolean wholeBlock, boolean matchOnly, HashCalculator hashCalc) throws MemoryAccessException {
        if (wholeBlock && this.instList.length < minLength) {
            minLength = this.instList.length;
            maxLength = this.instList.length;
        } else if (matchOnly && this.matchHash == 0 && this.instList.length > 8) {
            for (int i = 0; i < this.instList.length; ++i) {
                if (this.instList[i].isMatched) continue;
                this.instList[i].clearNGrams(0);
            }
            return;
        }
        for (int i = 0; i < this.instList.length; ++i) {
            int j;
            if (this.instList[i].isMatched) continue;
            if (i + minLength > this.instList.length) {
                this.instList[i].clearNGrams(0);
                continue;
            }
            int maxind = i + maxLength;
            if (maxind > this.instList.length) {
                maxind = this.instList.length;
            }
            int num = maxind - i - minLength + 1;
            this.instList[i].clearNGrams(num);
            int accum = i == 0 && this.instList.length > 8 ? 22222 : 11111;
            for (j = 0; j < minLength - 1; ++j) {
                if (accum == 0) continue;
                if (this.instList[i + j].isMatched) {
                    accum = 0;
                    break;
                }
                accum = hashCalc.calcHash(accum, this.instList[i + j].instruction);
            }
            for (j = 0; j < num; ++j) {
                if (accum != 0) {
                    accum = this.instList[i + j + minLength - 1].isMatched ? 0 : hashCalc.calcHash(accum, this.instList[i + j + minLength - 1].instruction);
                }
                this.instList[i].nGrams[j] = accum != 0 ? new Hash(accum ^ this.matchHash, minLength + j) : null;
            }
        }
    }
}

