/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;

public class MutabilitySettingsDefinition
implements EnumSettingsDefinition {
    public static final int NORMAL = 0;
    public static final int VOLATILE = 1;
    public static final int CONSTANT = 2;
    public static final int WRITABLE = 3;
    private static final String[] choices = new String[]{"normal", "volatile", "constant", "writable"};
    public static final String MUTABILITY = "mutability";
    public static final MutabilitySettingsDefinition DEF = new MutabilitySettingsDefinition();

    private MutabilitySettingsDefinition() {
    }

    public int getMutabilityMode(Settings settings) {
        if (settings == null) {
            return 0;
        }
        Long value = settings.getLong(MUTABILITY);
        if (value == null) {
            return 0;
        }
        int mode = (int)value.longValue();
        if (mode < 0 || mode > 3) {
            mode = 0;
        }
        return mode;
    }

    public int getChoice(Settings settings) {
        return this.getMutabilityMode(settings);
    }

    public String getValueString(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    public void setChoice(Settings settings, int value) {
        if (value < 0 || value > 3) {
            settings.clearSetting(MUTABILITY);
        } else {
            settings.setLong(MUTABILITY, (long)value);
        }
    }

    public String[] getDisplayChoices(Settings settings) {
        return choices;
    }

    public String getName() {
        return "Mutability";
    }

    public String getStorageKey() {
        return MUTABILITY;
    }

    public String getDescription() {
        return "Selects the data mutability";
    }

    public String getDisplayChoice(int value, Settings s1) {
        return choices[value];
    }

    public void clear(Settings settings) {
        settings.clearSetting(MUTABILITY);
    }

    public void copySetting(Settings settings, Settings destSettings) {
        Long l = settings.getLong(MUTABILITY);
        if (l == null) {
            destSettings.clearSetting(MUTABILITY);
        } else {
            destSettings.setLong(MUTABILITY, l.longValue());
        }
    }

    public boolean hasValue(Settings setting) {
        return setting.getValue(MUTABILITY) != null;
    }
}

