/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import generic.stl.Pair;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VariableStorageConflicts {
    private List<Pair<List<Variable>, List<Variable>>> overlappingVariables = new ArrayList<Pair<List<Variable>, List<Variable>>>();
    private boolean ignoreParamToParamConflicts;
    private List<Variable> nonOverlappingVariables1 = new ArrayList<Variable>();
    private List<Variable> nonOverlappingVariables2 = new ArrayList<Variable>();
    private boolean paramOnlyAddressSets;
    private boolean parametersConflicted = false;

    public VariableStorageConflicts(List<Variable> variablesList1, List<Variable> variablesList2, boolean ignoreParamToParamConflicts, TaskMonitor monitor) throws CancelledException {
        ArrayList<Variable> variables1 = new ArrayList<Variable>(variablesList1);
        ArrayList<Variable> variables2 = new ArrayList<Variable>(variablesList2);
        this.ignoreParamToParamConflicts = ignoreParamToParamConflicts;
        ArrayList<Variable> overlapList1 = null;
        ArrayList<Variable> overlapList2 = null;
        AddressSet set1 = null;
        AddressSet set2 = null;
        for (int i = 0; i < variables1.size(); ++i) {
            Variable var2;
            monitor.checkCancelled();
            Variable var1 = (Variable)variables1.get(i);
            if (var1 == null) continue;
            variables1.set(i, null);
            Variable variable = var2 = var1 instanceof Parameter ? this.removeMatchingParameter((Parameter)var1, variables2) : this.removeMatchingVariable(var1, variables2);
            if (var2 != null) {
                this.nonOverlappingVariables1.add(var1);
                this.nonOverlappingVariables2.add(var2);
                continue;
            }
            if (overlapList1 == null) {
                overlapList1 = new ArrayList<Variable>();
                overlapList2 = new ArrayList<Variable>();
                set1 = new AddressSet();
                set2 = new AddressSet();
            } else {
                set1.clear();
            }
            VariableStorageConflicts.addToAddressSet(set1, var1.getVariableStorage());
            this.paramOnlyAddressSets = var1 instanceof Parameter;
            this.getOverlappingVariables(var1.getFirstUseOffset(), variables1, set1, overlapList1, variables2, set2, overlapList2, monitor);
            if (overlapList2.isEmpty()) {
                this.nonOverlappingVariables1.add(var1);
                continue;
            }
            overlapList1.add(var1);
            if (var1 instanceof Parameter) {
                this.parametersConflicted = true;
                if (VariableStorageConflicts.addAllParameters(variables1, overlapList1, set1, this.nonOverlappingVariables1)) {
                    this.getOverlappingVariables(var1.getFirstUseOffset(), variables1, set1, overlapList1, variables2, set2, overlapList2, monitor);
                }
            }
            Pair pair = new Pair(overlapList1, overlapList2);
            this.overlappingVariables.add((Pair<List<Variable>, List<Variable>>)pair);
            overlapList1 = null;
            overlapList2 = null;
            set1 = null;
            set2 = null;
        }
    }

    private void getOverlappingVariables(int firstUseOffset, List<Variable> variables1, AddressSet set1, List<Variable> overlapList1, List<Variable> variables2, AddressSet set2, List<Variable> overlapList2, TaskMonitor monitor) throws CancelledException {
        boolean expanded = true;
        while (expanded) {
            int i;
            expanded = false;
            for (i = 0; !set1.isEmpty() && i < variables2.size(); ++i) {
                expanded |= this.findOverlaps(firstUseOffset, variables2, i, overlapList2, set2, this.nonOverlappingVariables2, set1);
            }
            for (i = 0; !set2.isEmpty() && i < variables1.size(); ++i) {
                monitor.checkCancelled();
                expanded |= this.findOverlaps(firstUseOffset, variables1, i, overlapList1, set1, this.nonOverlappingVariables1, set2);
            }
        }
    }

    private boolean findOverlaps(int firstUseOffset, List<Variable> variables, int index, List<Variable> overlapList, AddressSet overlapSet, List<Variable> nonOverlapList, AddressSetView intersectSet) {
        Variable var = variables.get(index);
        if (var == null) {
            return false;
        }
        if (var.getFirstUseOffset() != firstUseOffset) {
            return false;
        }
        if (this.paramOnlyAddressSets && this.ignoreParamToParamConflicts && var instanceof Parameter) {
            return false;
        }
        boolean expanded = false;
        VariableStorage storage = var.getVariableStorage();
        if (storage.intersects(intersectSet)) {
            expanded |= true;
            this.paramOnlyAddressSets = false;
            variables.set(index, null);
            VariableStorageConflicts.addToAddressSet(overlapSet, storage);
            overlapList.add(var);
            if (var instanceof Parameter) {
                this.parametersConflicted = true;
                VariableStorageConflicts.addAllParameters(variables, overlapList, overlapSet, nonOverlapList);
            }
        }
        return expanded;
    }

    private static boolean addAllParameters(List<Variable> variables, List<Variable> overlapList, AddressSet overlapSet, List<Variable> nonOverlapList) {
        Variable v;
        boolean parametersAdded = false;
        for (int i = 0; i < variables.size(); ++i) {
            v = variables.get(i);
            if (!(v instanceof Parameter)) continue;
            variables.set(i, null);
            VariableStorageConflicts.addToAddressSet(overlapSet, v.getVariableStorage());
            overlapList.add(v);
            parametersAdded = true;
        }
        Iterator<Variable> iter = nonOverlapList.iterator();
        while (iter.hasNext()) {
            v = iter.next();
            if (!(v instanceof Parameter)) continue;
            iter.remove();
            VariableStorageConflicts.addToAddressSet(overlapSet, v.getVariableStorage());
            overlapList.add(v);
            parametersAdded = true;
        }
        return parametersAdded;
    }

    private static void addToAddressSet(AddressSet set, VariableStorage storage) {
        List<Register> registers = storage.getRegisters();
        if (registers != null) {
            for (Register reg : registers) {
                Address minAddr = reg.getAddress();
                Address maxAddr = minAddr.add(reg.getMinimumByteSize() - 1);
                set.addRange(minAddr, maxAddr);
            }
        }
        for (Varnode varnode : storage.getVarnodes()) {
            Address minAddr = varnode.getAddress();
            Address maxAddr = minAddr.add(varnode.getSize() - 1);
            set.addRange(minAddr, maxAddr);
        }
    }

    public List<Pair<List<Variable>, List<Variable>>> getOverlappingVariables() {
        return this.overlappingVariables;
    }

    public boolean hasOverlapConflict() {
        return !this.overlappingVariables.isEmpty();
    }

    public boolean hasParameterConflict() {
        return this.parametersConflicted;
    }

    public boolean isConflicted(Variable var1, Variable var2) {
        for (Pair<List<Variable>, List<Variable>> pair : this.overlappingVariables) {
            if (var1 != null && this.containsVariable((List)pair.first, var1)) {
                return true;
            }
            if (var2 == null || !this.containsVariable((List)pair.second, var2)) continue;
            return true;
        }
        return false;
    }

    private boolean containsVariable(List<Variable> list, Variable var) {
        for (Variable v : list) {
            if (!var.equals(v)) continue;
            return true;
        }
        return false;
    }

    private Parameter removeMatchingParameter(Parameter var, List<Variable> list) {
        int ordinal = var.getOrdinal();
        VariableStorage storage = var.getVariableStorage();
        Iterator<Variable> iter = list.iterator();
        while (iter.hasNext()) {
            Variable v = iter.next();
            if (!(v instanceof Parameter) || ordinal != ((Parameter)v).getOrdinal() || !storage.equals(v.getVariableStorage())) continue;
            iter.remove();
            return (Parameter)v;
        }
        return null;
    }

    private Variable removeMatchingVariable(Variable var, List<Variable> list) {
        int firstUse = var.getFirstUseOffset();
        VariableStorage storage = var.getVariableStorage();
        Iterator<Variable> iter = list.iterator();
        while (iter.hasNext()) {
            Variable v = iter.next();
            if (v == null || v instanceof Parameter || firstUse != v.getFirstUseOffset() || !storage.equals(v.getVariableStorage())) continue;
            iter.remove();
            return v;
        }
        return null;
    }
}

