/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.ExeSpecifier;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ResponseDelete
extends QueryResponseRecord {
    public List<DeleteResult> reslist = new ArrayList<DeleteResult>();
    public List<ExeSpecifier> missedlist = new ArrayList<ExeSpecifier>();

    public ResponseDelete() {
        super("responsedelete");
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        Iterator<DeleteResult> iter = this.reslist.iterator();
        while (iter.hasNext()) {
            iter.next().saveXml(fwrite);
        }
        Iterator<ExeSpecifier> miter = this.missedlist.iterator();
        while (miter.hasNext()) {
            miter.next().saveXml(fwrite);
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        this.reslist = new ArrayList<DeleteResult>();
        this.missedlist = new ArrayList<ExeSpecifier>();
        parser.start(new String[]{this.name});
        while (parser.peek().isStart()) {
            XmlElement el = parser.peek();
            if (el.getName().equals("delrec")) {
                DeleteResult res = new DeleteResult();
                res.restoreXml(parser);
                this.reslist.add(res);
                continue;
            }
            ExeSpecifier spec = new ExeSpecifier();
            spec.restoreXml(parser);
        }
        parser.end();
    }

    public static class DeleteResult {
        public String md5;
        public String name;
        public int funccount;

        public void saveXml(Writer fwrite) throws IOException {
            fwrite.append("<delrec>\n");
            fwrite.append(" <md5>").append(this.md5).append("</md5>\n");
            fwrite.append(" <name>");
            SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.name);
            fwrite.append("</name>\n");
            fwrite.append(" <count>").append(SpecXmlUtils.encodeSignedInteger((long)this.funccount)).append("</count>\n");
            fwrite.append("</delrec>\n");
        }

        public void restoreXml(XmlPullParser parser) {
            parser.start(new String[]{"delrec"});
            parser.start(new String[]{"md5"});
            this.md5 = parser.end().getText();
            parser.start(new String[]{"name"});
            this.name = parser.end().getText();
            parser.start(new String[]{"count"});
            this.funccount = SpecXmlUtils.decodeInt((String)parser.end().getText());
            parser.end();
        }
    }
}

