/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.IsolateVariableTask;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighLocal;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.HelpLocation;
import ghidra.util.UndefinedFunction;

public class IsolateVariableAction
extends AbstractDecompilerAction {
    public IsolateVariableAction() {
        super("Split Out As New Variable");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionIsolate"));
        this.setPopupMenuData(new MenuData(new String[]{"Split Out As New Variable"}, "Decompile"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        HighVariable variable = tokenAtCursor.getHighVariable();
        if (!(variable instanceof HighLocal)) {
            return false;
        }
        HighSymbol highSymbol = variable.getSymbol();
        if (highSymbol == null) {
            return false;
        }
        if (highSymbol.isIsolated()) {
            return false;
        }
        Varnode vn = tokenAtCursor.getVarnode();
        if (vn == null) {
            return false;
        }
        short mergeGroup = vn.getMergeGroup();
        boolean mergeSplit = false;
        for (Varnode var : variable.getInstances()) {
            if (var.getMergeGroup() == mergeGroup) continue;
            mergeSplit = true;
            break;
        }
        return mergeSplit;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        HighSymbol highSymbol = tokenAtCursor.getHighVariable().getSymbol();
        IsolateVariableTask newVariableTask = new IsolateVariableTask(context.getTool(), context.getProgram(), context.getComponentProvider(), tokenAtCursor, highSymbol, SourceType.USER_DEFINED);
        newVariableTask.runTask(false);
    }
}

