/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

public class RedBlackNode<K, V> {
    K key;
    V value;
    NodeColor color;
    RedBlackNode<K, V> parent;
    RedBlackNode<K, V> left;
    RedBlackNode<K, V> right;

    RedBlackNode(K key, V value, RedBlackNode<K, V> parent) {
        this.key = key;
        this.value = value;
        this.parent = parent;
        this.color = NodeColor.BLACK;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public RedBlackNode<K, V> getSuccessor() {
        if (this.right != null) {
            RedBlackNode<K, V> node = this.right;
            while (node.left != null) {
                node = node.left;
            }
            return node;
        }
        RedBlackNode<K, V> node = this;
        while (node.parent != null) {
            if (node.isLeftChild()) {
                return node.parent;
            }
            node = node.parent;
        }
        return null;
    }

    public RedBlackNode<K, V> getPredecessor() {
        if (this.left != null) {
            RedBlackNode<K, V> node = this.left;
            while (node.right != null) {
                node = node.right;
            }
            return node;
        }
        RedBlackNode<K, V> node = this;
        while (node.parent != null) {
            if (!node.isLeftChild()) {
                return node.parent;
            }
            node = node.parent;
        }
        return null;
    }

    boolean isLeftChild() {
        return this.parent.left == this;
    }

    boolean isRightChild() {
        return this.parent.right == this;
    }

    static enum NodeColor {
        RED,
        BLACK;

    }
}

