/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.memstate;

import ghidra.pcode.memstate.MemoryFaultHandler;
import ghidra.pcode.memstate.MemoryPage;
import ghidra.program.model.address.AddressSpace;

public abstract class MemoryBank {
    private final int pagesize;
    private final AddressSpace space;
    private final boolean isBigEndian;
    private final int initializedMaskSize;
    protected final MemoryFaultHandler faultHandler;

    public MemoryBank(AddressSpace spc, boolean isBigEndian, int ps, MemoryFaultHandler faultHandler) {
        this.space = spc;
        this.pagesize = ps;
        this.isBigEndian = isBigEndian;
        this.faultHandler = faultHandler;
        this.initializedMaskSize = (ps + 7) / 8;
    }

    public MemoryFaultHandler getMemoryFaultHandler() {
        return this.faultHandler;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public int getPageSize() {
        return this.pagesize;
    }

    public int getInitializedMaskSize() {
        return this.initializedMaskSize;
    }

    public AddressSpace getSpace() {
        return this.space;
    }

    protected abstract MemoryPage getPage(long var1);

    protected abstract void setPage(long var1, byte[] var3, int var4, int var5, int var6);

    protected abstract void setPageInitialized(long var1, boolean var3, int var4, int var5, int var6);

    public void setChunk(long offset, int size, byte[] val) {
        long pagemask = this.pagesize - 1;
        int bufOffset = 0;
        int count = 0;
        while (count < size) {
            int cursize = this.pagesize;
            offset = this.space.truncateOffset(offset);
            long offalign = offset & (pagemask ^ 0xFFFFFFFFFFFFFFFFL);
            int skip = 0;
            if (offalign != offset) {
                skip = (int)(offset - offalign);
                cursize -= skip;
            }
            if (size - count < cursize) {
                cursize = size - count;
            }
            this.setPage(offalign, val, skip, cursize, bufOffset);
            count += cursize;
            offset += (long)cursize;
            bufOffset += cursize;
        }
    }

    public void setInitialized(long offset, int size, boolean initialized) {
        long pagemask = this.pagesize - 1;
        int bufOffset = 0;
        int count = 0;
        while (count < size) {
            int cursize = this.pagesize;
            long offalign = offset & (pagemask ^ 0xFFFFFFFFFFFFFFFFL);
            int skip = 0;
            if (offalign != offset) {
                skip = (int)(offset - offalign);
                cursize -= skip;
            }
            if (size - count < cursize) {
                cursize = size - count;
            }
            this.setPageInitialized(offalign, initialized, skip, cursize, bufOffset);
            count += cursize;
            offset += (long)cursize;
            bufOffset += cursize;
        }
    }

    public int getChunk(long addrOffset, int size, byte[] res, boolean stopOnUnintialized) {
        long pagemask = this.pagesize - 1;
        int bufOffset = 0;
        addrOffset = this.space.truncateOffset(addrOffset);
        int count = 0;
        while (count < size) {
            int cursize = this.pagesize;
            long offalign = addrOffset & (pagemask ^ 0xFFFFFFFFFFFFFFFFL);
            int skip = 0;
            if (offalign != addrOffset) {
                skip = (int)(addrOffset - offalign);
                cursize -= skip;
            }
            if (size - count < cursize) {
                cursize = size - count;
            }
            MemoryPage page = this.getPage(offalign);
            int initializedByteCount = page.getInitializedByteCount(skip, cursize);
            System.arraycopy(page.data, skip, res, bufOffset, initializedByteCount);
            count += initializedByteCount;
            long nextAddrOffset = this.space.truncateOffset(addrOffset + (long)initializedByteCount);
            addrOffset += (long)initializedByteCount;
            bufOffset += initializedByteCount;
            if ((cursize -= initializedByteCount) != 0) {
                if (this.faultHandler.uninitializedRead(this.getSpace().getAddress(offalign + (long)(skip += initializedByteCount)), cursize, page.data, skip)) {
                    page.setInitialized(skip, cursize);
                } else if (stopOnUnintialized) {
                    return count;
                }
                System.arraycopy(page.data, skip, res, bufOffset, cursize);
                count += cursize;
                nextAddrOffset = this.space.truncateOffset(nextAddrOffset + (long)cursize);
                addrOffset += (long)cursize;
                bufOffset += cursize;
            }
            if (!(addrOffset < 0L ? nextAddrOffset > 0L : nextAddrOffset < addrOffset)) continue;
            break;
        }
        return count;
    }

    public static long constructValue(byte[] ptr, int offset, int size, boolean bigendian) {
        long res = 0L;
        if (bigendian) {
            for (int i = 0; i < size; ++i) {
                res <<= 8;
                res |= (long)ptr[i + offset] & 0xFFL;
            }
        } else {
            for (int i = size - 1; i >= 0; --i) {
                res <<= 8;
                res |= (long)ptr[i + offset] & 0xFFL;
            }
        }
        return res;
    }

    public static void deconstructValue(byte[] ptr, int offset, long val, int size, boolean bigendian) {
        if (bigendian) {
            for (int i = size - 1; i >= 0; --i) {
                ptr[i + offset] = (byte)(val & 0xFFL);
                val >>= 8;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                ptr[i + offset] = (byte)(val & 0xFFL);
                val >>= 8;
            }
        }
    }
}

