/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.diff;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.widgets.checkbox.GCheckBox;
import generic.theme.GIcon;
import generic.theme.Gui;
import ghidra.app.plugin.core.diff.ProgramDiffPlugin;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.SwingUpdateManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import resources.Icons;

public class DiffDetailsProvider
extends ComponentProviderAdapter {
    public static final String DIFF_DETAILS_HIDDEN_ACTION = "Diff Details Hidden";
    public static final String AUTO_UPDATE_CHECK_BOX = "Auto Update Check Box";
    public static final String FILTER_DIFFS_CHECK_BOX = "Filter Diffs Check Box";
    public static final String DIFF_DETAILS_TEXT_AREA = "Diff Details Text Area";
    public static final String DIFF_DETAILS_PANEL = "Diff Location Details Panel";
    public static final Icon ICON = new GIcon("icon.search");
    public static final Icon REFRESH_ICON = Icons.REFRESH_ICON;
    public static final String TITLE = "Diff Details";
    private ProgramDiffPlugin plugin;
    private JTextPane textPane;
    private StyledDocument doc;
    private JCheckBox filterDiffsCB;
    private JCheckBox autoUpdateCB;
    private boolean filterDiffs = false;
    private boolean autoUpdate = false;
    private JComponent detailsPanel;
    private ArrayList<ActionListener> listenerList = new ArrayList();
    private ProgramLocation p1DetailsLocation;
    private AddressSetView detailsAddrSet;
    private boolean isDisplayed = false;
    private SwingUpdateManager updateManager;
    private ProgramLocation currentLocation;

    public DiffDetailsProvider(ProgramDiffPlugin plugin) {
        super(plugin.getTool(), "Diff Location Details", plugin.getName());
        this.setTitle(TITLE);
        this.plugin = plugin;
        this.setIcon(ICON);
        this.setTransient();
        this.setWindowMenuGroup("Diff");
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setHelpLocation(new HelpLocation("Diff", "Diff_Location_Details"));
        this.detailsPanel = this.createDiffDetailsPanel();
        this.detailsPanel.setName(DIFF_DETAILS_PANEL);
        this.setAutoUpdate(true);
        this.setFilterDiffs(false);
        this.setUpRefreshDetailsUpdateManager();
    }

    public void setAutoUpdate(boolean selected) {
        this.autoUpdateCB.setSelected(selected);
        this.autoUpdate = selected;
    }

    public void setFilterDiffs(boolean selected) {
        this.filterDiffsCB.setSelected(selected);
        this.filterDiffs = selected;
    }

    public void addActions() {
        DockingAction refreshDetailsAction = new DockingAction("Refresh Diff Details", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                DiffDetailsProvider.this.refreshDetails(DiffDetailsProvider.this.plugin.getCurrentLocation());
            }
        };
        refreshDetailsAction.setDescription("Refresh the details to show any differences at the current location.");
        refreshDetailsAction.setEnabled(true);
        refreshDetailsAction.setToolBarData(new ToolBarData(REFRESH_ICON, "Diff"));
        refreshDetailsAction.setHelpLocation(new HelpLocation("Diff", "Refresh Diff Details"));
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)refreshDetailsAction);
    }

    private void createAutoUpdateCheckBox() {
        this.autoUpdateCB = new GCheckBox("Automatically Update Details", false);
        this.autoUpdateCB.setName(AUTO_UPDATE_CHECK_BOX);
        this.autoUpdateCB.addActionListener(e -> {
            this.autoUpdate = this.autoUpdateCB.isSelected();
            if (this.autoUpdate) {
                this.refreshDetails(this.plugin.getCurrentLocation());
            }
        });
    }

    private void createFilterDiffsCheckBox() {
        this.filterDiffsCB = new GCheckBox("Only Show Expected Difference Types", false);
        this.filterDiffsCB.setName(FILTER_DIFFS_CHECK_BOX);
        this.filterDiffsCB.addActionListener(e -> {
            this.filterDiffs = this.filterDiffsCB.isSelected();
            if (this.autoUpdateCB.isSelected()) {
                this.refreshDetails(this.plugin.getCurrentLocation());
            }
        });
    }

    protected void locationChanged(ProgramLocation p1Location) {
        if (this.isDisplayed && this.autoUpdate) {
            this.refreshDetails(p1Location);
        }
    }

    void refreshDetails(ProgramLocation p1Location) {
        if (p1Location == null) {
            return;
        }
        this.currentLocation = p1Location;
        this.updateManager.update();
    }

    private void setUpRefreshDetailsUpdateManager() {
        this.updateManager = new SwingUpdateManager(100, 4000, () -> this.doRefreshDetails(this.currentLocation));
    }

    private void doRefreshDetails(ProgramLocation p1Location) {
        AddressSetView newAddrSet;
        if (p1Location == null) {
            return;
        }
        if (!this.isDisplayed) {
            return;
        }
        Program p1 = p1Location.getProgram();
        if (p1 != this.plugin.getFirstProgram() && p1 != this.plugin.getSecondProgram()) {
            return;
        }
        if (this.p1DetailsLocation != p1Location) {
            this.p1DetailsLocation = p1Location;
        }
        if ((newAddrSet = this.getDetailsAddressSet(this.p1DetailsLocation)) == null) {
            this.setDocumentToErrorMessage("Must have a second program open to determine Diff details.");
            return;
        }
        if (!newAddrSet.equals((Object)this.detailsAddrSet)) {
            this.detailsAddrSet = newAddrSet;
        }
        Address p1Address = this.p1DetailsLocation.getAddress();
        try {
            if (this.filterDiffs) {
                this.getFilteredDiffDetails(p1Address);
            } else {
                this.getDiffDetails(p1Address);
            }
        }
        catch (ConcurrentModificationException e) {
            this.setDocumentToErrorMessage("Failed to determine Diff Details due to concurrent program changes.\nThis may be caused by background analysis activity.\n *** Press the Refresh button to update *** ");
        }
    }

    private void setDocumentToErrorMessage(String message) {
        try {
            this.doc.remove(0, this.doc.getLength());
            this.doc.insertString(0, message, new SimpleAttributeSet());
            this.textPane.setCaretPosition(0);
        }
        catch (BadLocationException e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    private void getDiffDetails(Address p1Address) {
        this.plugin.addDiffDetails(p1Address, this.doc);
        this.textPane.setCaretPosition(0);
    }

    private void getFilteredDiffDetails(Address p1Address) {
        this.plugin.addFilteredDiffDetails(p1Address, this.plugin.getDiffController().getDiffFilter(), this.doc);
        this.textPane.setCaretPosition(0);
    }

    private AddressSetView getDetailsAddressSet(ProgramLocation p1Location) {
        Address p1Address = p1Location.getAddress();
        return this.plugin.getDetailsAddressSet(p1Address);
    }

    private JPanel createDiffDetailsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(600, 400));
        JScrollPane scrolledDetails = this.createDetailsPane();
        panel.add((Component)scrolledDetails, "Center");
        this.createAutoUpdateCheckBox();
        this.createFilterDiffsCheckBox();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(this.autoUpdateCB);
        bottomPanel.add(Box.createHorizontalStrut(10));
        bottomPanel.add(this.filterDiffsCB);
        bottomPanel.add(Box.createHorizontalGlue());
        panel.add((Component)bottomPanel, "South");
        return panel;
    }

    private JScrollPane createDetailsPane() {
        this.textPane = new JTextPane();
        this.doc = this.textPane.getStyledDocument();
        this.textPane.setName(DIFF_DETAILS_TEXT_AREA);
        this.textPane.setEditable(false);
        this.textPane.setMargin(new Insets(5, 5, 5, 5));
        Gui.registerFont((Component)this.textPane, (String)"font.monospaced");
        this.textPane.setOpaque(true);
        this.textPane.setCaretPosition(0);
        JScrollPane scrolledDetails = new JScrollPane(this.textPane);
        JViewport vp = scrolledDetails.getViewport();
        vp.add(this.textPane);
        return scrolledDetails;
    }

    StyledDocument getStyledDocument() {
        return this.doc;
    }

    public void componentHidden() {
        for (ActionListener listener : this.listenerList) {
            listener.actionPerformed(new ActionEvent((Object)this, 0, DIFF_DETAILS_HIDDEN_ACTION));
        }
        this.isDisplayed = false;
        this.p1DetailsLocation = null;
    }

    public void componentShown() {
        this.isDisplayed = true;
        this.refreshDetails(this.plugin.getProgramLocation());
    }

    public void closeComponent() {
        this.plugin.getTool().showComponentProvider((ComponentProvider)this, false);
    }

    public JComponent getComponent() {
        return this.detailsPanel;
    }

    Plugin getPlugin() {
        return this.plugin;
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(listener);
    }
}

