#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-theory
version:              1.10.0
visibility:           public
id:                   tamarin-prover-theory-1.10.0-B343wTQjW1PB1xylIhass1
key:                  tamarin-prover-theory-1.10.0-B343wTQjW1PB1xylIhass1
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Cas Cremers, Jannik Dreier, Ralf Sasse, 2010-2023

maintainer:
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>
    Cas Cremers <cremers@cispa.de>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:
    Security protocol types and constraint solver library for the tamarin prover.

description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides the types to represent security
    protocols, and it implements the constraint solver.

category:             Theorem Provers
abi:                  2d734de7d53f04367e3891d892c309ae
exposed:              True
exposed-modules:
    ClosedTheory Items.AccLemmaItem Items.CaseTestItem Items.ExportInfo
    Items.LemmaItem Items.OpenTheoryItem Items.OptionItem
    Items.ProcessItem Items.RuleItem Items.TheoryItem Lemma OpenTheory
    Pretty Prover Rule Theory Theory.Constraint.Solver
    Theory.Constraint.Solver.AnnotatedGoals
    Theory.Constraint.Solver.Contradictions
    Theory.Constraint.Solver.Goals Theory.Constraint.Solver.ProofMethod
    Theory.Constraint.Solver.Reduction
    Theory.Constraint.Solver.Simplify Theory.Constraint.Solver.Sources
    Theory.Constraint.System Theory.Constraint.System.Constraints
    Theory.Constraint.System.Dot
    Theory.Constraint.System.Graph.Abbreviation
    Theory.Constraint.System.Graph.Graph
    Theory.Constraint.System.Graph.GraphRepr
    Theory.Constraint.System.Graph.Simplification
    Theory.Constraint.System.Guarded Theory.Constraint.System.JSON
    Theory.Model Theory.Model.Atom Theory.Model.Fact
    Theory.Model.Formula Theory.Model.Restriction Theory.Model.Rule
    Theory.Model.Signature Theory.Module Theory.Proof
    Theory.ProofSkeleton Theory.Sapic Theory.Sapic.Annotation
    Theory.Sapic.Pattern Theory.Sapic.Position Theory.Sapic.Print
    Theory.Sapic.Process Theory.Sapic.Term Theory.Text.Parser
    Theory.Text.Parser.Macro Theory.Text.Parser.Restriction
    Theory.Text.Parser.Signature Theory.Text.Parser.Token
    Theory.Text.Pretty Theory.Tools.AbstractInterpretation
    Theory.Tools.EquationStore Theory.Tools.InjectiveFactInstances
    Theory.Tools.IntruderRules Theory.Tools.LoopBreakers
    Theory.Tools.MessageDerivationChecks Theory.Tools.RuleVariants
    Theory.Tools.SubtermStore Theory.Tools.Wellformedness TheoryObject

hidden-modules:
    Theory.Syntactic.Predicate Theory.Text.Parser.Accountability
    Theory.Text.Parser.Exceptions Theory.Text.Parser.Fact
    Theory.Text.Parser.Formula Theory.Text.Parser.Lemma
    Theory.Text.Parser.Let Theory.Text.Parser.Proof
    Theory.Text.Parser.Rule Theory.Text.Parser.Sapic
    Theory.Text.Parser.Tactics Theory.Text.Parser.Term
    Theory.Sapic.PlainProcess Theory.Sapic.Substitution

import-dirs:          /usr/lib/ghc-9.6.6/site-local/tamarin-prover-theory-1.10.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/tamarin-prover-theory-1.10.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/tamarin-prover-theory-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-theory
hs-libraries:         HStamarin-prover-theory-1.10.0-B343wTQjW1PB1xylIhass1
depends:
    aeson-2.2.0.0-4qLATSA6nfj1RfgXH6DMKK
    aeson-pretty-0.8.10-LSDchJgtnQ46sIK4bUu3co array-0.5.6.0
    attoparsec-0.14.4-FIfeiNzOKYm3sEc1QPF51Z base-4.18.2.1
    binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.1
    directory-1.3.8.5 dlist-1.0-B7D1vsARFiIHVaGk5CGbYO
    exceptions-0.10.7 fclabels-2.0.5.1-7N0HCwWfRM0Bq8M2ZnpsmD
    filepath-1.4.300.1 mtl-2.3.1
    parallel-3.2.2.0-4GFGhbl8Ae06nPoqdIyBUD parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.19.0
    regex-pcre-0.95.0.1-Cp22cHlfz6kFUZgDY8Q3Ru
    regex-posix-0.96.0.2-LsCmj8tXKerCmkZ6TKO5qF
    safe-0.3.21-WYqCEMpsX24yfPdI1X0Hh
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8
    tamarin-prover-term-1.10.0-K1DwPJWoWIKF5CFDcqNbBl
    tamarin-prover-utils-1.10.0-6O4xovRc5rA2UtTdwPacBp text-2.0.2
    transformers-0.6.1.0 uniplate-1.6.13-3P4N77JJWXwIhcpvSX1zzA

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-theory/html/tamarin-prover-theory.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-theory/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

