/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.coroutines;

import com.intellij.rt.debugger.JsonUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class CoroutinesDebugHelper {
    private static final String COROUTINE_OWNER_CLASS = "CoroutineOwner";
    private static final String DEBUG_METADATA_FQN = "kotlin.coroutines.jvm.internal.DebugMetadataKt";
    private static final String BASE_CONTINUATION_FQN = "kotlin.coroutines.jvm.internal.BaseContinuationImpl";
    private static final String COROUTINE_STACK_FRAME_FQN = "kotlin.coroutines.jvm.internal.CoroutineStackFrame";
    private static final String DEBUG_COROUTINE_INFO_FQN = "kotlinx.coroutines.debug.internal.DebugCoroutineInfo";
    private static final String COROUTINE_CONTEXT_FQN = "kotlin.coroutines.CoroutineContext";
    private static final String COROUTINE_JOB_FQN = "kotlinx.coroutines.Job";
    private static final String COROUTINE_CONTEXT_KEY_FQN = "kotlin.coroutines.CoroutineContext$Key";

    public static long[] getCoroutinesRunningOnCurrentThread(Object debugProbes, Thread currentThread) throws ReflectiveOperationException {
        ArrayList<Long> coroutinesIds = new ArrayList<Long>();
        List infos = (List)CoroutinesDebugHelper.invoke(debugProbes, "dumpCoroutinesInfo");
        for (Object info : infos) {
            if (CoroutinesDebugHelper.invoke(info, "getLastObservedThread") != currentThread) continue;
            coroutinesIds.add((Long)CoroutinesDebugHelper.invoke(info, "getSequenceNumber"));
        }
        long[] res = new long[coroutinesIds.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Long)coroutinesIds.get(i);
        }
        return res;
    }

    public static long tryGetContinuationId(Object continuation) throws ReflectiveOperationException {
        Object rootContinuation = CoroutinesDebugHelper.getCoroutineOwner(continuation, true);
        if (CoroutinesDebugHelper.isCoroutineOwner(rootContinuation)) {
            Object debugCoroutineInfo = CoroutinesDebugHelper.getField(rootContinuation, "info");
            return (Long)CoroutinesDebugHelper.getField(debugCoroutineInfo, "sequenceNumber");
        }
        return -1L;
    }

    private static Object getCoroutineOwner(Object continuation, boolean checkForCoroutineOwner) throws ReflectiveOperationException {
        Method getCallerFrame = Class.forName(COROUTINE_STACK_FRAME_FQN, false, continuation.getClass().getClassLoader()).getDeclaredMethod("getCallerFrame", new Class[0]);
        getCallerFrame.setAccessible(true);
        Object current = continuation;
        while (true) {
            if (checkForCoroutineOwner && CoroutinesDebugHelper.isCoroutineOwner(current)) {
                return current;
            }
            Object parentFrame = getCallerFrame.invoke(current, new Object[0]);
            if (parentFrame == null) break;
            current = parentFrame;
        }
        return current;
    }

    public static Object getRootContinuation(Object continuation) throws ReflectiveOperationException {
        return CoroutinesDebugHelper.getCoroutineOwner(continuation, false);
    }

    public static Object getCallerFrame(Object continuation) throws ReflectiveOperationException {
        Class<?> coroutineStackFrame = Class.forName(COROUTINE_STACK_FRAME_FQN, false, continuation.getClass().getClassLoader());
        Method getCallerFrame = coroutineStackFrame.getDeclaredMethod("getCallerFrame", new Class[0]);
        getCallerFrame.setAccessible(true);
        Object callerFrame = getCallerFrame.invoke(continuation, new Object[0]);
        if (callerFrame == null || CoroutinesDebugHelper.isCoroutineOwner(callerFrame)) {
            return continuation;
        }
        Class<?> scopeCoroutine = Class.forName("kotlinx.coroutines.internal.ScopeCoroutine", false, continuation.getClass().getClassLoader());
        if (scopeCoroutine.isInstance(callerFrame)) {
            return getCallerFrame.invoke(callerFrame, new Object[0]);
        }
        return callerFrame;
    }

    public static Object[] getCoroutineStackTraceDump(Object continuation) throws ReflectiveOperationException {
        ArrayList<Object> continuationStack = new ArrayList<Object>();
        ArrayList<StackTraceElement> continuationStackElements = new ArrayList<StackTraceElement>();
        ArrayList<List<String>> variableNames = new ArrayList<List<String>>();
        ArrayList<List<String>> fieldNames = new ArrayList<List<String>>();
        ClassLoader loader = continuation.getClass().getClassLoader();
        Class<?> debugMetadata = Class.forName(DEBUG_METADATA_FQN, false, loader);
        Class<?> baseContinuation = Class.forName(BASE_CONTINUATION_FQN, false, loader);
        Class<?> coroutineStackFrame = Class.forName(COROUTINE_STACK_FRAME_FQN, false, loader);
        Method getStackTraceElement = coroutineStackFrame.getDeclaredMethod("getStackTraceElement", new Class[0]);
        Method callerFrame = coroutineStackFrame.getDeclaredMethod("getCallerFrame", new Class[0]);
        Method getSpilledVariableFieldMapping = debugMetadata.getDeclaredMethod("getSpilledVariableFieldMapping", baseContinuation);
        getSpilledVariableFieldMapping.setAccessible(true);
        Object current = continuation;
        while (current != null && coroutineStackFrame.isInstance(current) && !CoroutinesDebugHelper.isCoroutineOwner(current)) {
            StackTraceElement stackTraceElement = (StackTraceElement)getStackTraceElement.invoke(current, new Object[0]);
            continuationStackElements.add(stackTraceElement);
            if (baseContinuation.isInstance(current)) {
                ArrayList<String> fields = new ArrayList<String>();
                ArrayList<String> names = new ArrayList<String>();
                CoroutinesDebugHelper.extractSpilledVariables(current, names, fields, getSpilledVariableFieldMapping);
                variableNames.add(names);
                fieldNames.add(fields);
            } else {
                variableNames.add(Collections.emptyList());
                fieldNames.add(Collections.emptyList());
            }
            continuationStack.add(current);
            current = CoroutinesDebugHelper.invoke(current, callerFrame, new Object[0]);
        }
        List creationStack = null;
        if (current != null && CoroutinesDebugHelper.isCoroutineOwner(current)) {
            Object debugCoroutineInfo = CoroutinesDebugHelper.getField(current, "info");
            creationStack = (List)CoroutinesDebugHelper.invoke(debugCoroutineInfo, "getCreationStackTrace");
        }
        String json = JsonUtils.dumpCoroutineStackTraceDumpToJson(continuationStackElements, variableNames, fieldNames, creationStack);
        return new Object[]{json, continuationStack.toArray()};
    }

    private static void extractSpilledVariables(Object continuation, List<String> variableNames, List<String> fieldNames, Method getSpilledVariableFieldMapping) throws ReflectiveOperationException {
        String[] mapping = (String[])getSpilledVariableFieldMapping.invoke(null, continuation);
        if (mapping == null) {
            return;
        }
        for (int i = 0; i < mapping.length; i += 2) {
            fieldNames.add(mapping[i]);
            variableNames.add(mapping[i + 1]);
        }
    }

    private static boolean isCoroutineOwner(Object current) {
        return current.getClass().getSimpleName().contains(COROUTINE_OWNER_CLASS);
    }

    public static Object[] dumpCoroutinesInfoAsJsonAndReferences() throws ReflectiveOperationException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> debugProbesImplClass = classLoader.loadClass("kotlinx.coroutines.debug.internal.DebugProbesImpl");
            Object debugProbesImplInstance = debugProbesImplClass.getField("INSTANCE").get(null);
            Object[] infos = (Object[])CoroutinesDebugHelper.invoke(debugProbesImplInstance, "dumpCoroutinesInfoAsJsonAndReferences");
            return infos;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Object[] dumpCoroutinesWithStacktracesAsJson() throws ReflectiveOperationException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> debugProbesImplClass = classLoader.loadClass("kotlinx.coroutines.debug.internal.DebugProbesImpl");
            Object debugProbesImplInstance = debugProbesImplClass.getField("INSTANCE").get(null);
            Object[] dump = (Object[])CoroutinesDebugHelper.invoke(debugProbesImplInstance, "dumpCoroutinesInfoAsJsonAndReferences");
            Object[] coroutineInfos = (Object[])dump[3];
            String[] lastObservedStackTraces = new String[coroutineInfos.length];
            for (int i = 0; i < coroutineInfos.length; ++i) {
                lastObservedStackTraces[i] = CoroutinesDebugHelper.lastObservedStackTrace(coroutineInfos[i]);
            }
            dump = Arrays.copyOf(dump, dump.length + 1);
            dump[4] = lastObservedStackTraces;
            return dump;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String lastObservedStackTrace(Object debugCoroutineInfo) throws ReflectiveOperationException {
        List stackTrace = (List)CoroutinesDebugHelper.invoke(debugCoroutineInfo, "lastObservedStackTrace");
        return JsonUtils.dumpStackTraceElements(stackTrace);
    }

    public static String[] getJobsAndParentsForCoroutines(Object ... debugCoroutineInfos) throws ReflectiveOperationException {
        if (debugCoroutineInfos.length == 0) {
            return new String[0];
        }
        ClassLoader loader = debugCoroutineInfos[0].getClass().getClassLoader();
        Class<?> debugCoroutineInfoClass = Class.forName(DEBUG_COROUTINE_INFO_FQN, false, loader);
        Class<?> coroutineContext = Class.forName(COROUTINE_CONTEXT_FQN, false, loader);
        Class<?> coroutineContextKey = Class.forName(COROUTINE_CONTEXT_KEY_FQN, false, loader);
        Class<?> coroutineJobClass = Class.forName(COROUTINE_JOB_FQN, false, loader);
        Object coroutineJobKey = coroutineJobClass.getField("Key").get(null);
        Method coroutineContextGet = coroutineContext.getMethod("get", coroutineContextKey);
        Method getParentJob = coroutineJobClass.getMethod("getParent", new Class[0]);
        Method getContext = debugCoroutineInfoClass.getMethod("getContext", new Class[0]);
        String[] jobToCapturedParent = new String[debugCoroutineInfos.length * 2];
        HashSet<String> capturedJobs = new HashSet<String>();
        for (Object info : debugCoroutineInfos) {
            Object context = CoroutinesDebugHelper.invoke(info, getContext, new Object[0]);
            Object job = CoroutinesDebugHelper.invoke(context, coroutineContextGet, coroutineJobKey);
            capturedJobs.add(job.toString());
        }
        block1: for (int i = 0; i < debugCoroutineInfos.length * 2; i += 2) {
            Object info = debugCoroutineInfos[i / 2];
            Object context = CoroutinesDebugHelper.invoke(info, getContext, new Object[0]);
            Object job = CoroutinesDebugHelper.invoke(context, coroutineContextGet, coroutineJobKey);
            if (job == null) {
                jobToCapturedParent[i] = null;
                jobToCapturedParent[i + 1] = null;
                continue;
            }
            jobToCapturedParent[i] = job.toString();
            Object parent = CoroutinesDebugHelper.invoke(job, getParentJob, new Object[0]);
            while (parent != null) {
                if (capturedJobs.contains(parent.toString())) {
                    jobToCapturedParent[i + 1] = parent.toString();
                    continue block1;
                }
                parent = CoroutinesDebugHelper.invoke(parent, getParentJob, new Object[0]);
            }
        }
        return jobToCapturedParent;
    }

    private static Object getField(Object object, String fieldName) throws ReflectiveOperationException {
        Field field = object.getClass().getField(fieldName);
        field.setAccessible(true);
        return field.get(object);
    }

    private static Object invoke(Object object, Method method, Object ... args) throws ReflectiveOperationException {
        method.setAccessible(true);
        return method.invoke(object, args);
    }

    private static Object invoke(Object object, String methodName) throws ReflectiveOperationException {
        Method method = object.getClass().getMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return method.invoke(object, new Object[0]);
    }
}

