/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.testng.ISuite;
import org.testng.ITestResult;
import org.testng.annotations.CustomAttribute;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BasePanel;
import org.testng.reporters.jq.Model;
import org.testng.reporters.jq.ResultsByClass;
import org.testng.util.Strings;

public class SuitePanel
extends BasePanel {
    private static final String PASSED = "passed";
    private static final String SKIPPED = "skipped";
    private static final String FAILED = "failed";

    public SuitePanel(Model model) {
        super(model);
    }

    @Override
    public void generate(XMLStringBuffer xsb) {
        for (ISuite suite : this.getSuites()) {
            this.generateSuitePanel(suite, xsb);
        }
    }

    private void generateSuitePanel(ISuite suite, XMLStringBuffer xsb) {
        String divName = SuitePanel.suiteToTag(suite);
        xsb.push("div", "class", "panel " + divName, "panel-name", "suite-" + divName);
        String[] statuses = new String[]{FAILED, SKIPPED, PASSED};
        ResultsByClass[] results = new ResultsByClass[]{this.getModel().getFailedResultsByClass(suite), this.getModel().getSkippedResultsByClass(suite), this.getModel().getPassedResultsByClass(suite)};
        for (int i = 0; i < results.length; ++i) {
            ResultsByClass byClass = results[i];
            for (Class<?> c : byClass.getClasses()) {
                this.generateClassPanel(c, byClass.getResults(c), xsb, statuses[i], suite);
            }
        }
        xsb.pop("div");
    }

    private void generateClassPanel(Class<?> c, List<ITestResult> results, XMLStringBuffer xsb, String status, ISuite suite) {
        xsb.push("div", "class", "suite-" + SuitePanel.suiteToTag(suite) + "-class-" + status);
        xsb.push("div", "class", "main-panel-header rounded-window-top");
        xsb.addEmptyElement("img", "src", Model.getImage(status));
        xsb.addOptional("span", c.getName(), "class", "class-name");
        xsb.pop("div");
        xsb.push("div", "class", "main-panel-content rounded-window-bottom");
        for (ITestResult tr : results) {
            this.generateMethod(tr, xsb);
        }
        xsb.pop("div");
        xsb.pop("div");
    }

    private void generateMethod(ITestResult tr, XMLStringBuffer xsb) {
        String description;
        CustomAttribute[] attributes;
        xsb.push("div", "class", "method");
        xsb.push("div", "class", "method-content");
        xsb.push("a", "name", Model.getTestResultName(tr));
        xsb.pop("a");
        xsb.addOptional("span", tr.getMethod().getMethodName(), "class", "method-name");
        if (tr.getParameters().length > 0) {
            String text = Arrays.stream(tr.getParameters()).map(Utils::toString).collect(Collectors.joining(","));
            xsb.addOptional("span", "(" + text + ")", "class", "parameters");
        }
        if ((attributes = tr.getMethod().getAttributes()) != null && attributes.length > 0) {
            String text = Arrays.stream(attributes).map(attribute -> "{ " + attribute.name() + ", " + Arrays.toString(attribute.values()) + " }").collect(Collectors.joining(", "));
            xsb.addOptional("span", Utils.escapeHtml("(" + text + ")"), "class", "parameters");
        }
        if (tr.getStatus() != 1 && tr.getThrowable() != null) {
            xsb.addOptional("div", Utils.shortStackTrace(tr.getThrowable(), true) + "\n", "class", "stack-trace");
        }
        if (!Strings.isNullOrEmpty(description = tr.getMethod().getDescription())) {
            xsb.push("em");
            xsb.addString("(" + description + ")");
            xsb.pop("em");
        }
        xsb.pop("div");
        xsb.pop("div");
    }
}

