/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.AnchoredGroupPath;
import androidx.compose.runtime.DataIterator;
import androidx.compose.runtime.GroupIterator;
import androidx.compose.runtime.GroupSourceInformation;
import androidx.compose.runtime.SlotReader;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.SlotTableKt;
import androidx.compose.runtime.SourceInformationGroupDataIterator;
import androidx.compose.runtime.SourceInformationGroupIterator;
import androidx.compose.runtime.SourceInformationSlotTableGroupIdentity;
import androidx.compose.runtime.tooling.CompositionGroup;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010$H\u0096\u0002J\b\u0010)\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010,\u001a\u00020\u0013H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u001c\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0015R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001eR\u0014\u0010%\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\rR\u0014\u0010'\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\r\u00a8\u0006-"}, d2={"Landroidx/compose/runtime/SlotTableGroup;", "Landroidx/compose/runtime/tooling/CompositionGroup;", "", "table", "Landroidx/compose/runtime/SlotTable;", "group", "", "version", "<init>", "(Landroidx/compose/runtime/SlotTable;II)V", "getTable", "()Landroidx/compose/runtime/SlotTable;", "getGroup", "()I", "getVersion", "isEmpty", "", "()Z", "key", "", "getKey", "()Ljava/lang/Object;", "sourceInfo", "", "getSourceInfo", "()Ljava/lang/String;", "node", "getNode", "data", "getData", "()Ljava/lang/Iterable;", "identity", "getIdentity", "compositionGroups", "getCompositionGroups", "iterator", "", "groupSize", "getGroupSize", "slotsSize", "getSlotsSize", "validateRead", "", "find", "identityToFind", "runtime"})
@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotTableGroup\n+ 2 SlotTable.kt\nandroidx/compose/runtime/SlotTableKt\n+ 3 SlotTable.kt\nandroidx/compose/runtime/SlotTable\n*L\n1#1,4061:1\n3773#2:4062\n3827#2:4063\n3767#2,4:4064\n3878#2:4075\n3878#2:4076\n159#3,7:4068\n*S KotlinDebug\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotTableGroup\n*L\n3344#1:4062\n3345#1:4063\n3351#1:4064,4\n3382#1:4075\n3384#1:4076\n3362#1:4068,7\n*E\n"})
final class SlotTableGroup
implements CompositionGroup,
Iterable<CompositionGroup>,
KMappedMarker {
    @NotNull
    private final SlotTable table;
    private final int group;
    private final int version;

    public SlotTableGroup(@NotNull SlotTable table, int group, int version) {
        this.table = table;
        this.group = group;
        this.version = version;
    }

    public /* synthetic */ SlotTableGroup(SlotTable slotTable, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = slotTable.getVersion$runtime();
        }
        this(slotTable, n, n2);
    }

    @NotNull
    public final SlotTable getTable() {
        return this.table;
    }

    public final int getGroup() {
        return this.group;
    }

    public final int getVersion() {
        return this.version;
    }

    @Override
    public boolean isEmpty() {
        return SlotTableKt.access$groupSize(this.table.getGroups(), this.group) == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Object getKey() {
        Object object;
        int[] $this$hasObjectKey$iv;
        int[] nArray = this.table.getGroups();
        int address$iv = this.group;
        boolean $i$f$hasObjectKey = false;
        if (($this$hasObjectKey$iv[address$iv * 5 + 1] & 0x20000000) != 0) {
            Object object2 = this.table.getSlots()[SlotTableKt.access$objectKeyIndex(this.table.getGroups(), this.group)];
            object = object2;
            Intrinsics.checkNotNull((Object)object2);
        } else {
            void $this$key$iv;
            $this$hasObjectKey$iv = this.table.getGroups();
            address$iv = this.group;
            boolean $i$f$key = false;
            object = (int)$this$key$iv[address$iv * 5];
        }
        return object;
    }

    @Override
    @Nullable
    public String getSourceInfo() {
        GroupSourceInformation groupSourceInformation = this.table.sourceInformationOf(this.group);
        return groupSourceInformation != null ? groupSourceInformation.getSourceInformation() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object getNode() {
        Object object;
        int[] $this$isNode$iv;
        int[] nArray = this.table.getGroups();
        int address$iv = this.group;
        boolean $i$f$isNode = false;
        if (($this$isNode$iv[address$iv * 5 + 1] & 0x40000000) != 0) {
            void $this$nodeIndex$iv;
            $this$isNode$iv = this.table.getGroups();
            address$iv = this.group;
            boolean $i$f$nodeIndex = false;
            object = this.table.getSlots()[$this$nodeIndex$iv[address$iv * 5 + 4]];
        } else {
            object = null;
        }
        return object;
    }

    @Override
    @NotNull
    public Iterable<Object> getData() {
        Iterable iterable;
        GroupSourceInformation groupSourceInformation = this.table.sourceInformationOf(this.group);
        if (groupSourceInformation != null) {
            GroupSourceInformation it = groupSourceInformation;
            boolean bl = false;
            iterable = new SourceInformationGroupDataIterator(this.table, this.group, it);
        } else {
            iterable = new DataIterator(this.table, this.group);
        }
        return iterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Object getIdentity() {
        Anchor anchor;
        this.validateRead();
        SlotTable this_$iv = this.table;
        boolean $i$f$read = false;
        boolean bl = false;
        try (SlotReader reader$iv = this_$iv.openReader();){
            SlotReader it = reader$iv;
            boolean bl2 = false;
            anchor = it.anchor(this.group);
        }
        return anchor;
    }

    @Override
    @NotNull
    public Iterable<CompositionGroup> getCompositionGroups() {
        return this;
    }

    @Override
    @NotNull
    public Iterator<CompositionGroup> iterator() {
        Iterator iterator2;
        this.validateRead();
        GroupSourceInformation groupSourceInformation = this.table.sourceInformationOf(this.group);
        if (groupSourceInformation != null) {
            GroupSourceInformation it = groupSourceInformation;
            boolean bl = false;
            iterator2 = new SourceInformationGroupIterator(this.table, this.group, it, new AnchoredGroupPath(this.group));
        } else {
            iterator2 = new GroupIterator(this.table, this.group + 1, this.group + SlotTableKt.access$groupSize(this.table.getGroups(), this.group));
        }
        return iterator2;
    }

    @Override
    public int getGroupSize() {
        return SlotTableKt.access$groupSize(this.table.getGroups(), this.group);
    }

    @Override
    public int getSlotsSize() {
        int n;
        int[] $this$dataAnchor$iv;
        int nextGroup = this.group + this.getGroupSize();
        if (nextGroup < this.table.getGroupsSize()) {
            $this$dataAnchor$iv = this.table.getGroups();
            boolean $i$f$dataAnchor = false;
            n = $this$dataAnchor$iv[nextGroup * 5 + 4];
        } else {
            n = this.table.getSlotsSize();
        }
        int nextSlot = n;
        $this$dataAnchor$iv = this.table.getGroups();
        int address$iv = this.group;
        boolean $i$f$dataAnchor = false;
        return nextSlot - $this$dataAnchor$iv[address$iv * 5 + 4];
    }

    private final void validateRead() {
        if (this.table.getVersion$runtime() != this.version) {
            SlotTableKt.throwConcurrentModificationException();
        }
    }

    @Override
    @Nullable
    public CompositionGroup find(@NotNull Object identityToFind) {
        CompositionGroup compositionGroup;
        Object object = identityToFind;
        if (object instanceof Anchor) {
            compositionGroup = SlotTableGroup.find$findAnchoredGroup(this, (Anchor)identityToFind);
        } else if (object instanceof SourceInformationSlotTableGroupIdentity) {
            CompositionGroup compositionGroup2 = this.find(((SourceInformationSlotTableGroupIdentity)identityToFind).getParentIdentity());
            if (compositionGroup2 != null) {
                CompositionGroup it = compositionGroup2;
                boolean bl = false;
                compositionGroup = SlotTableGroup.find$findRelativeGroup(it, ((SourceInformationSlotTableGroupIdentity)identityToFind).getIndex());
            } else {
                compositionGroup = null;
            }
        } else {
            compositionGroup = null;
        }
        return compositionGroup;
    }

    private static final CompositionGroup find$findAnchoredGroup(SlotTableGroup this$0, Anchor anchor) {
        int anchorGroup;
        if (this$0.table.ownsAnchor(anchor) && (anchorGroup = this$0.table.anchorIndex(anchor)) >= this$0.group && anchorGroup - this$0.group < SlotTableKt.access$groupSize(this$0.table.getGroups(), this$0.group)) {
            return new SlotTableGroup(this$0.table, anchorGroup, this$0.version);
        }
        return null;
    }

    private static final CompositionGroup find$findRelativeGroup(CompositionGroup group, int index2) {
        return (CompositionGroup)CollectionsKt.firstOrNull((List)CollectionsKt.drop(group.getCompositionGroups(), (int)index2));
    }
}

