/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public final class GroovySillyAssignmentInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.silly.assignment", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitAssignmentExpression(@NotNull GrAssignmentExpression assignment) {
            GrReferenceExpression rhsReference;
            GrExpression lhs;
            block11: {
                block10: {
                    if (assignment == null) {
                        Visitor.$$$reportNull$$$0(0);
                    }
                    super.visitAssignmentExpression(assignment);
                    if (assignment.isOperatorAssignment()) {
                        return;
                    }
                    lhs = assignment.getLValue();
                    GrExpression rhs = assignment.getRValue();
                    if (rhs == null) {
                        return;
                    }
                    if (!(rhs instanceof GrReferenceExpression)) break block10;
                    rhsReference = (GrReferenceExpression)rhs;
                    if (lhs instanceof GrReferenceExpression) break block11;
                }
                return;
            }
            GrReferenceExpression lhsReference = (GrReferenceExpression)lhs;
            GrExpression rhsQualifier = rhsReference.getQualifierExpression();
            GrExpression lhsQualifier = lhsReference.getQualifierExpression();
            if (!(rhsQualifier == null && lhsQualifier == null || EquivalenceChecker.expressionsAreEquivalent(rhsQualifier, lhsQualifier))) {
                return;
            }
            String rhsName = rhsReference.getReferenceName();
            String lhsName = lhsReference.getReferenceName();
            if (rhsName == null || lhsName == null) {
                return;
            }
            if (!rhsName.equals(lhsName)) {
                return;
            }
            PsiElement rhsReferent = rhsReference.resolve();
            PsiElement lhsReferent = lhsReference.resolve();
            if (rhsReferent == null || lhsReferent == null || !rhsReferent.equals((Object)lhsReferent)) {
                return;
            }
            this.registerError(assignment);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovySillyAssignmentInspection$Visitor", "visitAssignmentExpression"));
        }
    }
}

