/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.indices.names;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibMetaFileType;
import org.jetbrains.kotlin.analysis.decompiler.psi.BuiltInDefinitionFile;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinMetadataStubBuilder;
import org.jetbrains.kotlin.idea.base.indices.names.InternalUtilsKt;
import org.jetbrains.kotlin.idea.base.indices.names.KotlinBinaryRootToPackageIndexKt;
import org.jetbrains.kotlin.incremental.storage.StringExternalizer;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/base/indices/names/KotlinBinaryRootToPackageIndex;", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "", "<init>", "()V", "getName", "Lcom/intellij/util/indexing/ID;", "dependsOnFileContent", "", "getKeyDescriptor", "Lcom/intellij/util/io/EnumeratorStringDescriptor;", "getValueExternalizer", "Lorg/jetbrains/kotlin/incremental/storage/StringExternalizer;", "getInputFilter", "Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;", "getVersion", "", "getIndexer", "Lcom/intellij/util/indexing/DataIndexer;", "Lcom/intellij/util/indexing/FileContent;", "Companion", "Indexer", "intellij.kotlin.base.indices"})
@ApiStatus.Internal
public final class KotlinBinaryRootToPackageIndex
extends FileBasedIndexExtension<String, String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ID<String, String> NAME;

    @NotNull
    public ID<String, String> getName() {
        return NAME;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public EnumeratorStringDescriptor getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)enumeratorStringDescriptor, (String)"INSTANCE");
        return enumeratorStringDescriptor;
    }

    @NotNull
    public StringExternalizer getValueExternalizer() {
        return StringExternalizer.INSTANCE;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileType[] fileTypeArray = new FileType[]{JavaClassFileType.INSTANCE, KotlinBuiltInFileType.INSTANCE, KlibMetaFileType.INSTANCE};
        return (FileBasedIndex.InputFilter)new DefaultFileTypeSpecificInputFilter(fileTypeArray);
    }

    public int getVersion() {
        return 7;
    }

    @NotNull
    public DataIndexer<String, String, FileContent> getIndexer() {
        return new Indexer();
    }

    static {
        ID iD = ID.create((String)KotlinBinaryRootToPackageIndex.class.getSimpleName());
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"create(...)");
        NAME = iD;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/base/indices/names/KotlinBinaryRootToPackageIndex$Companion;", "", "<init>", "()V", "NAME", "Lcom/intellij/util/indexing/ID;", "", "getNAME", "()Lcom/intellij/util/indexing/ID;", "intellij.kotlin.base.indices"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ID<String, String> getNAME() {
            return NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/base/indices/names/KotlinBinaryRootToPackageIndex$Indexer;", "Lcom/intellij/util/indexing/DataIndexer;", "", "Lcom/intellij/util/indexing/FileContent;", "<init>", "()V", "map", "", "inputData", "getPackageName", "Lorg/jetbrains/kotlin/name/FqName;", "fileContent", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getBinaryRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getUnpackedKlibBinaryRoot", "metadataFile", "intellij.kotlin.base.indices"})
    private static final class Indexer
    implements DataIndexer<String, String, FileContent> {
        @NotNull
        public Map<String, String> map(@NotNull FileContent inputData) {
            Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
            try {
                FileType fileType = inputData.getFileType();
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
                FileType fileType2 = fileType;
                FqName fqName2 = this.getPackageName(inputData, fileType2);
                if (fqName2 == null) {
                    return MapsKt.emptyMap();
                }
                FqName packageName = fqName2;
                VirtualFile virtualFile = this.getBinaryRoot(inputData, fileType2);
                if (virtualFile == null) {
                    return MapsKt.emptyMap();
                }
                VirtualFile binaryRoot = virtualFile;
                return MapsKt.mapOf((Pair)TuplesKt.to((Object)binaryRoot.getName(), (Object)packageName.asString()));
            }
            catch (Exception e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                throw new RuntimeException("Error on indexing " + inputData.getFile(), e);
            }
        }

        private final FqName getPackageName(FileContent fileContent, FileType fileType) {
            Object object;
            FileType fileType2 = fileType;
            if (Intrinsics.areEqual((Object)fileType2, (Object)JavaClassFileType.INSTANCE)) {
                KotlinJvmBinaryClass kotlinJvmBinaryClass = InternalUtilsKt.toKotlinJvmBinaryClass(fileContent);
                object = kotlinJvmBinaryClass != null ? InternalUtilsKt.getPackageName(kotlinJvmBinaryClass) : null;
            } else if (Intrinsics.areEqual((Object)fileType2, (Object)KotlinBuiltInFileType.INSTANCE)) {
                KotlinMetadataStubBuilder.FileWithMetadata.Compatible compatible = InternalUtilsKt.readKotlinMetadataDefinition(fileContent);
                BuiltInDefinitionFile builtInDefinitionFile = compatible instanceof BuiltInDefinitionFile ? (BuiltInDefinitionFile)compatible : null;
                object = builtInDefinitionFile != null ? builtInDefinitionFile.getPackageFqName() : null;
            } else if (Intrinsics.areEqual((Object)fileType2, (Object)KlibMetaFileType.INSTANCE)) {
                KotlinMetadataStubBuilder.FileWithMetadata.Compatible compatible = InternalUtilsKt.toKlibMetadataCompatibleFileWithMetadata(fileContent);
                object = compatible != null ? compatible.getPackageFqName() : null;
            } else {
                object = null;
            }
            return object;
        }

        private final VirtualFile getBinaryRoot(FileContent inputData, FileType fileType) {
            Object object;
            VirtualFileSystem virtualFileSystem = inputData.getFile().getFileSystem();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
            VirtualFileSystem fileSystem = virtualFileSystem;
            if (fileSystem instanceof JarFileSystem) {
                VirtualFile virtualFile = ((JarFileSystem)fileSystem).getLocalByEntry(inputData.getFile());
                if (virtualFile != null) {
                    VirtualFile virtualFile2;
                    VirtualFile jarFile = virtualFile2 = virtualFile;
                    boolean bl = false;
                    object = KotlinBinaryRootToPackageIndexKt.access$isPackedLibrary(jarFile) ? virtualFile2 : null;
                } else {
                    object = null;
                }
            } else if (fileSystem instanceof JrtFileSystem) {
                VirtualFile virtualFile = inputData.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                object = InternalUtilsKt.getJrtModuleRoot(virtualFile);
            } else if (Intrinsics.areEqual((Object)fileType, (Object)KlibMetaFileType.INSTANCE)) {
                VirtualFile virtualFile = inputData.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                object = this.getUnpackedKlibBinaryRoot(virtualFile);
            } else {
                object = null;
            }
            return object;
        }

        private final VirtualFile getUnpackedKlibBinaryRoot(VirtualFile metadataFile) {
            VirtualFile virtualFile = VfsUtil.findContainingDirectory((VirtualFile)metadataFile, (CharSequence)"linkdata");
            if (virtualFile == null) {
                return null;
            }
            VirtualFile metadataDirectory = virtualFile;
            VirtualFile virtualFile2 = metadataDirectory.getParent();
            return virtualFile2 != null ? virtualFile2.getParent() : null;
        }
    }
}

