/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.libraries;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.libraries.AddKotlinLibraryQuickFix;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManager;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManagerKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0016\u0017\u0018B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0003\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider;", "Lcom/intellij/codeInsight/quickfix/UnresolvedReferenceQuickFixProvider;", "Lcom/intellij/psi/PsiReference;", "libraryGroupId", "", "libraryArtifactId", "libraryDescriptorProvider", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider$LibraryDescriptorProvider;", "libraryAvailabilityTester", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider$LibraryAvailabilityTester;", "libraryReferenceTester", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider$LibraryReferenceTester;", "quickFixText", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider$LibraryDescriptorProvider;Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider$LibraryAvailabilityTester;Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider$LibraryReferenceTester;Ljava/lang/String;)V", "registerFixes", "", "ref", "registrar", "Lcom/intellij/codeInsight/daemon/QuickFixActionRegistrar;", "getReferenceClass", "Ljava/lang/Class;", "LibraryAvailabilityTester", "LibraryReferenceTester", "LibraryDescriptorProvider", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nAddKotlinLibraryQuickFixProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddKotlinLibraryQuickFixProvider.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n295#2,2:127\n*S KotlinDebug\n*F\n+ 1 AddKotlinLibraryQuickFixProvider.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider\n*L\n67#1:127,2\n*E\n"})
public class AddKotlinLibraryQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiReference> {
    @NotNull
    private final String libraryGroupId;
    @NotNull
    private final String libraryArtifactId;
    @NotNull
    private final LibraryDescriptorProvider libraryDescriptorProvider;
    @NotNull
    private final LibraryAvailabilityTester libraryAvailabilityTester;
    @NotNull
    private final LibraryReferenceTester libraryReferenceTester;
    @NotNull
    private final String quickFixText;

    public AddKotlinLibraryQuickFixProvider(@NotNull String libraryGroupId, @NotNull String libraryArtifactId, @NotNull LibraryDescriptorProvider libraryDescriptorProvider, @NotNull LibraryAvailabilityTester libraryAvailabilityTester, @NotNull LibraryReferenceTester libraryReferenceTester, @IntentionName @NotNull String quickFixText) {
        Intrinsics.checkNotNullParameter((Object)libraryGroupId, (String)"libraryGroupId");
        Intrinsics.checkNotNullParameter((Object)libraryArtifactId, (String)"libraryArtifactId");
        Intrinsics.checkNotNullParameter((Object)libraryDescriptorProvider, (String)"libraryDescriptorProvider");
        Intrinsics.checkNotNullParameter((Object)libraryAvailabilityTester, (String)"libraryAvailabilityTester");
        Intrinsics.checkNotNullParameter((Object)libraryReferenceTester, (String)"libraryReferenceTester");
        Intrinsics.checkNotNullParameter((Object)quickFixText, (String)"quickFixText");
        this.libraryGroupId = libraryGroupId;
        this.libraryArtifactId = libraryArtifactId;
        this.libraryDescriptorProvider = libraryDescriptorProvider;
        this.libraryAvailabilityTester = libraryAvailabilityTester;
        this.libraryReferenceTester = libraryReferenceTester;
        this.quickFixText = quickFixText;
    }

    public /* synthetic */ AddKotlinLibraryQuickFixProvider(String string, String string2, LibraryDescriptorProvider libraryDescriptorProvider, LibraryAvailabilityTester libraryAvailabilityTester, LibraryReferenceTester libraryReferenceTester, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            Object[] objectArray = new Object[]{string + ":" + string2};
            string3 = KotlinBundle.message((String)"add.0.library", (Object[])objectArray);
        }
        this(string, string2, libraryDescriptorProvider, libraryAvailabilityTester, libraryReferenceTester, string3);
    }

    public void registerFixes(@NotNull PsiReference ref, @NotNull QuickFixActionRegistrar registrar2) {
        Object v3;
        Module module;
        block7: {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            Intrinsics.checkNotNullParameter((Object)registrar2, (String)"registrar");
            if (!this.libraryReferenceTester.isLibraryReference(ref)) {
                return;
            }
            PsiElement psiElement = ref.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            Module module2 = GenericPsiUtils.getModule(psiElement);
            if (module2 == null) {
                return;
            }
            module = module2;
            List list2 = ref.getElement().getProject().getExtensionArea().getExtensionPoint(KotlinBuildSystemDependencyManager.Companion.getEP_NAME()).getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExtensionList(...)");
            List extensionList = list2;
            Iterable $this$firstOrNull$iv = extensionList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KotlinBuildSystemDependencyManager it = (KotlinBuildSystemDependencyManager)element$iv;
                boolean bl = false;
                if (!it.isApplicable(module)) continue;
                v3 = element$iv;
                break block7;
            }
            v3 = null;
        }
        KotlinBuildSystemDependencyManager kotlinBuildSystemDependencyManager = v3;
        if (kotlinBuildSystemDependencyManager == null) {
            return;
        }
        KotlinBuildSystemDependencyManager dependencyManager = kotlinBuildSystemDependencyManager;
        if (KotlinBuildSystemDependencyManagerKt.isProjectSyncPendingOrInProgress(dependencyManager)) {
            return;
        }
        if (this.libraryAvailabilityTester.isAvailable(module)) {
            return;
        }
        ExternalLibraryDescriptor externalLibraryDescriptor = this.libraryDescriptorProvider.getLibraryDescriptor(this.libraryGroupId, this.libraryArtifactId, ref);
        if (externalLibraryDescriptor == null) {
            return;
        }
        ExternalLibraryDescriptor libraryDescriptor = externalLibraryDescriptor;
        DependencyScope scope = ProjectFileIndex.getInstance((Project)module.getProject()).isInTestSourceContent(ref.getElement().getContainingFile().getVirtualFile()) ? DependencyScope.TEST : DependencyScope.COMPILE;
        registrar2.register((IntentionAction)new AddKotlinLibraryQuickFix(dependencyManager, KotlinBuildSystemDependencyManagerKt.withScope(libraryDescriptor, scope), this.quickFixText));
    }

    @NotNull
    public Class<PsiReference> getReferenceClass() {
        return PsiReference.class;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider$LibraryAvailabilityTester;", "", "isAvailable", "", "module", "Lcom/intellij/openapi/module/Module;", "Companion", "kotlin.code-insight.inspections.shared"})
    public static interface LibraryAvailabilityTester {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean isAvailable(@NotNull Module var1);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider$LibraryAvailabilityTester$Companion;", "", "<init>", "()V", "kotlin.code-insight.inspections.shared"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000 \t2\u00020\u0001:\u0001\tJ\"\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider$LibraryDescriptorProvider;", "", "getLibraryDescriptor", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "libraryGroupId", "", "libraryArtifactId", "psiReference", "Lcom/intellij/psi/PsiReference;", "Companion", "kotlin.code-insight.inspections.shared"})
    public static interface LibraryDescriptorProvider {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @Nullable
        public ExternalLibraryDescriptor getLibraryDescriptor(@NotNull String var1, @NotNull String var2, @NotNull PsiReference var3);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider$LibraryDescriptorProvider$Companion;", "", "<init>", "()V", "kotlin.code-insight.inspections.shared"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider$LibraryReferenceTester;", "", "isLibraryReference", "", "ref", "Lcom/intellij/psi/PsiReference;", "Companion", "kotlin.code-insight.inspections.shared"})
    public static interface LibraryReferenceTester {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean isLibraryReference(@NotNull PsiReference var1);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider$LibraryReferenceTester$Companion;", "", "<init>", "()V", "kotlin.code-insight.inspections.shared"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }
}

