/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.onboarding.k2.satisfaction.survey;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.feedback.InIdeFeedbackSurveyConfig;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialogWithEmail;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.onboarding.FeedbackBundle;
import org.jetbrains.kotlin.onboarding.FeedbackNotificationWithKotlinLogo;
import org.jetbrains.kotlin.onboarding.k2.satisfaction.survey.K2FeedbackDialog;
import org.jetbrains.kotlin.onboarding.k2.satisfaction.survey.K2UserTracker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2FeedbackSurveyConfig;", "Lcom/intellij/platform/feedback/InIdeFeedbackSurveyConfig;", "<init>", "()V", "surveyId", "", "getSurveyId", "()Ljava/lang/String;", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "requireIdeEAP", "", "getRequireIdeEAP", "()Z", "suitableIdeVersion", "checkIdeIsSuitable", "checkExtraConditionSatisfied", "project", "Lcom/intellij/openapi/project/Project;", "updateStateAfterDialogClosedOk", "", "createFeedbackDialog", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialogWithEmail;", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "forTest", "createNotification", "Lorg/jetbrains/kotlin/onboarding/FeedbackNotificationWithKotlinLogo;", "updateStateAfterNotificationShowed", "intellij.kotlin.onboarding"})
public final class K2FeedbackSurveyConfig
implements InIdeFeedbackSurveyConfig {
    @NotNull
    private final String surveyId;
    @NotNull
    private final LocalDate lastDayOfFeedbackCollection = new LocalDate(2028, 1, 1);
    private final boolean requireIdeEAP;
    @NotNull
    private final String suitableIdeVersion = Registry.Companion.stringValue("k2.feedback.survey.ide.version.number");

    public K2FeedbackSurveyConfig() {
        this.surveyId = "k2_feedback";
    }

    @NotNull
    public String getSurveyId() {
        return this.surveyId;
    }

    @NotNull
    public LocalDate getLastDayOfFeedbackCollection() {
        return this.lastDayOfFeedbackCollection;
    }

    public boolean getRequireIdeEAP() {
        return this.requireIdeEAP;
    }

    public boolean checkIdeIsSuitable() {
        return PlatformUtils.isIdeaUltimate() || PlatformUtils.isIdeaCommunity();
    }

    public boolean checkExtraConditionSatisfied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ApplicationManager.getApplication().isInternal() || Intrinsics.areEqual((Object)this.suitableIdeVersion, (Object)ApplicationInfo.getInstance().getShortVersion())) && K2UserTracker.Companion.getInstance().shouldShowK2FeedbackDialog$intellij_kotlin_onboarding(project);
    }

    public void updateStateAfterDialogClosedOk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        K2UserTracker.Companion.getInstance().getState().setUserSawSurvey(true);
    }

    @NotNull
    public BlockBasedFeedbackDialogWithEmail<? extends SystemDataJsonSerializable> createFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (BlockBasedFeedbackDialogWithEmail)new K2FeedbackDialog(project, forTest);
    }

    @NotNull
    public FeedbackNotificationWithKotlinLogo createNotification(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new FeedbackNotificationWithKotlinLogo("Feedback In IDE", FeedbackBundle.INSTANCE.message("notification.k2.satisfaction.request.title", new Object[0]), FeedbackBundle.INSTANCE.message("notification.k2.satisfaction.request.content", new Object[0]));
    }

    public void updateStateAfterNotificationShowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }
}

