/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.credentialbuilder;

import java.time.Instant;
import java.util.Optional;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.protocol.oid4vc.issuance.TimeProvider;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilder;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderException;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderUtils;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.JwtCredentialBody;
import org.keycloak.protocol.oid4vc.model.CredentialBuildConfig;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.representations.JsonWebToken;

public class JwtCredentialBuilder
implements CredentialBuilder {
    private static final String VC_CLAIM_KEY = "vc";
    private static final String ID_CLAIM_KEY = "id";
    private final TimeProvider timeProvider;

    public JwtCredentialBuilder(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    @Override
    public String getSupportedFormat() {
        return "jwt_vc";
    }

    @Override
    public JwtCredentialBody buildCredentialBody(VerifiableCredential verifiableCredential, CredentialBuildConfig credentialBuildConfig) throws CredentialBuilderException {
        verifiableCredential.setIssuer(credentialBuildConfig.getCredentialIssuer());
        long iat = Optional.ofNullable(verifiableCredential.getIssuanceDate()).map(Instant::getEpochSecond).orElse(Long.valueOf(this.timeProvider.currentTimeSeconds()));
        JsonWebToken jsonWebToken = new JsonWebToken().issuer(verifiableCredential.getIssuer().toString()).nbf(Long.valueOf(iat)).id(CredentialBuilderUtils.createCredentialId(verifiableCredential));
        jsonWebToken.setOtherClaims(VC_CLAIM_KEY, (Object)verifiableCredential);
        Optional.ofNullable(verifiableCredential.getExpirationDate()).ifPresent(d -> jsonWebToken.exp(Long.valueOf(d.getEpochSecond())));
        Optional.ofNullable(verifiableCredential.getCredentialSubject().getClaims().get(ID_CLAIM_KEY)).map(Object::toString).ifPresent(arg_0 -> ((JsonWebToken)jsonWebToken).subject(arg_0));
        JWSBuilder.EncodingBuilder jwsBuilder = new JWSBuilder().type(credentialBuildConfig.getTokenJwsType()).jsonContent((Object)jsonWebToken);
        return new JwtCredentialBody(jwsBuilder);
    }
}

