/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.infinispan.protostream.annotations.Proto;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.util.EnumWithStableIndex;

public interface UserSessionModel {
    public static final String CORRESPONDING_SESSION_ID = "correspondingSessionId";

    public String getId();

    public RealmModel getRealm();

    public String getBrokerSessionId();

    public String getBrokerUserId();

    public UserModel getUser();

    public String getLoginUsername();

    public String getIpAddress();

    public String getAuthMethod();

    public boolean isRememberMe();

    public int getStarted();

    public int getLastSessionRefresh();

    public void setLastSessionRefresh(int var1);

    public boolean isOffline();

    public Map<String, AuthenticatedClientSessionModel> getAuthenticatedClientSessions();

    default public AuthenticatedClientSessionModel getAuthenticatedClientSessionByClient(String clientUUID) {
        return this.getAuthenticatedClientSessions().get(clientUUID);
    }

    public void removeAuthenticatedClientSessions(Collection<String> var1);

    public String getNote(String var1);

    public void setNote(String var1, String var2);

    public void removeNote(String var1);

    public Map<String, String> getNotes();

    public State getState();

    public void setState(State var1);

    public void restartSession(RealmModel var1, UserModel var2, String var3, String var4, String var5, boolean var6, String var7, String var8);

    default public SessionPersistenceState getPersistenceState() {
        return SessionPersistenceState.PERSISTENT;
    }

    public static enum SessionPersistenceState {
        PERSISTENT,
        TRANSIENT;


        public static SessionPersistenceState fromString(String sessionPersistenceString) {
            return sessionPersistenceString == null ? PERSISTENT : Enum.valueOf(SessionPersistenceState.class, sessionPersistenceString);
        }
    }

    @ProtoTypeId(value=65536)
    @Proto
    public static enum State implements EnumWithStableIndex
    {
        LOGGED_IN(0),
        LOGGING_OUT(1),
        LOGGED_OUT(2),
        LOGGED_OUT_UNCONFIRMED(3);

        private final int stableIndex;
        private static final Map<Integer, State> BY_ID;

        private State(int stableIndex) {
            Objects.requireNonNull(stableIndex);
            this.stableIndex = stableIndex;
        }

        public int getStableIndex() {
            return this.stableIndex;
        }

        public static State valueOfInteger(Integer id) {
            return id == null ? null : BY_ID.get(id);
        }

        static {
            BY_ID = EnumWithStableIndex.getReverseIndex((EnumWithStableIndex[])State.values());
        }
    }
}

