/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.common;

import java.time.Duration;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.Flags;

public interface CacheWriteOptions
extends CacheOptions {
    public static final CacheWriteOptions DEFAULT = new Impl();

    public static Builder writeOptions() {
        return new Builder();
    }

    public static Builder writeOptions(CacheOptions options) {
        Builder builder = new Builder();
        options.timeout().ifPresent(builder::timeout);
        options.flags().ifPresent(builder::flags);
        return builder;
    }

    public static Builder writeOptions(CacheWriteOptions options) {
        Builder builder = CacheWriteOptions.writeOptions((CacheOptions)options);
        options.expiration().lifespan().ifPresent(builder::lifespan);
        options.expiration().maxIdle().ifPresent(builder::maxIdle);
        return builder;
    }

    public CacheEntryExpiration expiration();

    public static class Builder
    extends CacheOptions.Builder {
        private CacheEntryExpiration expiration = CacheEntryExpiration.DEFAULT;

        @Override
        public Builder timeout(Duration timeout) {
            super.timeout(timeout);
            return this;
        }

        @Override
        public Builder flags(Flags<?, ?> flags) {
            super.flags(flags);
            return this;
        }

        public Builder lifespan(Duration lifespan) {
            if (this.expiration.maxIdle().isPresent()) {
                return this.lifespanAndMaxIdle(lifespan, this.expiration.maxIdle().get());
            }
            this.expiration = CacheEntryExpiration.withLifespan(lifespan);
            return this;
        }

        public Builder maxIdle(Duration maxIdle) {
            if (this.expiration.lifespan().isPresent()) {
                return this.lifespanAndMaxIdle(this.expiration.lifespan().get(), maxIdle);
            }
            this.expiration = CacheEntryExpiration.withMaxIdle(maxIdle);
            return this;
        }

        public Builder lifespanAndMaxIdle(Duration lifespan, Duration maxIdle) {
            this.expiration = CacheEntryExpiration.withLifespanAndMaxIdle(lifespan, maxIdle);
            return this;
        }

        @Override
        public CacheWriteOptions build() {
            return new Impl(this.timeout, this.flags, this.expiration);
        }
    }

    public static class Impl
    extends CacheOptions.Impl
    implements CacheWriteOptions {
        private final CacheEntryExpiration expiration;

        public Impl() {
            this(null, null, CacheEntryExpiration.DEFAULT);
        }

        Impl(Duration timeout, Flags<?, ?> flags, CacheEntryExpiration expiration) {
            super(timeout, flags);
            this.expiration = expiration != null ? expiration : CacheEntryExpiration.DEFAULT;
        }

        @Override
        public CacheEntryExpiration expiration() {
            return this.expiration;
        }
    }
}

