/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;

@MBean(description="Protocol trying to print payloads as strings")
public class SNIFF
extends Protocol {
    @Property(description="Print received messages")
    protected boolean up = true;
    @Property(description="Print sent messages")
    protected boolean down;

    @Override
    public Object down(Message msg) {
        if (this.down) {
            SNIFF.dump("down msg", msg);
        }
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Message msg) {
        if (this.up) {
            SNIFF.dump("up msg", msg);
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        int count = 1;
        for (Message msg : batch) {
            SNIFF.dump("batch msg#" + count++, msg);
        }
        this.up_prot.up(batch);
    }

    protected static void dump(String type, Message msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n%s from %s (%d bytes):\nhdrs: %s\n", type, msg.getSrc(), msg.getLength(), msg.printHeaders()));
        if (msg.getLength() > 0) {
            sb.append("payload: ");
            SNIFF.printPayload(msg, sb);
            sb.append("\n");
        }
        System.out.println(sb.toString());
    }

    protected static void printPayload(Message msg, StringBuilder sb) {
        byte[] payload = msg.getArray();
        int print_max = Math.min(msg.getLength(), 50);
        for (int i = msg.getOffset(); i < print_max; ++i) {
            byte ch = payload[i];
            sb.append((char)ch);
        }
    }
}

