/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mapper;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.mapper.ClientModelMapper;
import org.keycloak.representations.admin.v2.ClientRepresentation;
import org.keycloak.services.ServiceException;
import org.mapstruct.Context;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.ObjectFactory;

@Mapper
public interface MapStructClientModelMapper
extends ClientModelMapper {
    @Override
    @ModelToRep
    public ClientRepresentation fromModel(@Context KeycloakSession var1, ClientModel var2);

    @Override
    @RepToModel
    public ClientModel toModel(@Context KeycloakSession var1, @Context RealmModel var2, @MappingTarget ClientModel var3, ClientRepresentation var4) throws ServiceException;

    @Override
    @RepToModel
    public ClientModel toModel(@Context KeycloakSession var1, @Context RealmModel var2, ClientRepresentation var3) throws ServiceException;

    @ObjectFactory
    default public ClientModel createClientModel(@Context RealmModel realm, ClientRepresentation rep) {
        ClientModel model = realm.addClient(rep.getClientId());
        realm.removeClient(model.getId());
        return model;
    }

    @Named(value="isPublicClientPrimitive")
    default public boolean isPublicClientPrimitive(Boolean authEnabled) {
        Boolean result = this.isPublicClient(authEnabled);
        return result != null ? result : false;
    }

    @Named(value="isPublicClient")
    default public Boolean isPublicClient(Boolean authEnabled) {
        return authEnabled != null ? Boolean.valueOf(authEnabled == false) : null;
    }

    @Named(value="getRoleStrings")
    default public Set<String> getRoleStrings(Stream<RoleModel> stream) {
        return stream.map(RoleModel::getName).collect(Collectors.toSet());
    }

    @Named(value="getServiceAccountRoles")
    default public Set<String> getServiceAccountRoles(@Context KeycloakSession session, ClientModel client) {
        if (client.isServiceAccountsEnabled()) {
            return session.users().getServiceAccount(client).getRoleMappingsStream().map(RoleModel::getName).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Mappings(value={@Mapping(target="displayName", source="name"), @Mapping(target="appUrl", source="baseUrl"), @Mapping(target="appRedirectUrls", source="redirectUris"), @Mapping(target="loginFlows", source="authenticationFlowBindingOverrides", ignore=true), @Mapping(target="auth.enabled", source="publicClient", qualifiedByName={"isPublicClient"}), @Mapping(target="auth.method", source="clientAuthenticatorType"), @Mapping(target="auth.secret", source="secret"), @Mapping(target="auth.certificate", ignore=true), @Mapping(target="roles", source="rolesStream", qualifiedByName={"getRoleStrings"}), @Mapping(target="serviceAccount.enabled", source="serviceAccountsEnabled"), @Mapping(target="serviceAccount.roles", source=".", qualifiedByName={"getServiceAccountRoles"})})
    public static @interface ModelToRep {
    }

    @Mappings(value={@Mapping(target="name", source="displayName"), @Mapping(target="baseUrl", source="appUrl"), @Mapping(target="redirectUris", source="appRedirectUrls"), @Mapping(target="authenticationFlowBindingOverrides", source="loginFlows", ignore=true), @Mapping(target="publicClient", source="auth.enabled", qualifiedByName={"isPublicClientPrimitive"}), @Mapping(target="clientAuthenticatorType", source="auth.method"), @Mapping(target="secret", source="auth.secret"), @Mapping(target="serviceAccountsEnabled", source="serviceAccount.enabled")})
    public static @interface RepToModel {
    }
}

