/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import org.hibernate.Incubating;
import org.hibernate.ScrollableResults;
import org.hibernate.query.spi.CloseableIterator;

@Incubating
public class ScrollableResultsIterator<T>
implements CloseableIterator<T> {
    private final ScrollableResults<T> scrollableResults;

    public ScrollableResultsIterator(ScrollableResults<T> scrollableResults) {
        this.scrollableResults = scrollableResults;
    }

    @Override
    public void close() {
        this.scrollableResults.close();
    }

    @Override
    public boolean hasNext() {
        return !this.scrollableResults.isClosed() && this.scrollableResults.next();
    }

    @Override
    public T next() {
        return this.scrollableResults.get();
    }
}

