/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

import com.tdunning.math.stats.AbstractTDigest;
import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.ScaleFunction;
import com.tdunning.math.stats.Sort;
import com.tdunning.math.stats.TDigest;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MergingDigest
extends AbstractTDigest {
    private int mergeCount = 0;
    private final double publicCompression;
    private final double compression;
    private int lastUsedCell;
    private double totalWeight = 0.0;
    private final double[] weight;
    private final double[] mean;
    private List<List<Double>> data = null;
    private double unmergedWeight = 0.0;
    private int tempUsed = 0;
    private final double[] tempWeight;
    private final double[] tempMean;
    private List<List<Double>> tempData = null;
    private final int[] order;
    public boolean useAlternatingSort = true;
    public boolean useTwoLevelCompression = true;
    public static boolean useWeightLimit = true;

    public MergingDigest(double compression) {
        this(compression, -1);
    }

    public MergingDigest(double compression, int bufferSize) {
        this(compression, bufferSize, -1);
    }

    public MergingDigest(double compression, int bufferSize, int size) {
        if (compression < 10.0) {
            compression = 10.0;
        }
        double sizeFudge = 0.0;
        if (useWeightLimit) {
            sizeFudge = 10.0;
            if (compression < 30.0) {
                sizeFudge += 20.0;
            }
        }
        size = (int)Math.max(2.0 * compression + sizeFudge, (double)size);
        if (bufferSize == -1) {
            bufferSize = 5 * size;
        }
        if (bufferSize <= 2 * size) {
            bufferSize = 2 * size;
        }
        double scale = Math.max(1, bufferSize / size - 1);
        if (!this.useTwoLevelCompression) {
            scale = 1.0;
        }
        this.publicCompression = compression;
        this.compression = Math.sqrt(scale) * this.publicCompression;
        if ((double)size < this.compression + sizeFudge) {
            size = (int)Math.ceil(this.compression + sizeFudge);
        }
        if (bufferSize <= 2 * size) {
            bufferSize = 2 * size;
        }
        this.weight = new double[size];
        this.mean = new double[size];
        this.tempWeight = new double[bufferSize];
        this.tempMean = new double[bufferSize];
        this.order = new int[bufferSize];
        this.lastUsedCell = 0;
    }

    @Override
    public TDigest recordAllData() {
        super.recordAllData();
        this.data = new ArrayList<List<Double>>();
        this.tempData = new ArrayList<List<Double>>();
        return this;
    }

    @Override
    void add(double x, int w, Centroid base) {
        this.add(x, w, base.data());
    }

    @Override
    public void add(double x, int w) {
        this.add(x, w, (List<Double>)null);
    }

    private void add(double x, int w, List<Double> history) {
        if (Double.isNaN(x)) {
            throw new IllegalArgumentException("Cannot add NaN to t-digest");
        }
        if (this.tempUsed >= this.tempWeight.length - this.lastUsedCell - 1) {
            this.mergeNewValues();
        }
        int where = this.tempUsed++;
        this.tempWeight[where] = w;
        this.tempMean[where] = x;
        this.unmergedWeight += (double)w;
        if (x < this.min) {
            this.min = x;
        }
        if (x > this.max) {
            this.max = x;
        }
        if (this.data != null) {
            if (this.tempData == null) {
                this.tempData = new ArrayList<List<Double>>();
            }
            while (this.tempData.size() <= where) {
                this.tempData.add(new ArrayList());
            }
            if (history == null) {
                history = Collections.singletonList(x);
            }
            this.tempData.get(where).addAll(history);
        }
    }

    private void add(double[] m, double[] w, int count, List<List<Double>> data) {
        if (m.length != w.length) {
            throw new IllegalArgumentException("Arrays not same length");
        }
        if (m.length < count + this.lastUsedCell) {
            double[] m1 = new double[count + this.lastUsedCell];
            System.arraycopy(m, 0, m1, 0, count);
            m = m1;
            double[] w1 = new double[count + this.lastUsedCell];
            System.arraycopy(w, 0, w1, 0, count);
            w = w1;
        }
        double total = 0.0;
        for (int i = 0; i < count; ++i) {
            total += w[i];
        }
        this.merge(m, w, count, data, null, total, false, this.compression);
    }

    @Override
    public void add(List<? extends TDigest> others) {
        if (others.size() == 0) {
            return;
        }
        int size = 0;
        for (TDigest tDigest : others) {
            tDigest.compress();
            size += tDigest.centroidCount();
        }
        double[] m = new double[size];
        double[] dArray = new double[size];
        ArrayList<List<Double>> data = this.recordAllData ? new ArrayList<List<Double>>() : null;
        int offset = 0;
        for (TDigest tDigest : others) {
            if (tDigest instanceof MergingDigest) {
                MergingDigest md = (MergingDigest)tDigest;
                System.arraycopy(md.mean, 0, m, offset, md.lastUsedCell);
                System.arraycopy(md.weight, 0, dArray, offset, md.lastUsedCell);
                if (data != null) {
                    for (Centroid centroid : tDigest.centroids()) {
                        data.add(centroid.data());
                    }
                }
                offset += md.lastUsedCell;
                continue;
            }
            for (Centroid centroid : tDigest.centroids()) {
                m[offset] = centroid.mean();
                dArray[offset] = centroid.count();
                if (this.recordAllData) {
                    assert (data != null);
                    data.add(centroid.data());
                }
                ++offset;
            }
        }
        this.add(m, dArray, size, data);
    }

    private void mergeNewValues() {
        this.mergeNewValues(false, this.compression);
    }

    private void mergeNewValues(boolean force, double compression) {
        if (this.totalWeight == 0.0 && this.unmergedWeight == 0.0) {
            return;
        }
        if (force || this.unmergedWeight > 0.0) {
            this.merge(this.tempMean, this.tempWeight, this.tempUsed, this.tempData, this.order, this.unmergedWeight, this.useAlternatingSort & this.mergeCount % 2 == 1, compression);
            ++this.mergeCount;
            this.tempUsed = 0;
            this.unmergedWeight = 0.0;
            if (this.data != null) {
                this.tempData = new ArrayList<List<Double>>();
            }
        }
    }

    private void merge(double[] incomingMean, double[] incomingWeight, int incomingCount, List<List<Double>> incomingData, int[] incomingOrder, double unmergedWeight, boolean runBackwards, double compression) {
        assert (this.lastUsedCell <= 0 || this.weight[0] == 1.0);
        assert (this.lastUsedCell <= 0 || this.weight[this.lastUsedCell - 1] == 1.0);
        System.arraycopy(this.mean, 0, incomingMean, incomingCount, this.lastUsedCell);
        System.arraycopy(this.weight, 0, incomingWeight, incomingCount, this.lastUsedCell);
        incomingCount += this.lastUsedCell;
        if (incomingData != null) {
            for (int i = 0; i < this.lastUsedCell; ++i) {
                assert (this.data != null);
                incomingData.add(this.data.get(i));
            }
            this.data = new ArrayList<List<Double>>();
        }
        if (incomingOrder == null) {
            incomingOrder = new int[incomingCount];
        }
        Sort.stableSort(incomingOrder, incomingMean, incomingCount);
        this.totalWeight += unmergedWeight;
        if (runBackwards) {
            Sort.reverse(incomingOrder, 0, incomingCount);
        }
        this.lastUsedCell = 0;
        this.mean[this.lastUsedCell] = incomingMean[incomingOrder[0]];
        this.weight[this.lastUsedCell] = incomingWeight[incomingOrder[0]];
        double wSoFar = 0.0;
        if (this.data != null) {
            assert (incomingData != null);
            this.data.add(incomingData.get(incomingOrder[0]));
        }
        double normalizer = this.scale.normalizer(compression, this.totalWeight);
        double k1 = this.scale.k(0.0, normalizer);
        double wLimit = this.totalWeight * this.scale.q(k1 + 1.0, normalizer);
        for (int i = 1; i < incomingCount; ++i) {
            boolean addThis;
            int ix = incomingOrder[i];
            double proposedWeight = this.weight[this.lastUsedCell] + incomingWeight[ix];
            double projectedW = wSoFar + proposedWeight;
            if (useWeightLimit) {
                double q0 = wSoFar / this.totalWeight;
                double q2 = (wSoFar + proposedWeight) / this.totalWeight;
                addThis = proposedWeight <= this.totalWeight * Math.min(this.scale.max(q0, normalizer), this.scale.max(q2, normalizer));
            } else {
                boolean bl = addThis = projectedW <= wLimit;
            }
            if (i == 1 || i == incomingCount - 1) {
                addThis = false;
            }
            if (addThis) {
                int n = this.lastUsedCell;
                this.weight[n] = this.weight[n] + incomingWeight[ix];
                this.mean[this.lastUsedCell] = this.mean[this.lastUsedCell] + (incomingMean[ix] - this.mean[this.lastUsedCell]) * incomingWeight[ix] / this.weight[this.lastUsedCell];
                incomingWeight[ix] = 0.0;
                if (this.data == null) continue;
                while (this.data.size() <= this.lastUsedCell) {
                    this.data.add(new ArrayList());
                }
                assert (incomingData != null);
                assert (this.data.get(this.lastUsedCell) != incomingData.get(ix));
                this.data.get(this.lastUsedCell).addAll((Collection<Double>)incomingData.get(ix));
                continue;
            }
            wSoFar += this.weight[this.lastUsedCell];
            if (!useWeightLimit) {
                k1 = this.scale.k(wSoFar / this.totalWeight, normalizer);
                wLimit = this.totalWeight * this.scale.q(k1 + 1.0, normalizer);
            }
            ++this.lastUsedCell;
            this.mean[this.lastUsedCell] = incomingMean[ix];
            this.weight[this.lastUsedCell] = incomingWeight[ix];
            incomingWeight[ix] = 0.0;
            if (this.data == null) continue;
            assert (incomingData != null);
            assert (this.data.size() == this.lastUsedCell);
            this.data.add(incomingData.get(ix));
        }
        ++this.lastUsedCell;
        double sum = 0.0;
        for (int i = 0; i < this.lastUsedCell; ++i) {
            sum += this.weight[i];
        }
        assert (sum == this.totalWeight);
        if (runBackwards) {
            Sort.reverse(this.mean, 0, this.lastUsedCell);
            Sort.reverse(this.weight, 0, this.lastUsedCell);
            if (this.data != null) {
                Collections.reverse(this.data);
            }
        }
        assert (this.weight[0] == 1.0);
        assert (this.weight[this.lastUsedCell - 1] == 1.0);
        if (this.totalWeight > 0.0) {
            this.min = Math.min(this.min, this.mean[0]);
            this.max = Math.max(this.max, this.mean[this.lastUsedCell - 1]);
        }
    }

    int checkWeights() {
        return this.checkWeights(this.weight, this.totalWeight, this.lastUsedCell);
    }

    private int checkWeights(double[] w, double total, int last) {
        int badCount = 0;
        int n = last;
        if (w[n] > 0.0) {
            ++n;
        }
        double normalizer = this.scale.normalizer(this.publicCompression, this.totalWeight);
        double k1 = this.scale.k(0.0, normalizer);
        double q = 0.0;
        double left = 0.0;
        String header = "\n";
        for (int i = 0; i < n; ++i) {
            double dq = w[i] / total;
            double k2 = this.scale.k(q + dq, normalizer);
            q += dq / 2.0;
            if (k2 - k1 > 1.0 && w[i] != 1.0) {
                System.out.printf("%sOversize centroid at %d, k0=%.2f, k1=%.2f, dk=%.2f, w=%.2f, q=%.4f, dq=%.4f, left=%.1f, current=%.2f maxw=%.2f\n", header, i, k1, k2, k2 - k1, w[i], q, dq, left, w[i], this.totalWeight * this.scale.max(q, normalizer));
                header = "";
                ++badCount;
            }
            if (k2 - k1 > 4.0 && w[i] != 1.0) {
                throw new IllegalStateException(String.format("Egregiously oversized centroid at %d, k0=%.2f, k1=%.2f, dk=%.2f, w=%.2f, q=%.4f, dq=%.4f, left=%.1f, current=%.2f, maxw=%.2f\n", i, k1, k2, k2 - k1, w[i], q, dq, left, w[i], this.totalWeight * this.scale.max(q, normalizer)));
            }
            q += dq / 2.0;
            left += w[i];
            k1 = k2;
        }
        return badCount;
    }

    @Override
    public void compress() {
        this.mergeNewValues(true, this.publicCompression);
    }

    @Override
    public long size() {
        return (long)(this.totalWeight + this.unmergedWeight);
    }

    @Override
    public double cdf(double x) {
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            throw new IllegalArgumentException(String.format("Invalid value: %f", x));
        }
        this.mergeNewValues();
        if (this.lastUsedCell == 0) {
            return Double.NaN;
        }
        if (this.lastUsedCell == 1) {
            double width = this.max - this.min;
            if (x < this.min) {
                return 0.0;
            }
            if (x > this.max) {
                return 1.0;
            }
            if (x - this.min <= width) {
                return 0.5;
            }
            return (x - this.min) / (this.max - this.min);
        }
        int n = this.lastUsedCell;
        if (x < this.min) {
            return 0.0;
        }
        if (x > this.max) {
            return 1.0;
        }
        if (x < this.mean[0]) {
            if (this.mean[0] - this.min > 0.0) {
                if (x == this.min) {
                    return 0.5 / this.totalWeight;
                }
                return (1.0 + (x - this.min) / (this.mean[0] - this.min) * (this.weight[0] / 2.0 - 1.0)) / this.totalWeight;
            }
            return 0.0;
        }
        assert (x >= this.mean[0]);
        if (x > this.mean[n - 1]) {
            if (this.max - this.mean[n - 1] > 0.0) {
                if (x == this.max) {
                    return 1.0 - 0.5 / this.totalWeight;
                }
                double dq = (1.0 + (this.max - x) / (this.max - this.mean[n - 1]) * (this.weight[n - 1] / 2.0 - 1.0)) / this.totalWeight;
                return 1.0 - dq;
            }
            return 1.0;
        }
        double weightSoFar = 0.0;
        for (int it = 0; it < n - 1; ++it) {
            if (this.mean[it] == x) {
                double dw = 0.0;
                while (it < n && this.mean[it] == x) {
                    dw += this.weight[it];
                    ++it;
                }
                return (weightSoFar + dw / 2.0) / this.totalWeight;
            }
            if (this.mean[it] <= x && x < this.mean[it + 1]) {
                if (this.mean[it + 1] - this.mean[it] > 0.0) {
                    double leftExcludedW = 0.0;
                    double rightExcludedW = 0.0;
                    if (this.weight[it] == 1.0) {
                        if (this.weight[it + 1] == 1.0) {
                            return (weightSoFar + 1.0) / this.totalWeight;
                        }
                        leftExcludedW = 0.5;
                    } else if (this.weight[it + 1] == 1.0) {
                        rightExcludedW = 0.5;
                    }
                    double dw = (this.weight[it] + this.weight[it + 1]) / 2.0;
                    assert (dw > 1.0);
                    assert (leftExcludedW + rightExcludedW <= 0.5);
                    double left = this.mean[it];
                    double right = this.mean[it + 1];
                    double dwNoSingleton = dw - leftExcludedW - rightExcludedW;
                    assert (dwNoSingleton > dw / 2.0);
                    assert (right - left > 0.0);
                    double base = weightSoFar + this.weight[it] / 2.0 + leftExcludedW;
                    return (base + dwNoSingleton * (x - left) / (right - left)) / this.totalWeight;
                }
                double dw = (this.weight[it] + this.weight[it + 1]) / 2.0;
                return (weightSoFar + dw) / this.totalWeight;
            }
            weightSoFar += this.weight[it];
        }
        if (x == this.mean[n - 1]) {
            return 1.0 - 0.5 / this.totalWeight;
        }
        throw new IllegalStateException("Can't happen ... loop fell through");
    }

    @Override
    public double quantile(double q) {
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException("q should be in [0,1], got " + q);
        }
        this.mergeNewValues();
        if (this.lastUsedCell == 0) {
            return Double.NaN;
        }
        if (this.lastUsedCell == 1) {
            return this.mean[0];
        }
        int n = this.lastUsedCell;
        double index = q * this.totalWeight;
        if (index < 1.0) {
            return this.min;
        }
        if (this.weight[0] > 1.0 && index < this.weight[0] / 2.0) {
            return this.min + (index - 1.0) / (this.weight[0] / 2.0 - 1.0) * (this.mean[0] - this.min);
        }
        if (index > this.totalWeight - 1.0) {
            return this.max;
        }
        if (this.weight[n - 1] > 1.0 && this.totalWeight - index <= this.weight[n - 1] / 2.0) {
            return this.max - (this.totalWeight - index - 1.0) / (this.weight[n - 1] / 2.0 - 1.0) * (this.max - this.mean[n - 1]);
        }
        double weightSoFar = this.weight[0] / 2.0;
        for (int i = 0; i < n - 1; ++i) {
            double dw = (this.weight[i] + this.weight[i + 1]) / 2.0;
            if (weightSoFar + dw > index) {
                double leftUnit = 0.0;
                if (this.weight[i] == 1.0) {
                    if (index - weightSoFar < 0.5) {
                        return this.mean[i];
                    }
                    leftUnit = 0.5;
                }
                double rightUnit = 0.0;
                if (this.weight[i + 1] == 1.0) {
                    if (weightSoFar + dw - index <= 0.5) {
                        return this.mean[i + 1];
                    }
                    rightUnit = 0.5;
                }
                double z1 = index - weightSoFar - leftUnit;
                double z2 = weightSoFar + dw - index - rightUnit;
                return MergingDigest.weightedAverage(this.mean[i], z2, this.mean[i + 1], z1);
            }
            weightSoFar += dw;
        }
        assert (this.weight[n - 1] > 1.0);
        assert (index <= this.totalWeight);
        assert (index >= this.totalWeight - this.weight[n - 1] / 2.0);
        double z1 = index - this.totalWeight - this.weight[n - 1] / 2.0;
        double z2 = this.weight[n - 1] / 2.0 - z1;
        return MergingDigest.weightedAverage(this.mean[n - 1], z1, this.max, z2);
    }

    @Override
    public int centroidCount() {
        this.mergeNewValues();
        return this.lastUsedCell;
    }

    @Override
    public Collection<Centroid> centroids() {
        this.compress();
        return new AbstractCollection<Centroid>(){

            @Override
            public Iterator<Centroid> iterator() {
                return new Iterator<Centroid>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < MergingDigest.this.lastUsedCell;
                    }

                    @Override
                    public Centroid next() {
                        Centroid rc = new Centroid(MergingDigest.this.mean[this.i], (int)MergingDigest.this.weight[this.i], MergingDigest.this.data != null ? (List)MergingDigest.this.data.get(this.i) : null);
                        ++this.i;
                        return rc;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Default operation");
                    }
                };
            }

            @Override
            public int size() {
                return MergingDigest.this.lastUsedCell;
            }
        };
    }

    @Override
    public double compression() {
        return this.publicCompression;
    }

    @Override
    public int byteSize() {
        this.compress();
        return this.lastUsedCell * 16 + 32;
    }

    @Override
    public int smallByteSize() {
        this.compress();
        return this.lastUsedCell * 8 + 30;
    }

    public ScaleFunction getScaleFunction() {
        return this.scale;
    }

    @Override
    public void setScaleFunction(ScaleFunction scaleFunction) {
        super.setScaleFunction(scaleFunction);
    }

    @Override
    public void asBytes(ByteBuffer buf) {
        this.compress();
        buf.putInt(Encoding.VERBOSE_ENCODING.code);
        buf.putDouble(this.min);
        buf.putDouble(this.max);
        buf.putDouble(this.publicCompression);
        buf.putInt(this.lastUsedCell);
        for (int i = 0; i < this.lastUsedCell; ++i) {
            buf.putDouble(this.weight[i]);
            buf.putDouble(this.mean[i]);
        }
    }

    @Override
    public void asSmallBytes(ByteBuffer buf) {
        this.compress();
        buf.putInt(Encoding.SMALL_ENCODING.code);
        buf.putDouble(this.min);
        buf.putDouble(this.max);
        buf.putFloat((float)this.publicCompression);
        buf.putShort((short)this.mean.length);
        buf.putShort((short)this.tempMean.length);
        buf.putShort((short)this.lastUsedCell);
        for (int i = 0; i < this.lastUsedCell; ++i) {
            buf.putFloat((float)this.weight[i]);
            buf.putFloat((float)this.mean[i]);
        }
    }

    public static MergingDigest fromBytes(ByteBuffer buf) {
        int encoding = buf.getInt();
        if (encoding == Encoding.VERBOSE_ENCODING.code) {
            double min = buf.getDouble();
            double max = buf.getDouble();
            double compression = buf.getDouble();
            int n = buf.getInt();
            MergingDigest r = new MergingDigest(compression);
            r.setMinMax(min, max);
            r.lastUsedCell = n;
            for (int i = 0; i < n; ++i) {
                r.weight[i] = buf.getDouble();
                r.mean[i] = buf.getDouble();
                r.totalWeight += r.weight[i];
            }
            return r;
        }
        if (encoding == Encoding.SMALL_ENCODING.code) {
            double min = buf.getDouble();
            double max = buf.getDouble();
            double compression = buf.getFloat();
            short n = buf.getShort();
            short bufferSize = buf.getShort();
            MergingDigest r = new MergingDigest(compression, bufferSize, n);
            r.setMinMax(min, max);
            r.lastUsedCell = buf.getShort();
            for (int i = 0; i < r.lastUsedCell; ++i) {
                r.weight[i] = buf.getFloat();
                r.mean[i] = buf.getFloat();
                r.totalWeight += r.weight[i];
            }
            return r;
        }
        throw new IllegalStateException("Invalid format for serialized histogram");
    }

    public String toString() {
        return "MergingDigest-" + (Object)((Object)this.getScaleFunction()) + "-" + (useWeightLimit ? "weight" : "kSize") + "-" + (this.useAlternatingSort ? "alternating" : "stable") + "-" + (this.useTwoLevelCompression ? "twoLevel" : "oneLevel");
    }

    public static enum Encoding {
        VERBOSE_ENCODING(1),
        SMALL_ENCODING(2);

        private final int code;

        private Encoding(int code) {
            this.code = code;
        }
    }
}

