/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.utils;

import com.microsoft.windowsazure.core.RFC1123DateConverter;
import com.microsoft.windowsazure.core.utils.AccessConditionHeaderType;
import java.util.Date;

public final class AccessConditionHeader {
    public static final AccessConditionHeader NONE = new AccessConditionHeader(AccessConditionHeaderType.NONE, null);
    private AccessConditionHeaderType header = AccessConditionHeaderType.NONE;
    private String value;

    public static AccessConditionHeader ifMatch(String etag) {
        return new AccessConditionHeader(AccessConditionHeaderType.IF_MATCH, etag);
    }

    public static AccessConditionHeader ifModifiedSince(Date lastMotified) {
        return new AccessConditionHeader(AccessConditionHeaderType.IF_MODIFIED_SINCE, new RFC1123DateConverter().format(lastMotified));
    }

    public static AccessConditionHeader ifNoneMatch(String etag) {
        return new AccessConditionHeader(AccessConditionHeaderType.IF_NONE_MATCH, etag);
    }

    public static AccessConditionHeader ifNotModifiedSince(Date lastMotified) {
        return new AccessConditionHeader(AccessConditionHeaderType.IF_UNMODIFIED_SINCE, new RFC1123DateConverter().format(lastMotified));
    }

    protected AccessConditionHeader() {
    }

    protected AccessConditionHeader(AccessConditionHeaderType headerType, String value) {
        this.setHeader(headerType);
        this.setValue(value);
    }

    public AccessConditionHeaderType getHeader() {
        return this.header;
    }

    public void setHeader(AccessConditionHeaderType header) {
        this.header = header;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

