/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.action;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.geospatial.ip2geo.action.UpdateDatasourceAction;
import org.opensearch.geospatial.ip2geo.action.UpdateDatasourceRequest;
import org.opensearch.geospatial.ip2geo.common.URLDenyListChecker;
import org.opensearch.geospatial.shared.URLBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestUpdateDatasourceHandler
extends BaseRestHandler {
    private static final String ACTION_NAME = "ip2geo_datasource_update";
    private final URLDenyListChecker urlDenyListChecker;

    public RestUpdateDatasourceHandler(URLDenyListChecker urlDenyListChecker) {
        this.urlDenyListChecker = urlDenyListChecker;
    }

    public String getName() {
        return ACTION_NAME;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        UpdateDatasourceRequest updateDatasourceRequest = new UpdateDatasourceRequest(request.param("name"));
        if (request.hasContentOrSourceParam()) {
            try (XContentParser parser = request.contentOrSourceParamParser();){
                UpdateDatasourceRequest.PARSER.parse(parser, (Object)updateDatasourceRequest, null);
            }
        }
        if (updateDatasourceRequest.getEndpoint() != null) {
            this.urlDenyListChecker.toUrlIfNotInDenyList(updateDatasourceRequest.getEndpoint());
        }
        return channel -> client.executeLocally((ActionType)UpdateDatasourceAction.INSTANCE, (ActionRequest)updateDatasourceRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public List<RestHandler.Route> routes() {
        String path = String.join((CharSequence)"/", URLBuilder.getPluginURLPrefix(), "ip2geo/datasource/{name}/_settings");
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, path));
    }
}

