/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.close;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.close.CloseShardResult;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CloseIndexResult
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CloseIndexResult> {
    private final boolean closed;
    @Nonnull
    private final Map<String, CloseShardResult> shards;
    public static final JsonpDeserializer<CloseIndexResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CloseIndexResult::setupCloseIndexResultDeserializer);

    private CloseIndexResult(Builder builder) {
        this.closed = ApiTypeHelper.requireNonNull(builder.closed, this, "closed");
        this.shards = ApiTypeHelper.unmodifiable(builder.shards);
    }

    public static CloseIndexResult of(Function<Builder, ObjectBuilder<CloseIndexResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean closed() {
        return this.closed;
    }

    @Nonnull
    public final Map<String, CloseShardResult> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("closed");
        generator.write(this.closed);
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartObject();
            for (Map.Entry<String, CloseShardResult> item0 : this.shards.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCloseIndexResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::closed, JsonpDeserializer.booleanDeserializer(), "closed");
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(CloseShardResult._DESERIALIZER), "shards");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Boolean.hashCode(this.closed);
        result = 31 * result + Objects.hashCode(this.shards);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloseIndexResult other = (CloseIndexResult)o;
        return this.closed == other.closed && Objects.equals(this.shards, other.shards);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, CloseIndexResult> {
        private Boolean closed;
        @Nullable
        private Map<String, CloseShardResult> shards;

        public Builder() {
        }

        private Builder(CloseIndexResult o) {
            this.closed = o.closed;
            this.shards = Builder._mapCopy(o.shards);
        }

        private Builder(Builder o) {
            this.closed = o.closed;
            this.shards = Builder._mapCopy(o.shards);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder closed(boolean value) {
            this.closed = value;
            return this;
        }

        @Nonnull
        public final Builder shards(Map<String, CloseShardResult> map) {
            this.shards = Builder._mapPutAll(this.shards, map);
            return this;
        }

        @Nonnull
        public final Builder shards(String key, CloseShardResult value) {
            this.shards = Builder._mapPut(this.shards, key, value);
            return this;
        }

        @Nonnull
        public final Builder shards(String key, Function<CloseShardResult.Builder, ObjectBuilder<CloseShardResult>> fn) {
            return this.shards(key, fn.apply(new CloseShardResult.Builder()).build());
        }

        @Override
        @Nonnull
        public CloseIndexResult build() {
            this._checkSingleUse();
            return new CloseIndexResult(this);
        }
    }
}

