/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.PinnedDoc;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class PinnedQuery
extends QueryBase
implements TaggedUnion<Kind, Object>,
QueryVariant,
PlainJsonSerializable {
    private final Kind _kind;
    private final Object _value;
    @Nonnull
    private final Query organic;
    public static final JsonpDeserializer<PinnedQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PinnedQuery::setupPinnedQueryDeserializer, Builder::build);

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Pinned;
    }

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private PinnedQuery(Builder builder) {
        super(builder);
        this.organic = ApiTypeHelper.requireNonNull(builder.organic, this, "organic");
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static PinnedQuery of(Function<Builder, ObjectBuilder<PinnedQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Query organic() {
        return this.organic;
    }

    public boolean isDocs() {
        return this._kind == Kind.Docs;
    }

    public List<PinnedDoc> docs() {
        return (List)TaggedUnionUtils.get(this, Kind.Docs);
    }

    public boolean isIds() {
        return this._kind == Kind.Ids;
    }

    public List<String> ids() {
        return (List)TaggedUnionUtils.get(this, Kind.Ids);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        super.serializeInternal(generator, mapper);
        generator.writeKey("organic");
        this.organic.serialize(generator, mapper);
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind.ordinal()) {
                case 0: {
                    generator.writeStartArray();
                    for (PinnedDoc item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case 1: {
                    generator.writeStartArray();
                    for (String item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                }
            }
        }
        generator.writeEnd();
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPinnedQueryDeserializer(ObjectDeserializer<Builder> op) {
        PinnedQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::organic, Query._DESERIALIZER, "organic");
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(PinnedDoc._DESERIALIZER), "docs");
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        result = 31 * result + this.organic.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PinnedQuery other = (PinnedQuery)o;
        return Objects.equals(this._kind, other._kind) && Objects.equals(this._value, other._value) && this.organic.equals(other.organic);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder> {
        private Kind _kind;
        private Object _value;
        private Query organic;

        public Builder() {
        }

        private Builder(PinnedQuery o) {
            super(o);
            this.organic = o.organic;
            this._kind = o._kind;
            this._value = o._value;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder organic(Query value) {
            this.organic = value;
            return this;
        }

        @Nonnull
        public final Builder organic(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.organic(fn.apply(new Query.Builder()).build());
        }

        public ContainerBuilder docs(List<PinnedDoc> v) {
            this._kind = Kind.Docs;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder ids(List<String> v) {
            this._kind = Kind.Ids;
            this._value = v;
            return new ContainerBuilder();
        }

        protected PinnedQuery build() {
            this._checkSingleUse();
            return new PinnedQuery(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<PinnedQuery> {
            private ContainerBuilder() {
            }

            @Nonnull
            public final ContainerBuilder organic(Query value) {
                Builder.this.organic = value;
                return this;
            }

            @Nonnull
            public final ContainerBuilder organic(Function<Query.Builder, ObjectBuilder<Query>> fn) {
                return this.organic(fn.apply(new Query.Builder()).build());
            }

            @Override
            public PinnedQuery build() {
                return Builder.this.build();
            }
        }
    }

    public static enum Kind implements JsonEnum
    {
        Docs("docs"),
        Ids("ids");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

