import {
  CachePolicyCookieBehavior,
  CachePolicyHeaderBehavior,
  CachePolicyQueryStringBehavior,
  CachePolicyType,
  CertificateSource,
  CertificateTransparencyLoggingPreference,
  ConnectionMode,
  ContinuousDeploymentPolicyType,
  CustomizationActionType,
  DomainStatus,
  EventType,
  Format,
  FrameOptionsList,
  FunctionRuntime,
  FunctionStage,
  GeoRestrictionType,
  HttpVersion,
  ICPRecordalStatus,
  ImportSourceType,
  IpAddressType,
  IpamCidrStatus,
  ItemSelection,
  Method,
  MinimumProtocolVersion,
  OriginAccessControlOriginTypes,
  OriginAccessControlSigningBehaviors,
  OriginAccessControlSigningProtocols,
  OriginGroupSelectionCriteria,
  OriginProtocolPolicy,
  OriginRequestPolicyCookieBehavior,
  OriginRequestPolicyHeaderBehavior,
  OriginRequestPolicyQueryStringBehavior,
  PriceClass,
  RealtimeMetricsSubscriptionStatus,
  ReferrerPolicyList,
  ResponseHeadersPolicyAccessControlAllowMethodsValues,
  SslProtocol,
  SSLSupportMethod,
  TrustStoreStatus,
  ValidationTokenHost,
  ViewerMtlsMode,
  ViewerProtocolPolicy,
} from "./enums";
export interface KeyPairIds {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface KGKeyPairIds {
  KeyGroupId?: string | undefined;
  KeyPairIds?: KeyPairIds | undefined;
}
export interface ActiveTrustedKeyGroups {
  Enabled: boolean | undefined;
  Quantity: number | undefined;
  Items?: KGKeyPairIds[] | undefined;
}
export interface Signer {
  AwsAccountNumber?: string | undefined;
  KeyPairIds?: KeyPairIds | undefined;
}
export interface ActiveTrustedSigners {
  Enabled: boolean | undefined;
  Quantity: number | undefined;
  Items?: Signer[] | undefined;
}
export interface Aliases {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface AliasICPRecordal {
  CNAME?: string | undefined;
  ICPRecordalStatus?: ICPRecordalStatus | undefined;
}
export interface CachedMethods {
  Quantity: number | undefined;
  Items: Method[] | undefined;
}
export interface AllowedMethods {
  Quantity: number | undefined;
  Items: Method[] | undefined;
  CachedMethods?: CachedMethods | undefined;
}
export interface IpamCidrConfig {
  Cidr: string | undefined;
  IpamPoolArn: string | undefined;
  AnycastIp?: string | undefined;
  Status?: IpamCidrStatus | undefined;
}
export interface IpamConfig {
  Quantity: number | undefined;
  IpamCidrConfigs: IpamCidrConfig[] | undefined;
}
export interface AnycastIpList {
  Id: string | undefined;
  Name: string | undefined;
  Status: string | undefined;
  Arn: string | undefined;
  IpAddressType?: IpAddressType | undefined;
  IpamConfig?: IpamConfig | undefined;
  AnycastIps: string[] | undefined;
  IpCount: number | undefined;
  LastModifiedTime: Date | undefined;
}
export interface AnycastIpListSummary {
  Id: string | undefined;
  Name: string | undefined;
  Status: string | undefined;
  Arn: string | undefined;
  IpCount: number | undefined;
  LastModifiedTime: Date | undefined;
  IpAddressType?: IpAddressType | undefined;
  ETag?: string | undefined;
  IpamConfig?: IpamConfig | undefined;
}
export interface AnycastIpListCollection {
  Items?: AnycastIpListSummary[] | undefined;
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
}
export interface AssociateAliasRequest {
  TargetDistributionId: string | undefined;
  Alias: string | undefined;
}
export interface AssociateDistributionTenantWebACLRequest {
  Id: string | undefined;
  WebACLArn: string | undefined;
  IfMatch?: string | undefined;
}
export interface AssociateDistributionTenantWebACLResult {
  Id?: string | undefined;
  WebACLArn?: string | undefined;
  ETag?: string | undefined;
}
export interface AssociateDistributionWebACLRequest {
  Id: string | undefined;
  WebACLArn: string | undefined;
  IfMatch?: string | undefined;
}
export interface AssociateDistributionWebACLResult {
  Id?: string | undefined;
  WebACLArn?: string | undefined;
  ETag?: string | undefined;
}
export interface CaCertificatesBundleS3Location {
  Bucket: string | undefined;
  Key: string | undefined;
  Region: string | undefined;
  Version?: string | undefined;
}
export type CaCertificatesBundleSource =
  | CaCertificatesBundleSource.CaCertificatesBundleS3LocationMember
  | CaCertificatesBundleSource.$UnknownMember;
export declare namespace CaCertificatesBundleSource {
  interface CaCertificatesBundleS3LocationMember {
    CaCertificatesBundleS3Location: CaCertificatesBundleS3Location;
    $unknown?: never;
  }
  interface $UnknownMember {
    CaCertificatesBundleS3Location?: never;
    $unknown: [string, any];
  }
  interface Visitor<T> {
    CaCertificatesBundleS3Location: (
      value: CaCertificatesBundleS3Location
    ) => T;
    _: (name: string, value: any) => T;
  }
}
export interface CookieNames {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface CookiePreference {
  Forward: ItemSelection | undefined;
  WhitelistedNames?: CookieNames | undefined;
}
export interface Headers {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface QueryStringCacheKeys {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface ForwardedValues {
  QueryString: boolean | undefined;
  Cookies: CookiePreference | undefined;
  Headers?: Headers | undefined;
  QueryStringCacheKeys?: QueryStringCacheKeys | undefined;
}
export interface FunctionAssociation {
  FunctionARN: string | undefined;
  EventType: EventType | undefined;
}
export interface FunctionAssociations {
  Quantity: number | undefined;
  Items?: FunctionAssociation[] | undefined;
}
export interface GrpcConfig {
  Enabled: boolean | undefined;
}
export interface LambdaFunctionAssociation {
  LambdaFunctionARN: string | undefined;
  EventType: EventType | undefined;
  IncludeBody?: boolean | undefined;
}
export interface LambdaFunctionAssociations {
  Quantity: number | undefined;
  Items?: LambdaFunctionAssociation[] | undefined;
}
export interface TrustedKeyGroups {
  Enabled: boolean | undefined;
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface TrustedSigners {
  Enabled: boolean | undefined;
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface CacheBehavior {
  PathPattern: string | undefined;
  TargetOriginId: string | undefined;
  TrustedSigners?: TrustedSigners | undefined;
  TrustedKeyGroups?: TrustedKeyGroups | undefined;
  ViewerProtocolPolicy: ViewerProtocolPolicy | undefined;
  AllowedMethods?: AllowedMethods | undefined;
  SmoothStreaming?: boolean | undefined;
  Compress?: boolean | undefined;
  LambdaFunctionAssociations?: LambdaFunctionAssociations | undefined;
  FunctionAssociations?: FunctionAssociations | undefined;
  FieldLevelEncryptionId?: string | undefined;
  RealtimeLogConfigArn?: string | undefined;
  CachePolicyId?: string | undefined;
  OriginRequestPolicyId?: string | undefined;
  ResponseHeadersPolicyId?: string | undefined;
  GrpcConfig?: GrpcConfig | undefined;
  ForwardedValues?: ForwardedValues | undefined;
  MinTTL?: number | undefined;
  DefaultTTL?: number | undefined;
  MaxTTL?: number | undefined;
}
export interface CacheBehaviors {
  Quantity: number | undefined;
  Items?: CacheBehavior[] | undefined;
}
export interface CachePolicyCookiesConfig {
  CookieBehavior: CachePolicyCookieBehavior | undefined;
  Cookies?: CookieNames | undefined;
}
export interface CachePolicyHeadersConfig {
  HeaderBehavior: CachePolicyHeaderBehavior | undefined;
  Headers?: Headers | undefined;
}
export interface QueryStringNames {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface CachePolicyQueryStringsConfig {
  QueryStringBehavior: CachePolicyQueryStringBehavior | undefined;
  QueryStrings?: QueryStringNames | undefined;
}
export interface ParametersInCacheKeyAndForwardedToOrigin {
  EnableAcceptEncodingGzip: boolean | undefined;
  EnableAcceptEncodingBrotli?: boolean | undefined;
  HeadersConfig: CachePolicyHeadersConfig | undefined;
  CookiesConfig: CachePolicyCookiesConfig | undefined;
  QueryStringsConfig: CachePolicyQueryStringsConfig | undefined;
}
export interface CachePolicyConfig {
  Comment?: string | undefined;
  Name: string | undefined;
  DefaultTTL?: number | undefined;
  MaxTTL?: number | undefined;
  MinTTL: number | undefined;
  ParametersInCacheKeyAndForwardedToOrigin?:
    | ParametersInCacheKeyAndForwardedToOrigin
    | undefined;
}
export interface CachePolicy {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  CachePolicyConfig: CachePolicyConfig | undefined;
}
export interface CachePolicySummary {
  Type: CachePolicyType | undefined;
  CachePolicy: CachePolicy | undefined;
}
export interface CachePolicyList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: CachePolicySummary[] | undefined;
}
export interface Certificate {
  Arn: string | undefined;
}
export interface CopyDistributionRequest {
  PrimaryDistributionId: string | undefined;
  Staging?: boolean | undefined;
  IfMatch?: string | undefined;
  CallerReference: string | undefined;
  Enabled?: boolean | undefined;
}
export interface ConnectionFunctionAssociation {
  Id: string | undefined;
}
export interface CustomErrorResponse {
  ErrorCode: number | undefined;
  ResponsePagePath?: string | undefined;
  ResponseCode?: string | undefined;
  ErrorCachingMinTTL?: number | undefined;
}
export interface CustomErrorResponses {
  Quantity: number | undefined;
  Items?: CustomErrorResponse[] | undefined;
}
export interface DefaultCacheBehavior {
  TargetOriginId: string | undefined;
  TrustedSigners?: TrustedSigners | undefined;
  TrustedKeyGroups?: TrustedKeyGroups | undefined;
  ViewerProtocolPolicy: ViewerProtocolPolicy | undefined;
  AllowedMethods?: AllowedMethods | undefined;
  SmoothStreaming?: boolean | undefined;
  Compress?: boolean | undefined;
  LambdaFunctionAssociations?: LambdaFunctionAssociations | undefined;
  FunctionAssociations?: FunctionAssociations | undefined;
  FieldLevelEncryptionId?: string | undefined;
  RealtimeLogConfigArn?: string | undefined;
  CachePolicyId?: string | undefined;
  OriginRequestPolicyId?: string | undefined;
  ResponseHeadersPolicyId?: string | undefined;
  GrpcConfig?: GrpcConfig | undefined;
  ForwardedValues?: ForwardedValues | undefined;
  MinTTL?: number | undefined;
  DefaultTTL?: number | undefined;
  MaxTTL?: number | undefined;
}
export interface LoggingConfig {
  Enabled?: boolean | undefined;
  IncludeCookies?: boolean | undefined;
  Bucket?: string | undefined;
  Prefix?: string | undefined;
}
export interface StatusCodes {
  Quantity: number | undefined;
  Items: number[] | undefined;
}
export interface OriginGroupFailoverCriteria {
  StatusCodes: StatusCodes | undefined;
}
export interface OriginGroupMember {
  OriginId: string | undefined;
}
export interface OriginGroupMembers {
  Quantity: number | undefined;
  Items: OriginGroupMember[] | undefined;
}
export interface OriginGroup {
  Id: string | undefined;
  FailoverCriteria: OriginGroupFailoverCriteria | undefined;
  Members: OriginGroupMembers | undefined;
  SelectionCriteria?: OriginGroupSelectionCriteria | undefined;
}
export interface OriginGroups {
  Quantity: number | undefined;
  Items?: OriginGroup[] | undefined;
}
export interface OriginCustomHeader {
  HeaderName: string | undefined;
  HeaderValue: string | undefined;
}
export interface CustomHeaders {
  Quantity: number | undefined;
  Items?: OriginCustomHeader[] | undefined;
}
export interface OriginSslProtocols {
  Quantity: number | undefined;
  Items: SslProtocol[] | undefined;
}
export interface CustomOriginConfig {
  HTTPPort: number | undefined;
  HTTPSPort: number | undefined;
  OriginProtocolPolicy: OriginProtocolPolicy | undefined;
  OriginSslProtocols?: OriginSslProtocols | undefined;
  OriginReadTimeout?: number | undefined;
  OriginKeepaliveTimeout?: number | undefined;
  IpAddressType?: IpAddressType | undefined;
}
export interface OriginShield {
  Enabled: boolean | undefined;
  OriginShieldRegion?: string | undefined;
}
export interface S3OriginConfig {
  OriginAccessIdentity: string | undefined;
  OriginReadTimeout?: number | undefined;
}
export interface VpcOriginConfig {
  VpcOriginId: string | undefined;
  OwnerAccountId?: string | undefined;
  OriginReadTimeout?: number | undefined;
  OriginKeepaliveTimeout?: number | undefined;
}
export interface Origin {
  Id: string | undefined;
  DomainName: string | undefined;
  OriginPath?: string | undefined;
  CustomHeaders?: CustomHeaders | undefined;
  S3OriginConfig?: S3OriginConfig | undefined;
  CustomOriginConfig?: CustomOriginConfig | undefined;
  VpcOriginConfig?: VpcOriginConfig | undefined;
  ConnectionAttempts?: number | undefined;
  ConnectionTimeout?: number | undefined;
  ResponseCompletionTimeout?: number | undefined;
  OriginShield?: OriginShield | undefined;
  OriginAccessControlId?: string | undefined;
}
export interface Origins {
  Quantity: number | undefined;
  Items: Origin[] | undefined;
}
export interface GeoRestriction {
  RestrictionType: GeoRestrictionType | undefined;
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface Restrictions {
  GeoRestriction: GeoRestriction | undefined;
}
export interface StringSchemaConfig {
  Comment?: string | undefined;
  DefaultValue?: string | undefined;
  Required: boolean | undefined;
}
export interface ParameterDefinitionSchema {
  StringSchema?: StringSchemaConfig | undefined;
}
export interface ParameterDefinition {
  Name: string | undefined;
  Definition: ParameterDefinitionSchema | undefined;
}
export interface TenantConfig {
  ParameterDefinitions?: ParameterDefinition[] | undefined;
}
export interface ViewerCertificate {
  CloudFrontDefaultCertificate?: boolean | undefined;
  IAMCertificateId?: string | undefined;
  ACMCertificateArn?: string | undefined;
  SSLSupportMethod?: SSLSupportMethod | undefined;
  MinimumProtocolVersion?: MinimumProtocolVersion | undefined;
  Certificate?: string | undefined;
  CertificateSource?: CertificateSource | undefined;
}
export interface TrustStoreConfig {
  TrustStoreId: string | undefined;
  AdvertiseTrustStoreCaNames?: boolean | undefined;
  IgnoreCertificateExpiry?: boolean | undefined;
}
export interface ViewerMtlsConfig {
  Mode?: ViewerMtlsMode | undefined;
  TrustStoreConfig?: TrustStoreConfig | undefined;
}
export interface DistributionConfig {
  CallerReference: string | undefined;
  Aliases?: Aliases | undefined;
  DefaultRootObject?: string | undefined;
  Origins: Origins | undefined;
  OriginGroups?: OriginGroups | undefined;
  DefaultCacheBehavior: DefaultCacheBehavior | undefined;
  CacheBehaviors?: CacheBehaviors | undefined;
  CustomErrorResponses?: CustomErrorResponses | undefined;
  Comment: string | undefined;
  Logging?: LoggingConfig | undefined;
  PriceClass?: PriceClass | undefined;
  Enabled: boolean | undefined;
  ViewerCertificate?: ViewerCertificate | undefined;
  Restrictions?: Restrictions | undefined;
  WebACLId?: string | undefined;
  HttpVersion?: HttpVersion | undefined;
  IsIPV6Enabled?: boolean | undefined;
  ContinuousDeploymentPolicyId?: string | undefined;
  Staging?: boolean | undefined;
  AnycastIpListId?: string | undefined;
  TenantConfig?: TenantConfig | undefined;
  ConnectionMode?: ConnectionMode | undefined;
  ViewerMtlsConfig?: ViewerMtlsConfig | undefined;
  ConnectionFunctionAssociation?: ConnectionFunctionAssociation | undefined;
}
export interface Distribution {
  Id: string | undefined;
  ARN: string | undefined;
  Status: string | undefined;
  LastModifiedTime: Date | undefined;
  InProgressInvalidationBatches: number | undefined;
  DomainName: string | undefined;
  ActiveTrustedSigners?: ActiveTrustedSigners | undefined;
  ActiveTrustedKeyGroups?: ActiveTrustedKeyGroups | undefined;
  DistributionConfig: DistributionConfig | undefined;
  AliasICPRecordals?: AliasICPRecordal[] | undefined;
}
export interface CopyDistributionResult {
  Distribution?: Distribution | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface Tag {
  Key: string | undefined;
  Value?: string | undefined;
}
export interface Tags {
  Items?: Tag[] | undefined;
}
export interface CreateAnycastIpListRequest {
  Name: string | undefined;
  IpCount: number | undefined;
  Tags?: Tags | undefined;
  IpAddressType?: IpAddressType | undefined;
  IpamCidrConfigs?: IpamCidrConfig[] | undefined;
}
export interface CreateAnycastIpListResult {
  AnycastIpList?: AnycastIpList | undefined;
  ETag?: string | undefined;
}
export interface CreateCachePolicyRequest {
  CachePolicyConfig: CachePolicyConfig | undefined;
}
export interface CreateCachePolicyResult {
  CachePolicy?: CachePolicy | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface CloudFrontOriginAccessIdentityConfig {
  CallerReference: string | undefined;
  Comment: string | undefined;
}
export interface CreateCloudFrontOriginAccessIdentityRequest {
  CloudFrontOriginAccessIdentityConfig:
    | CloudFrontOriginAccessIdentityConfig
    | undefined;
}
export interface CloudFrontOriginAccessIdentity {
  Id: string | undefined;
  S3CanonicalUserId: string | undefined;
  CloudFrontOriginAccessIdentityConfig?:
    | CloudFrontOriginAccessIdentityConfig
    | undefined;
}
export interface CreateCloudFrontOriginAccessIdentityResult {
  CloudFrontOriginAccessIdentity?: CloudFrontOriginAccessIdentity | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface KeyValueStoreAssociation {
  KeyValueStoreARN: string | undefined;
}
export interface KeyValueStoreAssociations {
  Quantity: number | undefined;
  Items?: KeyValueStoreAssociation[] | undefined;
}
export interface FunctionConfig {
  Comment: string | undefined;
  Runtime: FunctionRuntime | undefined;
  KeyValueStoreAssociations?: KeyValueStoreAssociations | undefined;
}
export interface CreateConnectionFunctionRequest {
  Name: string | undefined;
  ConnectionFunctionConfig: FunctionConfig | undefined;
  ConnectionFunctionCode: Uint8Array | undefined;
  Tags?: Tags | undefined;
}
export interface ConnectionFunctionSummary {
  Name: string | undefined;
  Id: string | undefined;
  ConnectionFunctionConfig: FunctionConfig | undefined;
  ConnectionFunctionArn: string | undefined;
  Status: string | undefined;
  Stage: FunctionStage | undefined;
  CreatedTime: Date | undefined;
  LastModifiedTime: Date | undefined;
}
export interface CreateConnectionFunctionResult {
  ConnectionFunctionSummary?: ConnectionFunctionSummary | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface CreateConnectionGroupRequest {
  Name: string | undefined;
  Ipv6Enabled?: boolean | undefined;
  Tags?: Tags | undefined;
  AnycastIpListId?: string | undefined;
  Enabled?: boolean | undefined;
}
export interface ConnectionGroup {
  Id?: string | undefined;
  Name?: string | undefined;
  Arn?: string | undefined;
  CreatedTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
  Tags?: Tags | undefined;
  Ipv6Enabled?: boolean | undefined;
  RoutingEndpoint?: string | undefined;
  AnycastIpListId?: string | undefined;
  Status?: string | undefined;
  Enabled?: boolean | undefined;
  IsDefault?: boolean | undefined;
}
export interface CreateConnectionGroupResult {
  ConnectionGroup?: ConnectionGroup | undefined;
  ETag?: string | undefined;
}
export interface StagingDistributionDnsNames {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface ContinuousDeploymentSingleHeaderConfig {
  Header: string | undefined;
  Value: string | undefined;
}
export interface SessionStickinessConfig {
  IdleTTL: number | undefined;
  MaximumTTL: number | undefined;
}
export interface ContinuousDeploymentSingleWeightConfig {
  Weight: number | undefined;
  SessionStickinessConfig?: SessionStickinessConfig | undefined;
}
export interface TrafficConfig {
  SingleWeightConfig?: ContinuousDeploymentSingleWeightConfig | undefined;
  SingleHeaderConfig?: ContinuousDeploymentSingleHeaderConfig | undefined;
  Type: ContinuousDeploymentPolicyType | undefined;
}
export interface ContinuousDeploymentPolicyConfig {
  StagingDistributionDnsNames: StagingDistributionDnsNames | undefined;
  Enabled: boolean | undefined;
  TrafficConfig?: TrafficConfig | undefined;
}
export interface CreateContinuousDeploymentPolicyRequest {
  ContinuousDeploymentPolicyConfig:
    | ContinuousDeploymentPolicyConfig
    | undefined;
}
export interface ContinuousDeploymentPolicy {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  ContinuousDeploymentPolicyConfig:
    | ContinuousDeploymentPolicyConfig
    | undefined;
}
export interface CreateContinuousDeploymentPolicyResult {
  ContinuousDeploymentPolicy?: ContinuousDeploymentPolicy | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface CreateDistributionRequest {
  DistributionConfig: DistributionConfig | undefined;
}
export interface CreateDistributionResult {
  Distribution?: Distribution | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface GeoRestrictionCustomization {
  RestrictionType: GeoRestrictionType | undefined;
  Locations?: string[] | undefined;
}
export interface WebAclCustomization {
  Action: CustomizationActionType | undefined;
  Arn?: string | undefined;
}
export interface Customizations {
  WebAcl?: WebAclCustomization | undefined;
  Certificate?: Certificate | undefined;
  GeoRestrictions?: GeoRestrictionCustomization | undefined;
}
export interface DomainItem {
  Domain: string | undefined;
}
export interface ManagedCertificateRequest {
  ValidationTokenHost: ValidationTokenHost | undefined;
  PrimaryDomainName?: string | undefined;
  CertificateTransparencyLoggingPreference?:
    | CertificateTransparencyLoggingPreference
    | undefined;
}
export interface Parameter {
  Name: string | undefined;
  Value: string | undefined;
}
export interface CreateDistributionTenantRequest {
  DistributionId: string | undefined;
  Name: string | undefined;
  Domains: DomainItem[] | undefined;
  Tags?: Tags | undefined;
  Customizations?: Customizations | undefined;
  Parameters?: Parameter[] | undefined;
  ConnectionGroupId?: string | undefined;
  ManagedCertificateRequest?: ManagedCertificateRequest | undefined;
  Enabled?: boolean | undefined;
}
export interface DomainResult {
  Domain: string | undefined;
  Status?: DomainStatus | undefined;
}
export interface DistributionTenant {
  Id?: string | undefined;
  DistributionId?: string | undefined;
  Name?: string | undefined;
  Arn?: string | undefined;
  Domains?: DomainResult[] | undefined;
  Tags?: Tags | undefined;
  Customizations?: Customizations | undefined;
  Parameters?: Parameter[] | undefined;
  ConnectionGroupId?: string | undefined;
  CreatedTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
  Enabled?: boolean | undefined;
  Status?: string | undefined;
}
export interface CreateDistributionTenantResult {
  DistributionTenant?: DistributionTenant | undefined;
  ETag?: string | undefined;
}
export interface DistributionConfigWithTags {
  DistributionConfig: DistributionConfig | undefined;
  Tags: Tags | undefined;
}
export interface CreateDistributionWithTagsRequest {
  DistributionConfigWithTags: DistributionConfigWithTags | undefined;
}
export interface CreateDistributionWithTagsResult {
  Distribution?: Distribution | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface ContentTypeProfile {
  Format: Format | undefined;
  ProfileId?: string | undefined;
  ContentType: string | undefined;
}
export interface ContentTypeProfiles {
  Quantity: number | undefined;
  Items?: ContentTypeProfile[] | undefined;
}
export interface ContentTypeProfileConfig {
  ForwardWhenContentTypeIsUnknown: boolean | undefined;
  ContentTypeProfiles?: ContentTypeProfiles | undefined;
}
export interface QueryArgProfile {
  QueryArg: string | undefined;
  ProfileId: string | undefined;
}
export interface QueryArgProfiles {
  Quantity: number | undefined;
  Items?: QueryArgProfile[] | undefined;
}
export interface QueryArgProfileConfig {
  ForwardWhenQueryArgProfileIsUnknown: boolean | undefined;
  QueryArgProfiles?: QueryArgProfiles | undefined;
}
export interface FieldLevelEncryptionConfig {
  CallerReference: string | undefined;
  Comment?: string | undefined;
  QueryArgProfileConfig?: QueryArgProfileConfig | undefined;
  ContentTypeProfileConfig?: ContentTypeProfileConfig | undefined;
}
export interface CreateFieldLevelEncryptionConfigRequest {
  FieldLevelEncryptionConfig: FieldLevelEncryptionConfig | undefined;
}
export interface FieldLevelEncryption {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  FieldLevelEncryptionConfig: FieldLevelEncryptionConfig | undefined;
}
export interface CreateFieldLevelEncryptionConfigResult {
  FieldLevelEncryption?: FieldLevelEncryption | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface FieldPatterns {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface EncryptionEntity {
  PublicKeyId: string | undefined;
  ProviderId: string | undefined;
  FieldPatterns: FieldPatterns | undefined;
}
export interface EncryptionEntities {
  Quantity: number | undefined;
  Items?: EncryptionEntity[] | undefined;
}
export interface FieldLevelEncryptionProfileConfig {
  Name: string | undefined;
  CallerReference: string | undefined;
  Comment?: string | undefined;
  EncryptionEntities: EncryptionEntities | undefined;
}
export interface CreateFieldLevelEncryptionProfileRequest {
  FieldLevelEncryptionProfileConfig:
    | FieldLevelEncryptionProfileConfig
    | undefined;
}
export interface FieldLevelEncryptionProfile {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  FieldLevelEncryptionProfileConfig:
    | FieldLevelEncryptionProfileConfig
    | undefined;
}
export interface CreateFieldLevelEncryptionProfileResult {
  FieldLevelEncryptionProfile?: FieldLevelEncryptionProfile | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface CreateFunctionRequest {
  Name: string | undefined;
  FunctionConfig: FunctionConfig | undefined;
  FunctionCode: Uint8Array | undefined;
}
export interface FunctionMetadata {
  FunctionARN: string | undefined;
  Stage?: FunctionStage | undefined;
  CreatedTime?: Date | undefined;
  LastModifiedTime: Date | undefined;
}
export interface FunctionSummary {
  Name: string | undefined;
  Status?: string | undefined;
  FunctionConfig: FunctionConfig | undefined;
  FunctionMetadata: FunctionMetadata | undefined;
}
export interface CreateFunctionResult {
  FunctionSummary?: FunctionSummary | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface Paths {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface InvalidationBatch {
  Paths: Paths | undefined;
  CallerReference: string | undefined;
}
export interface CreateInvalidationRequest {
  DistributionId: string | undefined;
  InvalidationBatch: InvalidationBatch | undefined;
}
export interface Invalidation {
  Id: string | undefined;
  Status: string | undefined;
  CreateTime: Date | undefined;
  InvalidationBatch: InvalidationBatch | undefined;
}
export interface CreateInvalidationResult {
  Location?: string | undefined;
  Invalidation?: Invalidation | undefined;
}
export interface CreateInvalidationForDistributionTenantRequest {
  Id: string | undefined;
  InvalidationBatch: InvalidationBatch | undefined;
}
export interface CreateInvalidationForDistributionTenantResult {
  Location?: string | undefined;
  Invalidation?: Invalidation | undefined;
}
export interface KeyGroupConfig {
  Name: string | undefined;
  Items: string[] | undefined;
  Comment?: string | undefined;
}
export interface CreateKeyGroupRequest {
  KeyGroupConfig: KeyGroupConfig | undefined;
}
export interface KeyGroup {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  KeyGroupConfig: KeyGroupConfig | undefined;
}
export interface CreateKeyGroupResult {
  KeyGroup?: KeyGroup | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface ImportSource {
  SourceType: ImportSourceType | undefined;
  SourceARN: string | undefined;
}
export interface CreateKeyValueStoreRequest {
  Name: string | undefined;
  Comment?: string | undefined;
  ImportSource?: ImportSource | undefined;
}
export interface KeyValueStore {
  Name: string | undefined;
  Id: string | undefined;
  Comment: string | undefined;
  ARN: string | undefined;
  Status?: string | undefined;
  LastModifiedTime: Date | undefined;
}
export interface CreateKeyValueStoreResult {
  KeyValueStore?: KeyValueStore | undefined;
  ETag?: string | undefined;
  Location?: string | undefined;
}
export interface RealtimeMetricsSubscriptionConfig {
  RealtimeMetricsSubscriptionStatus:
    | RealtimeMetricsSubscriptionStatus
    | undefined;
}
export interface MonitoringSubscription {
  RealtimeMetricsSubscriptionConfig?:
    | RealtimeMetricsSubscriptionConfig
    | undefined;
}
export interface CreateMonitoringSubscriptionRequest {
  DistributionId: string | undefined;
  MonitoringSubscription: MonitoringSubscription | undefined;
}
export interface CreateMonitoringSubscriptionResult {
  MonitoringSubscription?: MonitoringSubscription | undefined;
}
export interface OriginAccessControlConfig {
  Name: string | undefined;
  Description?: string | undefined;
  SigningProtocol: OriginAccessControlSigningProtocols | undefined;
  SigningBehavior: OriginAccessControlSigningBehaviors | undefined;
  OriginAccessControlOriginType: OriginAccessControlOriginTypes | undefined;
}
export interface CreateOriginAccessControlRequest {
  OriginAccessControlConfig: OriginAccessControlConfig | undefined;
}
export interface OriginAccessControl {
  Id: string | undefined;
  OriginAccessControlConfig?: OriginAccessControlConfig | undefined;
}
export interface CreateOriginAccessControlResult {
  OriginAccessControl?: OriginAccessControl | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface OriginRequestPolicyCookiesConfig {
  CookieBehavior: OriginRequestPolicyCookieBehavior | undefined;
  Cookies?: CookieNames | undefined;
}
export interface OriginRequestPolicyHeadersConfig {
  HeaderBehavior: OriginRequestPolicyHeaderBehavior | undefined;
  Headers?: Headers | undefined;
}
export interface OriginRequestPolicyQueryStringsConfig {
  QueryStringBehavior: OriginRequestPolicyQueryStringBehavior | undefined;
  QueryStrings?: QueryStringNames | undefined;
}
export interface OriginRequestPolicyConfig {
  Comment?: string | undefined;
  Name: string | undefined;
  HeadersConfig: OriginRequestPolicyHeadersConfig | undefined;
  CookiesConfig: OriginRequestPolicyCookiesConfig | undefined;
  QueryStringsConfig: OriginRequestPolicyQueryStringsConfig | undefined;
}
export interface CreateOriginRequestPolicyRequest {
  OriginRequestPolicyConfig: OriginRequestPolicyConfig | undefined;
}
export interface OriginRequestPolicy {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  OriginRequestPolicyConfig: OriginRequestPolicyConfig | undefined;
}
export interface CreateOriginRequestPolicyResult {
  OriginRequestPolicy?: OriginRequestPolicy | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface PublicKeyConfig {
  CallerReference: string | undefined;
  Name: string | undefined;
  EncodedKey: string | undefined;
  Comment?: string | undefined;
}
export interface CreatePublicKeyRequest {
  PublicKeyConfig: PublicKeyConfig | undefined;
}
export interface PublicKey {
  Id: string | undefined;
  CreatedTime: Date | undefined;
  PublicKeyConfig: PublicKeyConfig | undefined;
}
export interface CreatePublicKeyResult {
  PublicKey?: PublicKey | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface KinesisStreamConfig {
  RoleARN: string | undefined;
  StreamARN: string | undefined;
}
export interface EndPoint {
  StreamType: string | undefined;
  KinesisStreamConfig?: KinesisStreamConfig | undefined;
}
export interface CreateRealtimeLogConfigRequest {
  EndPoints: EndPoint[] | undefined;
  Fields: string[] | undefined;
  Name: string | undefined;
  SamplingRate: number | undefined;
}
export interface RealtimeLogConfig {
  ARN: string | undefined;
  Name: string | undefined;
  SamplingRate: number | undefined;
  EndPoints: EndPoint[] | undefined;
  Fields: string[] | undefined;
}
export interface CreateRealtimeLogConfigResult {
  RealtimeLogConfig?: RealtimeLogConfig | undefined;
}
export interface ResponseHeadersPolicyAccessControlAllowHeaders {
  Quantity: number | undefined;
  Items: string[] | undefined;
}
export interface ResponseHeadersPolicyAccessControlAllowMethods {
  Quantity: number | undefined;
  Items: ResponseHeadersPolicyAccessControlAllowMethodsValues[] | undefined;
}
export interface ResponseHeadersPolicyAccessControlAllowOrigins {
  Quantity: number | undefined;
  Items: string[] | undefined;
}
export interface ResponseHeadersPolicyAccessControlExposeHeaders {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface ResponseHeadersPolicyCorsConfig {
  AccessControlAllowOrigins:
    | ResponseHeadersPolicyAccessControlAllowOrigins
    | undefined;
  AccessControlAllowHeaders:
    | ResponseHeadersPolicyAccessControlAllowHeaders
    | undefined;
  AccessControlAllowMethods:
    | ResponseHeadersPolicyAccessControlAllowMethods
    | undefined;
  AccessControlAllowCredentials: boolean | undefined;
  AccessControlExposeHeaders?:
    | ResponseHeadersPolicyAccessControlExposeHeaders
    | undefined;
  AccessControlMaxAgeSec?: number | undefined;
  OriginOverride: boolean | undefined;
}
export interface ResponseHeadersPolicyCustomHeader {
  Header: string | undefined;
  Value: string | undefined;
  Override: boolean | undefined;
}
export interface ResponseHeadersPolicyCustomHeadersConfig {
  Quantity: number | undefined;
  Items?: ResponseHeadersPolicyCustomHeader[] | undefined;
}
export interface ResponseHeadersPolicyRemoveHeader {
  Header: string | undefined;
}
export interface ResponseHeadersPolicyRemoveHeadersConfig {
  Quantity: number | undefined;
  Items?: ResponseHeadersPolicyRemoveHeader[] | undefined;
}
export interface ResponseHeadersPolicyContentSecurityPolicy {
  Override: boolean | undefined;
  ContentSecurityPolicy: string | undefined;
}
export interface ResponseHeadersPolicyContentTypeOptions {
  Override: boolean | undefined;
}
export interface ResponseHeadersPolicyFrameOptions {
  Override: boolean | undefined;
  FrameOption: FrameOptionsList | undefined;
}
export interface ResponseHeadersPolicyReferrerPolicy {
  Override: boolean | undefined;
  ReferrerPolicy: ReferrerPolicyList | undefined;
}
export interface ResponseHeadersPolicyStrictTransportSecurity {
  Override: boolean | undefined;
  IncludeSubdomains?: boolean | undefined;
  Preload?: boolean | undefined;
  AccessControlMaxAgeSec: number | undefined;
}
export interface ResponseHeadersPolicyXSSProtection {
  Override: boolean | undefined;
  Protection: boolean | undefined;
  ModeBlock?: boolean | undefined;
  ReportUri?: string | undefined;
}
export interface ResponseHeadersPolicySecurityHeadersConfig {
  XSSProtection?: ResponseHeadersPolicyXSSProtection | undefined;
  FrameOptions?: ResponseHeadersPolicyFrameOptions | undefined;
  ReferrerPolicy?: ResponseHeadersPolicyReferrerPolicy | undefined;
  ContentSecurityPolicy?:
    | ResponseHeadersPolicyContentSecurityPolicy
    | undefined;
  ContentTypeOptions?: ResponseHeadersPolicyContentTypeOptions | undefined;
  StrictTransportSecurity?:
    | ResponseHeadersPolicyStrictTransportSecurity
    | undefined;
}
export interface ResponseHeadersPolicyServerTimingHeadersConfig {
  Enabled: boolean | undefined;
  SamplingRate?: number | undefined;
}
export interface ResponseHeadersPolicyConfig {
  Comment?: string | undefined;
  Name: string | undefined;
  CorsConfig?: ResponseHeadersPolicyCorsConfig | undefined;
  SecurityHeadersConfig?:
    | ResponseHeadersPolicySecurityHeadersConfig
    | undefined;
  ServerTimingHeadersConfig?:
    | ResponseHeadersPolicyServerTimingHeadersConfig
    | undefined;
  CustomHeadersConfig?: ResponseHeadersPolicyCustomHeadersConfig | undefined;
  RemoveHeadersConfig?: ResponseHeadersPolicyRemoveHeadersConfig | undefined;
}
export interface CreateResponseHeadersPolicyRequest {
  ResponseHeadersPolicyConfig: ResponseHeadersPolicyConfig | undefined;
}
export interface ResponseHeadersPolicy {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  ResponseHeadersPolicyConfig: ResponseHeadersPolicyConfig | undefined;
}
export interface CreateResponseHeadersPolicyResult {
  ResponseHeadersPolicy?: ResponseHeadersPolicy | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface StreamingLoggingConfig {
  Enabled: boolean | undefined;
  Bucket: string | undefined;
  Prefix: string | undefined;
}
export interface S3Origin {
  DomainName: string | undefined;
  OriginAccessIdentity: string | undefined;
}
export interface StreamingDistributionConfig {
  CallerReference: string | undefined;
  S3Origin: S3Origin | undefined;
  Aliases?: Aliases | undefined;
  Comment: string | undefined;
  Logging?: StreamingLoggingConfig | undefined;
  TrustedSigners: TrustedSigners | undefined;
  PriceClass?: PriceClass | undefined;
  Enabled: boolean | undefined;
}
export interface CreateStreamingDistributionRequest {
  StreamingDistributionConfig: StreamingDistributionConfig | undefined;
}
export interface StreamingDistribution {
  Id: string | undefined;
  ARN: string | undefined;
  Status: string | undefined;
  LastModifiedTime?: Date | undefined;
  DomainName: string | undefined;
  ActiveTrustedSigners: ActiveTrustedSigners | undefined;
  StreamingDistributionConfig: StreamingDistributionConfig | undefined;
}
export interface CreateStreamingDistributionResult {
  StreamingDistribution?: StreamingDistribution | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface StreamingDistributionConfigWithTags {
  StreamingDistributionConfig: StreamingDistributionConfig | undefined;
  Tags: Tags | undefined;
}
export interface CreateStreamingDistributionWithTagsRequest {
  StreamingDistributionConfigWithTags:
    | StreamingDistributionConfigWithTags
    | undefined;
}
export interface CreateStreamingDistributionWithTagsResult {
  StreamingDistribution?: StreamingDistribution | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface CreateTrustStoreRequest {
  Name: string | undefined;
  CaCertificatesBundleSource: CaCertificatesBundleSource | undefined;
  Tags?: Tags | undefined;
}
export interface TrustStore {
  Id?: string | undefined;
  Arn?: string | undefined;
  Name?: string | undefined;
  Status?: TrustStoreStatus | undefined;
  NumberOfCaCertificates?: number | undefined;
  LastModifiedTime?: Date | undefined;
  Reason?: string | undefined;
}
export interface CreateTrustStoreResult {
  TrustStore?: TrustStore | undefined;
  ETag?: string | undefined;
}
export interface VpcOriginEndpointConfig {
  Name: string | undefined;
  Arn: string | undefined;
  HTTPPort: number | undefined;
  HTTPSPort: number | undefined;
  OriginProtocolPolicy: OriginProtocolPolicy | undefined;
  OriginSslProtocols?: OriginSslProtocols | undefined;
}
export interface CreateVpcOriginRequest {
  VpcOriginEndpointConfig: VpcOriginEndpointConfig | undefined;
  Tags?: Tags | undefined;
}
export interface VpcOrigin {
  Id: string | undefined;
  Arn: string | undefined;
  AccountId?: string | undefined;
  Status: string | undefined;
  CreatedTime: Date | undefined;
  LastModifiedTime: Date | undefined;
  VpcOriginEndpointConfig: VpcOriginEndpointConfig | undefined;
}
export interface CreateVpcOriginResult {
  VpcOrigin?: VpcOrigin | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export interface DeleteAnycastIpListRequest {
  Id: string | undefined;
  IfMatch: string | undefined;
}
export interface DeleteCachePolicyRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DeleteCloudFrontOriginAccessIdentityRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DeleteConnectionFunctionRequest {
  Id: string | undefined;
  IfMatch: string | undefined;
}
export interface DeleteConnectionGroupRequest {
  Id: string | undefined;
  IfMatch: string | undefined;
}
export interface DeleteContinuousDeploymentPolicyRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DeleteDistributionRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DeleteDistributionTenantRequest {
  Id: string | undefined;
  IfMatch: string | undefined;
}
export interface DeleteFieldLevelEncryptionConfigRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DeleteFieldLevelEncryptionProfileRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DeleteFunctionRequest {
  Name: string | undefined;
  IfMatch: string | undefined;
}
export interface DeleteKeyGroupRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DeleteKeyValueStoreRequest {
  Name: string | undefined;
  IfMatch: string | undefined;
}
export interface DeleteMonitoringSubscriptionRequest {
  DistributionId: string | undefined;
}
export interface DeleteMonitoringSubscriptionResult {}
export interface DeleteOriginAccessControlRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DeleteOriginRequestPolicyRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DeletePublicKeyRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DeleteRealtimeLogConfigRequest {
  Name?: string | undefined;
  ARN?: string | undefined;
}
export interface DeleteResourcePolicyRequest {
  ResourceArn: string | undefined;
}
export interface DeleteResponseHeadersPolicyRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DeleteStreamingDistributionRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DeleteTrustStoreRequest {
  Id: string | undefined;
  IfMatch: string | undefined;
}
export interface DeleteVpcOriginRequest {
  Id: string | undefined;
  IfMatch: string | undefined;
}
export interface DeleteVpcOriginResult {
  VpcOrigin?: VpcOrigin | undefined;
  ETag?: string | undefined;
}
export interface DescribeConnectionFunctionRequest {
  Identifier: string | undefined;
  Stage?: FunctionStage | undefined;
}
export interface DescribeConnectionFunctionResult {
  ConnectionFunctionSummary?: ConnectionFunctionSummary | undefined;
  ETag?: string | undefined;
}
export interface DescribeFunctionRequest {
  Name: string | undefined;
  Stage?: FunctionStage | undefined;
}
export interface DescribeFunctionResult {
  FunctionSummary?: FunctionSummary | undefined;
  ETag?: string | undefined;
}
export interface DescribeKeyValueStoreRequest {
  Name: string | undefined;
}
export interface DescribeKeyValueStoreResult {
  KeyValueStore?: KeyValueStore | undefined;
  ETag?: string | undefined;
}
export interface DisassociateDistributionTenantWebACLRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DisassociateDistributionTenantWebACLResult {
  Id?: string | undefined;
  ETag?: string | undefined;
}
export interface DisassociateDistributionWebACLRequest {
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface DisassociateDistributionWebACLResult {
  Id?: string | undefined;
  ETag?: string | undefined;
}
export interface GetAnycastIpListRequest {
  Id: string | undefined;
}
export interface GetAnycastIpListResult {
  AnycastIpList?: AnycastIpList | undefined;
  ETag?: string | undefined;
}
export interface GetCachePolicyRequest {
  Id: string | undefined;
}
export interface GetCachePolicyResult {
  CachePolicy?: CachePolicy | undefined;
  ETag?: string | undefined;
}
export interface GetCachePolicyConfigRequest {
  Id: string | undefined;
}
export interface GetCachePolicyConfigResult {
  CachePolicyConfig?: CachePolicyConfig | undefined;
  ETag?: string | undefined;
}
export interface GetCloudFrontOriginAccessIdentityRequest {
  Id: string | undefined;
}
export interface GetCloudFrontOriginAccessIdentityResult {
  CloudFrontOriginAccessIdentity?: CloudFrontOriginAccessIdentity | undefined;
  ETag?: string | undefined;
}
export interface GetCloudFrontOriginAccessIdentityConfigRequest {
  Id: string | undefined;
}
export interface GetCloudFrontOriginAccessIdentityConfigResult {
  CloudFrontOriginAccessIdentityConfig?:
    | CloudFrontOriginAccessIdentityConfig
    | undefined;
  ETag?: string | undefined;
}
export interface GetConnectionFunctionRequest {
  Identifier: string | undefined;
  Stage?: FunctionStage | undefined;
}
export interface GetConnectionFunctionResult {
  ConnectionFunctionCode?: Uint8Array | undefined;
  ETag?: string | undefined;
  ContentType?: string | undefined;
}
export interface GetConnectionGroupRequest {
  Identifier: string | undefined;
}
export interface GetConnectionGroupResult {
  ConnectionGroup?: ConnectionGroup | undefined;
  ETag?: string | undefined;
}
export interface GetConnectionGroupByRoutingEndpointRequest {
  RoutingEndpoint: string | undefined;
}
export interface GetConnectionGroupByRoutingEndpointResult {
  ConnectionGroup?: ConnectionGroup | undefined;
  ETag?: string | undefined;
}
export interface GetContinuousDeploymentPolicyRequest {
  Id: string | undefined;
}
export interface GetContinuousDeploymentPolicyResult {
  ContinuousDeploymentPolicy?: ContinuousDeploymentPolicy | undefined;
  ETag?: string | undefined;
}
export interface GetContinuousDeploymentPolicyConfigRequest {
  Id: string | undefined;
}
export interface GetContinuousDeploymentPolicyConfigResult {
  ContinuousDeploymentPolicyConfig?:
    | ContinuousDeploymentPolicyConfig
    | undefined;
  ETag?: string | undefined;
}
export interface GetDistributionRequest {
  Id: string | undefined;
}
export interface GetDistributionResult {
  Distribution?: Distribution | undefined;
  ETag?: string | undefined;
}
export interface GetDistributionConfigRequest {
  Id: string | undefined;
}
export interface GetDistributionConfigResult {
  DistributionConfig?: DistributionConfig | undefined;
  ETag?: string | undefined;
}
export interface GetDistributionTenantRequest {
  Identifier: string | undefined;
}
export interface GetDistributionTenantResult {
  DistributionTenant?: DistributionTenant | undefined;
  ETag?: string | undefined;
}
export interface GetDistributionTenantByDomainRequest {
  Domain: string | undefined;
}
export interface GetDistributionTenantByDomainResult {
  DistributionTenant?: DistributionTenant | undefined;
  ETag?: string | undefined;
}
export interface GetFieldLevelEncryptionRequest {
  Id: string | undefined;
}
export interface GetFieldLevelEncryptionResult {
  FieldLevelEncryption?: FieldLevelEncryption | undefined;
  ETag?: string | undefined;
}
export interface GetFieldLevelEncryptionConfigRequest {
  Id: string | undefined;
}
export interface GetFieldLevelEncryptionConfigResult {
  FieldLevelEncryptionConfig?: FieldLevelEncryptionConfig | undefined;
  ETag?: string | undefined;
}
export interface GetFieldLevelEncryptionProfileRequest {
  Id: string | undefined;
}
export interface GetFieldLevelEncryptionProfileResult {
  FieldLevelEncryptionProfile?: FieldLevelEncryptionProfile | undefined;
  ETag?: string | undefined;
}
export interface GetFieldLevelEncryptionProfileConfigRequest {
  Id: string | undefined;
}
export interface GetFieldLevelEncryptionProfileConfigResult {
  FieldLevelEncryptionProfileConfig?:
    | FieldLevelEncryptionProfileConfig
    | undefined;
  ETag?: string | undefined;
}
export interface GetFunctionRequest {
  Name: string | undefined;
  Stage?: FunctionStage | undefined;
}
export interface GetFunctionResult {
  FunctionCode?: Uint8Array | undefined;
  ETag?: string | undefined;
  ContentType?: string | undefined;
}
export interface GetInvalidationRequest {
  DistributionId: string | undefined;
  Id: string | undefined;
}
export interface GetInvalidationResult {
  Invalidation?: Invalidation | undefined;
}
export interface GetInvalidationForDistributionTenantRequest {
  DistributionTenantId: string | undefined;
  Id: string | undefined;
}
export interface GetInvalidationForDistributionTenantResult {
  Invalidation?: Invalidation | undefined;
}
export interface GetKeyGroupRequest {
  Id: string | undefined;
}
export interface GetKeyGroupResult {
  KeyGroup?: KeyGroup | undefined;
  ETag?: string | undefined;
}
export interface GetKeyGroupConfigRequest {
  Id: string | undefined;
}
export interface GetKeyGroupConfigResult {
  KeyGroupConfig?: KeyGroupConfig | undefined;
  ETag?: string | undefined;
}
export interface GetManagedCertificateDetailsRequest {
  Identifier: string | undefined;
}
