/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.Arrays;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.klimt.UGroup;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.url.Url;

public class EntityImageChenRelationship
extends AbstractEntityImage {
    private final boolean isIdentifying = this.hasStereotype("<<identifying>>");
    private final TextBlock title;
    private final Url url;

    public EntityImageChenRelationship(Entity entity) {
        super(entity);
        FontConfiguration titleFontConfiguration = EntityImageChenRelationship.getStyleTitle(entity, this.getSkinParam()).getFontConfiguration(this.getSkinParam().getIHtmlColorSet(), entity.getColors());
        this.title = entity.getDisplay().create8(titleFontConfiguration, HorizontalAlignment.CENTER, this.getSkinParam(), CreoleMode.FULL, this.getStyle().wrapWidth());
        this.url = entity.getUrl99();
    }

    private boolean hasStereotype(String stereotype) {
        return this.getEntity().getStereotype() != null && this.getEntity().getStereotype().toString().contains(stereotype);
    }

    private Style getStyle() {
        return EntityImageChenRelationship.getStyle(this.getEntity(), this.getSkinParam());
    }

    private static Style getStyle(Entity group, ISkinParam skinParam) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chenEerDiagram, SName.chenRelationship).withTOBECHANGED(group.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    private static Style getStyleTitle(Entity group, ISkinParam skinParam) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chenEerDiagram, SName.chenRelationship, SName.title).withTOBECHANGED(group.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.DIAMOND;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dimTitle = this.title.calculateDimension(stringBounder);
        double diagonal = (dimTitle.getWidth() + 2.0 * dimTitle.getHeight()) / Math.sqrt(5.0) + 10.0;
        return new XDimension2D(diagonal * Math.sqrt(5.0), diagonal * Math.sqrt(5.0) / 2.0);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.startGroup(UGroup.singletonMap(UGroupType.ID, this.getEntity().getQuark().toStringPoint()));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        XDimension2D dimTotal = this.calculateDimension(ug.getStringBounder());
        XDimension2D dimTitle = this.title.calculateDimension(ug.getStringBounder());
        UStroke stroke = this.getStyle().getStroke(this.getEntity().getColors());
        ug = this.applyColor(ug);
        ug = ug.apply(stroke);
        ug.draw(this.getShape(dimTotal));
        if (this.isIdentifying) {
            ug.apply(new UTranslate(10.0, 5.0)).draw(this.getShape(dimTotal.delta(-20.0, -10.0)));
        }
        double xTitle = (dimTotal.getWidth() - dimTitle.getWidth()) / 2.0;
        double yTitle = (dimTotal.getHeight() - dimTitle.getHeight()) / 2.0;
        this.title.drawU(ug.apply(new UTranslate(xTitle, yTitle)));
        if (this.url != null) {
            ug.closeUrl();
        }
        ug.closeGroup();
    }

    protected final UGraphic applyColor(UGraphic ug) {
        Colors colors = this.getEntity().getColors();
        HColor border = colors.getColor(ColorType.LINE);
        if (border == null) {
            border = this.getStyle().value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(border);
        HColor backcolor = colors.getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = this.getStyle().value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(backcolor.bg());
        return ug;
    }

    private UShape getShape(XDimension2D dimTotal) {
        double width = dimTotal.getWidth();
        double height = dimTotal.getHeight();
        XPoint2D p1 = new XPoint2D(0.0, height / 2.0);
        XPoint2D p2 = new XPoint2D(width / 2.0, 0.0);
        XPoint2D p3 = new XPoint2D(width, height / 2.0);
        XPoint2D p4 = new XPoint2D(width / 2.0, height);
        return new UPolygon(Arrays.asList(p1, p2, p3, p4));
    }
}

