# OutputSerialisedAuth
<span class="source-link">[[Source]](src/serialise/serialise.md#L-0-69)</span>

This is a capability token that allows the holder to examine serialised data.
This should only be provided to types that need to write serialised data to
some output stream, such as a file or socket. A type with the [SerialiseAuth](serialise-SerialiseAuth.md)
capability should usually not also have OutputSerialisedAuth, as the
combination gives the holder the ability to examine the bitwise contents of
any object it has a reference to.


```pony
primitive val OutputSerialisedAuth
```

## Constructors

### create
<span class="source-link">[[Source]](src/serialise/serialise.md#L-0-78)</span>


```pony
new val create(
  auth: AmbientAuth val)
: OutputSerialisedAuth val^
```
#### Parameters

*   auth: [AmbientAuth](builtin-AmbientAuth.md) val

#### Returns

* [OutputSerialisedAuth](serialise-OutputSerialisedAuth.md) val^

---

## Public Functions

### eq
<span class="source-link">[[Source]](src/serialise/serialise.md#L-0-78)</span>


```pony
fun box eq(
  that: OutputSerialisedAuth val)
: Bool val
```
#### Parameters

*   that: [OutputSerialisedAuth](serialise-OutputSerialisedAuth.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/serialise/serialise.md#L-0-78)</span>


```pony
fun box ne(
  that: OutputSerialisedAuth val)
: Bool val
```
#### Parameters

*   that: [OutputSerialisedAuth](serialise-OutputSerialisedAuth.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

