/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.MethodHandleType;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.core.HashUtilities;
import com.strobel.core.VerifyArgument;

public final class MethodHandle {
    private final MethodReference _method;
    private final MethodHandleType _handleType;

    public MethodHandle(MethodReference method, MethodHandleType handleType) {
        this._method = VerifyArgument.notNull(method, "method");
        this._handleType = VerifyArgument.notNull(handleType, "handleType");
    }

    public int hashCode() {
        return HashUtilities.combineHashCodes((Object)this._method, (Object)this._handleType);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodHandle) {
            MethodHandle other = (MethodHandle)obj;
            return other._handleType == this._handleType && other._method.isEquivalentTo(this._method);
        }
        return false;
    }

    public final MethodHandleType getHandleType() {
        return this._handleType;
    }

    public final MethodReference getMethod() {
        return this._method;
    }

    public final String toString() {
        return (Object)((Object)this._handleType) + " " + this._method.getFullName() + ":" + this._method.getSignature();
    }
}

