/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.ast.PyAstDecoratorList;
import com.jetbrains.python.codeInsight.PyPsiIndexUtil;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyYieldExpression;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PyConvertMethodToPropertyIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.convert.method.to.property", new Object[0]);
        if (string == null) {
            PyConvertMethodToPropertyIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyPsiBundle.message("INTN.convert.method.to.property", new Object[0]);
        if (string == null) {
            PyConvertMethodToPropertyIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile psiFile) {
        if (project == null) {
            PyConvertMethodToPropertyIntention.$$$reportNull$$$0(2);
        }
        if (!(psiFile instanceof PyFile)) {
            return false;
        }
        PsiElement element = PyUtil.findNonWhitespaceAtOffset(psiFile, editor2.getCaretModel().getOffset());
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (function == null) {
            return false;
        }
        PyClass containingClass = function.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (function.getParameterList().getParameters().length > 1) {
            return false;
        }
        PyAstDecoratorList decoratorList = function.getDecoratorList();
        if (decoratorList != null) {
            return false;
        }
        final boolean[] available2 = new boolean[]{false};
        function.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReturnStatement(@NotNull PyReturnStatement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node.getExpression() != null) {
                    available2[0] = true;
                }
            }

            @Override
            public void visitPyYieldExpression(@NotNull PyYieldExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                available2[0] = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyConvertMethodToPropertyIntention$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyReturnStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyYieldExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return available2[0];
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        PsiElement element;
        PyFunction problemFunction;
        if (project == null) {
            PyConvertMethodToPropertyIntention.$$$reportNull$$$0(3);
        }
        if ((problemFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)(element = PyUtil.findNonWhitespaceAtOffset(file, editor2.getCaretModel().getOffset())), PyFunction.class)) == null) {
            return;
        }
        PyClass containingClass = problemFunction.getContainingClass();
        if (containingClass == null) {
            return;
        }
        List<UsageInfo> usages = PyPsiIndexUtil.findUsages((PsiNamedElement)problemFunction, false);
        if (!PyConvertMethodToPropertyIntention.prepareForWrite(file, usages)) {
            return;
        }
        WriteAction.run(() -> {
            PyUtil.addDecorator(problemFunction, "@property");
            PyConvertMethodToPropertyIntention.deleteUsages(usages);
        });
    }

    private static boolean prepareForWrite(PsiFile file, List<UsageInfo> usages) {
        List toWrite = ContainerUtil.prepend((List)ContainerUtil.mapNotNull(usages, UsageInfo::getElement), (Object[])new PsiElement[]{file});
        return FileModificationService.getInstance().preparePsiElementsForWrite((Collection)toWrite);
    }

    private static void deleteUsages(List<UsageInfo> usages) {
        for (UsageInfo usage : usages) {
            PsiElement parent;
            PsiElement usageElement = usage.getElement();
            if (!(usageElement instanceof PyReferenceExpression) || !((parent = usageElement.getParent()) instanceof PyCallExpression)) continue;
            PyCallExpression callExpression = (PyCallExpression)parent;
            PyConvertMethodToPropertyIntention.convertCallExpToRefExpr(callExpression);
        }
    }

    private static void convertCallExpToRefExpr(PyCallExpression callExpression) {
        PyExpression callee = callExpression.getCallee();
        if (callee == null) {
            throw new PsiInvalidElementAccessException((PsiElement)callExpression);
        }
        String newReferenceExpressionText = callee.getText();
        PyExpression newExpression = PyElementGenerator.getInstance(callExpression.getProject()).createExpressionFromText(LanguageLevel.forElement((PsiElement)callExpression), newReferenceExpressionText);
        if (!(newExpression instanceof PyReferenceExpression)) {
            throw new IllegalStateException("Failed to create reference expression from call expression with text: \"" + callExpression.getText() + "\"");
        }
        PyReferenceExpression referenceExpression = (PyReferenceExpression)newExpression;
        callExpression.replace((PsiElement)referenceExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyConvertMethodToPropertyIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyConvertMethodToPropertyIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

