/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.diagram;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.schemacrawler.exceptions.SchemaCrawlerException;
import schemacrawler.tools.command.text.diagram.GraphExecutor;
import schemacrawler.tools.command.text.diagram.GraphExecutorFactory;
import schemacrawler.tools.command.text.diagram.options.DiagramOptions;
import schemacrawler.tools.command.text.diagram.options.DiagramOutputFormat;
import schemacrawler.tools.command.text.schema.options.SchemaTextDetailType;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import schemacrawler.tools.text.formatter.diagram.SchemaDotFormatter;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.tools.traversal.SchemaTraverser;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.property.PropertyName;

public final class DiagramRenderer
extends BaseSchemaCrawlerCommand<DiagramOptions> {
    private DiagramOutputFormat diagramOutputFormat;
    private final GraphExecutorFactory graphExecutorFactory;

    public DiagramRenderer(PropertyName command, GraphExecutorFactory graphExecutorFactory) {
        super(command);
        this.graphExecutorFactory = Objects.requireNonNull(graphExecutorFactory, "No graph executor factory provided");
    }

    @Override
    public void checkAvailability() {
        this.graphExecutorFactory.canGenerate(this.diagramOutputFormat);
    }

    @Override
    public void execute() {
        Path dotFile;
        this.checkCatalog();
        this.outputOptions = OutputOptionsBuilder.builder(this.outputOptions).withOutputFormat(this.diagramOutputFormat).withOutputFormatValue(this.diagramOutputFormat.getFormat()).toOptions();
        try {
            dotFile = IOUtility.createTempFilePath("schemacrawler.", "dot");
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not create temporary DOT file", e);
        }
        OutputOptions dotFileOutputOptions = this.diagramOutputFormat == DiagramOutputFormat.scdot ? this.outputOptions : OutputOptionsBuilder.builder(this.outputOptions).withOutputFormat(DiagramOutputFormat.scdot).withOutputFile(dotFile).toOptions();
        SchemaTraversalHandler formatter = this.getSchemaTraversalHandler(dotFileOutputOptions);
        SchemaTraverser traverser = new SchemaTraverser();
        traverser.setCatalog(this.catalog);
        traverser.setHandler(formatter);
        traverser.setTablesComparator(NamedObjectSort.getNamedObjectSort(((DiagramOptions)this.commandOptions).isAlphabeticalSortForTables()));
        traverser.setRoutinesComparator(NamedObjectSort.getNamedObjectSort(((DiagramOptions)this.commandOptions).isAlphabeticalSortForRoutines()));
        traverser.traverse();
        Path outputFile = this.outputOptions.getOutputFile(this.outputOptions.getOutputFormatValue());
        this.outputOptions = OutputOptionsBuilder.builder(this.outputOptions).withOutputFormat(this.diagramOutputFormat).withOutputFormatValue(this.diagramOutputFormat.getFormat()).withOutputFile(outputFile).toOptions();
        try {
            GraphExecutor graphExecutor = this.graphExecutorFactory.getGraphExecutor(dotFile, this.diagramOutputFormat, outputFile, (DiagramOptions)this.commandOptions);
            graphExecutor.run();
        }
        catch (Exception e) {
            String errorMessage = this.extractErrorMessage(e);
            String helpText = IOUtility.readResourceFully("/dot.error.txt");
            throw new ExecutionRuntimeException("%s%n%n%s".formatted(errorMessage, helpText), e);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.diagramOutputFormat = DiagramOutputFormat.fromFormat(this.outputOptions.getOutputFormatValue());
    }

    @Override
    public boolean usesConnection() {
        return false;
    }

    private String extractErrorMessage(Exception e) {
        boolean isSchemaCrawlerException = e instanceof SchemaCrawlerException;
        Object errorMessage = isSchemaCrawlerException ? e.getMessage() : "Could not generate diagram" + e.getMessage();
        return errorMessage;
    }

    private SchemaTextDetailType getSchemaTextDetailType() {
        SchemaTextDetailType schemaTextDetailType;
        try {
            schemaTextDetailType = SchemaTextDetailType.valueOf(this.command.getName());
        }
        catch (IllegalArgumentException e) {
            schemaTextDetailType = null;
        }
        return schemaTextDetailType;
    }

    private SchemaTraversalHandler getSchemaTraversalHandler(OutputOptions outputOptions) {
        SchemaTextDetailType schemaTextDetailType = this.getSchemaTextDetailType();
        return new SchemaDotFormatter(schemaTextDetailType, (DiagramOptions)this.commandOptions, outputOptions, this.identifiers);
    }
}

