/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFunction;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutureCallback;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutures;
import net.snowflake.client.jdbc.internal.google.api.core.SettableApiFuture;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiExceptions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ApiFutureUtils;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.MoreExecutors;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.NonNull;

final class AsyncAppendingQueue<@NonNull T>
implements AutoCloseable {
    private final Executor exec;
    private final int maxElementsPerCompact;
    private final ApiFunction<ImmutableList<T>, T> compactFunction;
    private final AtomicInteger orderSequence;
    private final SettableApiFuture<T> finalResult;
    private final PriorityQueue<Element<T>> queue;
    private final AtomicReference<Throwable> shortCircuitFailure;
    private final ApiFutureCallback<T> shortCircuitRegistrationCallback;
    private final ReentrantLock lock;
    private volatile State state;

    private AsyncAppendingQueue(Executor exec, int maxElementsPerCompact, ApiFunction<ImmutableList<T>, T> compactFunction) {
        this.exec = exec;
        this.maxElementsPerCompact = maxElementsPerCompact;
        this.compactFunction = compactFunction;
        this.orderSequence = new AtomicInteger(0);
        this.finalResult = SettableApiFuture.create();
        this.queue = new PriorityQueue(maxElementsPerCompact, Element.COMP);
        this.state = State.OPEN;
        this.shortCircuitFailure = new AtomicReference<Object>(null);
        this.shortCircuitRegistrationCallback = throwable -> {
            if (this.state.isOpen()) {
                this.shortCircuitFailure.compareAndSet(null, throwable);
            }
        };
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsyncAppendingQueue<T> append(ApiFuture<T> value) throws ShortCircuitException {
        this.lock.lock();
        try {
            boolean isFull;
            Preconditions.checkState(this.state.isOpen(), "already closed");
            Throwable throwable = this.shortCircuitFailure.get();
            if (throwable != null) {
                ShortCircuitException shortCircuitException = new ShortCircuitException(throwable);
                this.finalResult.cancel(true);
                throw shortCircuitException;
            }
            Preconditions.checkNotNull(value, "value must not be null");
            Element<T> newElement = this.newElement(value);
            this.queue.offer(newElement);
            boolean bl = isFull = this.queue.size() == this.maxElementsPerCompact;
            if (isFull) {
                Element<T> compact = this.compact(this.exec);
                this.queue.offer(compact);
            }
            AsyncAppendingQueue asyncAppendingQueue = this;
            return asyncAppendingQueue;
        }
        finally {
            this.lock.unlock();
        }
    }

    ApiFuture<T> getResult() {
        return this.finalResult;
    }

    T await() {
        return ApiExceptions.callAndTranslateApiException(this.finalResult);
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            if (!this.state.isOpen()) {
                return;
            }
            this.state = State.CLOSING;
            if (this.queue.isEmpty()) {
                NoSuchElementException neverAppendedTo = new NoSuchElementException("Never appended to");
                this.finalResult.setException(neverAppendedTo);
                throw neverAppendedTo;
            }
            Element<T> transform = this.compact(this.exec);
            ApiFutures.addCallback(transform.getValue(), new ApiFutureCallback<T>(){

                @Override
                public void onFailure(Throwable err) {
                    AsyncAppendingQueue.this.finalResult.setException(err);
                }

                @Override
                public void onSuccess(T t2) {
                    AsyncAppendingQueue.this.finalResult.set(t2);
                }
            }, this.exec);
            this.state = State.CLOSED;
        }
        finally {
            this.lock.unlock();
        }
    }

    private @NonNull Element<T> newElement(ApiFuture<T> value) {
        ApiFutures.addCallback(value, this.shortCircuitRegistrationCallback, MoreExecutors.directExecutor());
        return new Element<T>(this.orderSequence.getAndIncrement(), value);
    }

    private @NonNull Element<T> compact(Executor executor) {
        Element<T> curr;
        ArrayList<Element<T>> elements = new ArrayList<Element<T>>();
        Element<T> peek = this.queue.peek();
        Preconditions.checkState(peek != null, "attempt to compact empty queue");
        int order = peek.getOrder();
        while ((curr = this.queue.poll()) != null) {
            elements.add(curr);
        }
        List pending = elements.stream().map(Element::getValue).collect(Collectors.toList());
        ApiFuture futureTs = ApiFutureUtils.quietAllAsList(pending);
        ApiFuture<Object> transform = ApiFutures.transform(futureTs, ts -> this.compactFunction.apply(ImmutableList.copyOf(ts)), executor);
        return new Element<Object>(order, transform);
    }

    public static <T> AsyncAppendingQueue<T> of(Executor exec, int maxElementsPerCompact, ApiFunction<ImmutableList<T>, T> compactFunction) {
        Preconditions.checkNotNull(exec, "exec must be non-null");
        Preconditions.checkArgument(maxElementsPerCompact > 1, "maxElementsPerCompact must be > 1");
        Preconditions.checkNotNull(compactFunction, "compactFunction must be non-null");
        return new AsyncAppendingQueue<T>(exec, maxElementsPerCompact, compactFunction);
    }

    private static final class Element<T> {
        private static final Comparator<Element<?>> COMP = Comparator.comparing(Element::getOrder);
        private final int order;
        private final ApiFuture<T> value;

        public Element(int order, ApiFuture<T> value) {
            this.order = order;
            this.value = value;
        }

        public int getOrder() {
            return this.order;
        }

        public ApiFuture<T> getValue() {
            return this.value;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("order", this.order).add("value", this.value).toString();
        }
    }

    private static enum State {
        OPEN,
        CLOSING,
        CLOSED;


        boolean isOpen() {
            return this == OPEN;
        }
    }

    static final class ShortCircuitException
    extends RuntimeException {
        private ShortCircuitException(Throwable instigator) {
            super("Short Circuiting due to previously failed future", instigator);
        }
    }
}

