/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Repeatable(value=Slots.class)
public @interface Slot {
    public SlotKind value();

    public boolean isComplex() default false;

    public static enum SlotKind {
        nb_bool("__bool__"),
        nb_index("__index__"),
        nb_int("__int__"),
        nb_float("__float__"),
        nb_absolute("__abs__"),
        nb_positive("__pos__"),
        nb_negative("__neg__"),
        nb_invert("__invert__"),
        nb_add("__add__, __radd__"),
        nb_subtract("__sub__, __rsub__"),
        nb_multiply("__mul__, __rmul__"),
        nb_remainder("__mod__, __rmod__"),
        nb_divmod("__divmod__, __rdivmod__"),
        nb_lshift("__lshift__, __rlshift__"),
        nb_rshift("__rshift__, __rrshift__"),
        nb_and("__and__, __rand__"),
        nb_xor("__xor__, __rxor__"),
        nb_or("__or__, __ror__"),
        nb_floor_divide("__floordiv__, __rfloordiv__"),
        nb_true_divide("__truediv__, __rtruediv__"),
        nb_matrix_multiply("__matmul__, __rmatmul__"),
        nb_power("__pow__, __rpow__"),
        nb_inplace_add("__iadd__"),
        nb_inplace_subtract("__isub__"),
        nb_inplace_multiply("__imul__"),
        nb_inplace_remainder("__imod__"),
        nb_inplace_lshift("__ilshift__"),
        nb_inplace_rshift("__irshift__"),
        nb_inplace_and("__iand__"),
        nb_inplace_xor("__ixor__"),
        nb_inplace_or("__ior__"),
        nb_inplace_floor_divide("__ifloordiv__"),
        nb_inplace_true_divide("__itruediv__"),
        nb_inplace_matrix_multiply("__imatmul__"),
        nb_inplace_power("__ipow__"),
        sq_length("__len__"),
        sq_item("__getitem__"),
        sq_ass_item("__setitem__"),
        sq_concat("__add__"),
        sq_repeat("__mul__"),
        sq_inplace_concat("__iadd__"),
        sq_inplace_repeat("__imul__"),
        sq_contains("__contains__"),
        mp_length("__len__"),
        mp_subscript("__getitem__"),
        mp_ass_subscript("__setitem__"),
        tp_richcompare("__lt__, __le__, __eq__, __ne__, __gt__, __ge__"),
        tp_descr_get("__get__"),
        tp_descr_set("__set__, __delete__"),
        tp_hash("__hash__"),
        tp_getattro("__getattribute__, __getattr__"),
        tp_setattro("__setattr__, __delattr__"),
        tp_iter("__iter__"),
        tp_iternext("__next__"),
        tp_str("__str__"),
        tp_repr("__repr__"),
        tp_init("__init__"),
        tp_new("__new__"),
        tp_call("__call__"),
        am_await("__await__"),
        am_aiter("__aiter__"),
        am_anext("__anext__");


        private SlotKind(String specialMethods) {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SlotSignature {
        public String name() default "";

        public int minNumOfPositionalArgs() default 0;

        public int maxNumOfPositionalArgs() default -1;

        public int numOfPositionalOnlyArgs() default -1;

        public boolean takesVarArgs() default false;

        public boolean takesVarKeywordArgs() default false;

        public String[] parameterNames() default {};

        public String[] keywordOnlyNames() default {};

        public boolean needsFrame() default false;

        public boolean alwaysNeedsCallerFrame() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Slots {
        public Slot[] value();
    }
}

