/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext;

import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ext.CoreXMLDeserializers;
import tools.jackson.databind.ext.DOMDeserializer;
import tools.jackson.databind.ext.DOMSerializer;
import tools.jackson.databind.ext.QNameSerializer;
import tools.jackson.databind.ext.XMLGregorianCalendarSerializer;
import tools.jackson.databind.ext.sql.JavaSqlTypeHandlerFactory;
import tools.jackson.databind.ser.std.ToStringSerializer;

public class OptionalHandlerFactory {
    private static final String PACKAGE_PREFIX_JAVAX_XML = "javax.xml.";
    private static final Class<?> CLASS_DOM_NODE = Node.class;
    private static final Class<?> CLASS_DOM_DOCUMENT = Document.class;
    public static final OptionalHandlerFactory instance = new OptionalHandlerFactory();

    protected OptionalHandlerFactory() {
    }

    public ValueSerializer<?> findSerializer(SerializationConfig config, JavaType type) {
        Class<?> rawType = type.getRawClass();
        if (this._IsXOfY(rawType, CLASS_DOM_NODE)) {
            return new DOMSerializer();
        }
        String className = rawType.getName();
        if (className.startsWith(PACKAGE_PREFIX_JAVAX_XML) || this.hasSuperClassStartingWith(rawType, PACKAGE_PREFIX_JAVAX_XML)) {
            if (Duration.class.isAssignableFrom(rawType)) {
                return ToStringSerializer.instance;
            }
            if (QName.class.isAssignableFrom(rawType)) {
                return QNameSerializer.instance;
            }
            if (XMLGregorianCalendar.class.isAssignableFrom(rawType)) {
                return XMLGregorianCalendarSerializer.instance;
            }
        }
        return JavaSqlTypeHandlerFactory.instance.findSerializer(config, type);
    }

    public ValueDeserializer<?> findDeserializer(DeserializationConfig config, JavaType type) {
        Class<?> rawType = type.getRawClass();
        if (this._IsXOfY(rawType, CLASS_DOM_NODE)) {
            return new DOMDeserializer.NodeDeserializer();
        }
        if (this._IsXOfY(rawType, CLASS_DOM_DOCUMENT)) {
            return new DOMDeserializer.DocumentDeserializer();
        }
        String className = rawType.getName();
        if (className.startsWith(PACKAGE_PREFIX_JAVAX_XML) || this.hasSuperClassStartingWith(rawType, PACKAGE_PREFIX_JAVAX_XML)) {
            return CoreXMLDeserializers.findBeanDeserializer(config, type);
        }
        return JavaSqlTypeHandlerFactory.instance.findDeserializer(config, type);
    }

    public boolean hasDeserializerFor(Class<?> valueType) {
        if (this._IsXOfY(valueType, CLASS_DOM_NODE)) {
            return true;
        }
        if (this._IsXOfY(valueType, CLASS_DOM_DOCUMENT)) {
            return true;
        }
        String className = valueType.getName();
        if (className.startsWith(PACKAGE_PREFIX_JAVAX_XML) || this.hasSuperClassStartingWith(valueType, PACKAGE_PREFIX_JAVAX_XML)) {
            return CoreXMLDeserializers.hasDeserializerFor(valueType);
        }
        return JavaSqlTypeHandlerFactory.instance.hasDeserializerFor(valueType);
    }

    private boolean _IsXOfY(Class<?> valueType, Class<?> expType) {
        return expType != null && expType.isAssignableFrom(valueType);
    }

    private boolean hasSuperClassStartingWith(Class<?> rawType, String prefix) {
        for (Class<?> supertype = rawType.getSuperclass(); supertype != null; supertype = supertype.getSuperclass()) {
            if (supertype == Object.class) {
                return false;
            }
            if (!supertype.getName().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

