/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.processor;

import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.semver4j.Range;
import org.semver4j.internal.Tokenizers;
import org.semver4j.processor.Processor;
import org.semver4j.processor.RangesUtils;

@NullMarked
public class XRangeProcessor
implements Processor {
    private static final Pattern pattern = Pattern.compile(Tokenizers.XRANGE);

    @Override
    public @Nullable String process(String range, boolean includePrerelease) {
        String[] rangeVersions = range.split("\\s+");
        ArrayList<String> objects = new ArrayList<String>();
        for (String rangeVersion : rangeVersions) {
            String to;
            String from;
            String prerelease;
            Matcher matcher = pattern.matcher(rangeVersion);
            String string = prerelease = includePrerelease ? "-0" : "";
            if (!matcher.matches()) continue;
            String fullRange = matcher.group(0);
            String compareSign = matcher.group(1);
            int major = RangesUtils.parseIntWithXSupport(matcher.group(2));
            int minor = RangesUtils.parseIntWithXSupport(matcher.group(3));
            int patch = RangesUtils.parseIntWithXSupport(matcher.group(4));
            if (compareSign.equals(Range.RangeOperator.EQ.asString()) && RangesUtils.isX(patch)) {
                compareSign = "";
            }
            if (!compareSign.isEmpty() && RangesUtils.isX(patch)) {
                patch = 0;
                if (compareSign.equals(Range.RangeOperator.GT.asString())) {
                    compareSign = Range.RangeOperator.GTE.asString();
                    if (RangesUtils.isX(minor)) {
                        ++major;
                        minor = 0;
                    } else {
                        ++minor;
                    }
                } else if (compareSign.equals(Range.RangeOperator.LTE.asString())) {
                    compareSign = Range.RangeOperator.LT.asString();
                    if (RangesUtils.isX(minor)) {
                        ++major;
                        minor = 0;
                    } else {
                        ++minor;
                    }
                } else if (RangesUtils.isX(minor)) {
                    minor = 0;
                }
                from = String.format(Locale.ROOT, "%s%d.%d.%d%s", compareSign, major, minor, patch, prerelease);
                objects.add(from);
                continue;
            }
            if (RangesUtils.isX(minor)) {
                from = String.format(Locale.ROOT, "%s%d.0.0%s", Range.RangeOperator.GTE.asString(), major, prerelease);
                to = String.format(Locale.ROOT, "%s%d.0.0%s", Range.RangeOperator.LT.asString(), major + 1, prerelease);
                objects.add(from);
                objects.add(to);
                continue;
            }
            if (RangesUtils.isX(patch)) {
                from = String.format(Locale.ROOT, "%s%d.%d.0%s", Range.RangeOperator.GTE.asString(), major, minor, prerelease);
                to = String.format(Locale.ROOT, "%s%d.%d.0%s", Range.RangeOperator.LT.asString(), major, minor + 1, prerelease);
                objects.add(from);
                objects.add(to);
                continue;
            }
            objects.add(fullRange);
        }
        if (objects.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)" ", objects);
    }
}

