/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.MultiChildLoadBalancer;
import io.grpc.xds.ClusterManagerLoadBalancerProvider;
import io.grpc.xds.XdsNameResolver;
import io.grpc.xds.client.XdsLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class ClusterManagerLoadBalancer
extends MultiChildLoadBalancer {
    @VisibleForTesting
    public static final int DELAYED_CHILD_DELETION_TIME_MINUTES = 15;
    protected final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private final XdsLogger logger;
    private LoadBalancer.ResolvedAddresses lastResolvedAddresses;

    ClusterManagerLoadBalancer(LoadBalancer.Helper helper) {
        super(helper);
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)helper.getSynchronizationContext(), (Object)"syncContext");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)helper.getScheduledExecutorService(), (Object)"timeService");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"cluster_manager-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created", new Object[0]);
    }

    protected LoadBalancer.ResolvedAddresses getChildAddresses(Object key, LoadBalancer.ResolvedAddresses resolvedAddresses, Object childConfig) {
        return resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(childConfig).build();
    }

    protected Map<Object, MultiChildLoadBalancer.ChildLbState> createChildLbMap(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        ClusterManagerLoadBalancerProvider.ClusterManagerConfig config = (ClusterManagerLoadBalancerProvider.ClusterManagerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        HashMap<Object, MultiChildLoadBalancer.ChildLbState> newChildPolicies = new HashMap<Object, MultiChildLoadBalancer.ChildLbState>();
        if (config != null) {
            for (Map.Entry<String, ServiceConfigUtil.PolicySelection> entry : config.childPolicies.entrySet()) {
                MultiChildLoadBalancer.ChildLbState child = this.getChildLbState(entry.getKey());
                if (child == null) {
                    child = new ClusterManagerLbState(entry.getKey(), entry.getValue().getProvider(), entry.getValue().getConfig(), this.getInitialPicker());
                }
                newChildPolicies.put(entry.getKey(), child);
            }
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received cluster_manager lb config: child names={0}", newChildPolicies.keySet());
        return newChildPolicies;
    }

    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        if (this.lastResolvedAddresses != null) {
            ClusterManagerLoadBalancerProvider.ClusterManagerConfig config = (ClusterManagerLoadBalancerProvider.ClusterManagerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
            ClusterManagerLoadBalancerProvider.ClusterManagerConfig lastConfig = (ClusterManagerLoadBalancerProvider.ClusterManagerConfig)this.lastResolvedAddresses.getLoadBalancingPolicyConfig();
            HashMap<String, ServiceConfigUtil.PolicySelection> adjChildPolicies = new HashMap<String, ServiceConfigUtil.PolicySelection>(config.childPolicies);
            for (Map.Entry<String, ServiceConfigUtil.PolicySelection> entry : lastConfig.childPolicies.entrySet()) {
                ClusterManagerLbState state = (ClusterManagerLbState)this.getChildLbState(entry.getKey());
                if (adjChildPolicies.containsKey(entry.getKey())) {
                    if (state.deletionTimer == null) continue;
                    state.reactivateChild();
                    continue;
                }
                if (state == null) continue;
                adjChildPolicies.put(entry.getKey(), entry.getValue());
                if (state.deletionTimer != null) continue;
                state.deactivateChild();
            }
            config = new ClusterManagerLoadBalancerProvider.ClusterManagerConfig(adjChildPolicies);
            resolvedAddresses = resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig((Object)config).build();
        }
        this.lastResolvedAddresses = resolvedAddresses;
        return super.acceptResolvedAddresses(resolvedAddresses);
    }

    protected void updateOverallBalancingState() {
        ConnectivityState overallState = null;
        HashMap<Object, LoadBalancer.SubchannelPicker> childPickers = new HashMap<Object, LoadBalancer.SubchannelPicker>();
        for (MultiChildLoadBalancer.ChildLbState childLbState : this.getChildLbStates()) {
            if (((ClusterManagerLbState)childLbState).deletionTimer != null) continue;
            childPickers.put(childLbState.getKey(), childLbState.getCurrentPicker());
            overallState = ClusterManagerLoadBalancer.aggregateState(overallState, (ConnectivityState)childLbState.getCurrentState());
        }
        if (overallState != null) {
            this.getHelper().updateBalancingState(overallState, this.getSubchannelPicker(childPickers));
            this.currentConnectivityState = overallState;
        }
    }

    protected LoadBalancer.SubchannelPicker getSubchannelPicker(final Map<Object, LoadBalancer.SubchannelPicker> childPickers) {
        return new LoadBalancer.SubchannelPicker(){

            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                String clusterName = (String)args.getCallOptions().getOption(XdsNameResolver.CLUSTER_SELECTION_KEY);
                LoadBalancer.SubchannelPicker childPicker = (LoadBalancer.SubchannelPicker)childPickers.get(clusterName);
                if (childPicker == null) {
                    return LoadBalancer.PickResult.withError((Status)Status.UNAVAILABLE.withDescription("CDS encountered error: unable to find available subchannel for cluster " + clusterName));
                }
                return childPicker.pickSubchannel(args);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)((Object)this)).add("pickers", (Object)childPickers).toString();
            }
        };
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        boolean gotoTransientFailure = true;
        for (MultiChildLoadBalancer.ChildLbState state : this.getChildLbStates()) {
            if (((ClusterManagerLbState)state).deletionTimer != null) continue;
            gotoTransientFailure = false;
            this.handleNameResolutionError(state, error);
        }
        if (gotoTransientFailure) {
            this.getHelper().updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, this.getErrorPicker(error));
        }
    }

    private class ClusterManagerLbState
    extends MultiChildLoadBalancer.ChildLbState {
        @Nullable
        SynchronizationContext.ScheduledHandle deletionTimer;

        public ClusterManagerLbState(Object key, LoadBalancerProvider policyProvider, Object childConfig, LoadBalancer.SubchannelPicker initialPicker) {
            super((MultiChildLoadBalancer)ClusterManagerLoadBalancer.this, key, (LoadBalancer.Factory)policyProvider, childConfig, initialPicker);
        }

        protected MultiChildLoadBalancer.ChildLbState.ChildLbStateHelper createChildHelper() {
            return new ClusterManagerChildHelper();
        }

        protected void shutdown() {
            if (this.deletionTimer != null) {
                this.deletionTimer.cancel();
                this.deletionTimer = null;
            }
            super.shutdown();
        }

        void reactivateChild() {
            assert (this.deletionTimer != null);
            this.deletionTimer.cancel();
            this.deletionTimer = null;
            ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} reactivated", this.getKey());
        }

        void deactivateChild() {
            assert (this.deletionTimer == null);
            class DeletionTask
            implements Runnable {
                DeletionTask() {
                }

                @Override
                public void run() {
                    ClusterManagerLoadBalancerProvider.ClusterManagerConfig config = (ClusterManagerLoadBalancerProvider.ClusterManagerConfig)ClusterManagerLoadBalancer.this.lastResolvedAddresses.getLoadBalancingPolicyConfig();
                    HashMap<String, ServiceConfigUtil.PolicySelection> childPolicies = new HashMap<String, ServiceConfigUtil.PolicySelection>(config.childPolicies);
                    ServiceConfigUtil.PolicySelection removed = (ServiceConfigUtil.PolicySelection)childPolicies.remove(ClusterManagerLbState.this.getKey());
                    assert (removed != null);
                    config = new ClusterManagerLoadBalancerProvider.ClusterManagerConfig(childPolicies);
                    ClusterManagerLoadBalancer.this.lastResolvedAddresses = ClusterManagerLoadBalancer.this.lastResolvedAddresses.toBuilder().setLoadBalancingPolicyConfig((Object)config).build();
                    ClusterManagerLoadBalancer.this.acceptResolvedAddresses(ClusterManagerLoadBalancer.this.lastResolvedAddresses);
                }
            }
            this.deletionTimer = ClusterManagerLoadBalancer.this.syncContext.schedule((Runnable)new DeletionTask(), 15L, TimeUnit.MINUTES, ClusterManagerLoadBalancer.this.timeService);
            ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} deactivated", this.getKey());
        }

        private class ClusterManagerChildHelper
        extends MultiChildLoadBalancer.ChildLbState.ChildLbStateHelper {
            private ClusterManagerChildHelper() {
                super((MultiChildLoadBalancer.ChildLbState)ClusterManagerLbState.this);
            }

            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                if (ClusterManagerLoadBalancer.this.getChildLbState(ClusterManagerLbState.this.getKey()) == null) {
                    return;
                }
                ClusterManagerLbState.this.setCurrentState(newState);
                ClusterManagerLbState.this.setCurrentPicker(newPicker);
                if (ClusterManagerLbState.this.deletionTimer == null && !ClusterManagerLoadBalancer.this.resolvingAddresses) {
                    ClusterManagerLoadBalancer.this.updateOverallBalancingState();
                }
            }
        }
    }
}

