/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

public strictfp final class S1Interval
implements Cloneable {
    private final double lo;
    private final double hi;

    public S1Interval(double lo, double hi) {
        this(lo, hi, false);
    }

    public S1Interval(S1Interval interval) {
        this.lo = interval.lo;
        this.hi = interval.hi;
    }

    private S1Interval(double lo, double hi, boolean checked) {
        double newLo = lo;
        double newHi = hi;
        if (!checked) {
            if (lo == -Math.PI && hi != Math.PI) {
                newLo = Math.PI;
            }
            if (hi == -Math.PI && lo != Math.PI) {
                newHi = Math.PI;
            }
        }
        this.lo = newLo;
        this.hi = newHi;
    }

    public static S1Interval empty() {
        return new S1Interval(Math.PI, -Math.PI, true);
    }

    public static S1Interval full() {
        return new S1Interval(-Math.PI, Math.PI, true);
    }

    public static S1Interval fromPoint(double p) {
        if (p == -Math.PI) {
            p = Math.PI;
        }
        return new S1Interval(p, p, true);
    }

    public static S1Interval fromPointPair(double p1, double p2) {
        if (p1 == -Math.PI) {
            p1 = Math.PI;
        }
        if (p2 == -Math.PI) {
            p2 = Math.PI;
        }
        if (S1Interval.positiveDistance(p1, p2) <= Math.PI) {
            return new S1Interval(p1, p2, true);
        }
        return new S1Interval(p2, p1, true);
    }

    public double lo() {
        return this.lo;
    }

    public double hi() {
        return this.hi;
    }

    public boolean isValid() {
        return Math.abs(this.lo()) <= Math.PI && Math.abs(this.hi()) <= Math.PI && (this.lo() != -Math.PI || this.hi() == Math.PI) && (this.hi() != -Math.PI || this.lo() == Math.PI);
    }

    public boolean isFull() {
        return this.hi() - this.lo() == Math.PI * 2;
    }

    public boolean isEmpty() {
        return this.lo() - this.hi() == Math.PI * 2;
    }

    public boolean isInverted() {
        return this.lo() > this.hi();
    }

    public double getCenter() {
        double center = 0.5 * (this.lo() + this.hi());
        if (!this.isInverted()) {
            return center;
        }
        return center <= 0.0 ? center + Math.PI : center - Math.PI;
    }

    public double getLength() {
        double length = this.hi() - this.lo();
        if (length >= 0.0) {
            return length;
        }
        return (length += Math.PI * 2) > 0.0 ? length : -1.0;
    }

    public S1Interval complement() {
        if (this.lo() == this.hi()) {
            return S1Interval.full();
        }
        return new S1Interval(this.hi(), this.lo(), true);
    }

    public boolean contains(double p) {
        if (p == -Math.PI) {
            p = Math.PI;
        }
        return this.fastContains(p);
    }

    public boolean fastContains(double p) {
        if (this.isInverted()) {
            return (p >= this.lo() || p <= this.hi()) && !this.isEmpty();
        }
        return p >= this.lo() && p <= this.hi();
    }

    public boolean interiorContains(double p) {
        if (p == -Math.PI) {
            p = Math.PI;
        }
        if (this.isInverted()) {
            return p > this.lo() || p < this.hi();
        }
        return p > this.lo() && p < this.hi() || this.isFull();
    }

    public boolean contains(S1Interval y) {
        if (this.isInverted()) {
            if (y.isInverted()) {
                return y.lo() >= this.lo() && y.hi() <= this.hi();
            }
            return (y.lo() >= this.lo() || y.hi() <= this.hi()) && !this.isEmpty();
        }
        if (y.isInverted()) {
            return this.isFull() || y.isEmpty();
        }
        return y.lo() >= this.lo() && y.hi() <= this.hi();
    }

    public boolean interiorContains(S1Interval y) {
        if (this.isInverted()) {
            if (!y.isInverted()) {
                return y.lo() > this.lo() || y.hi() < this.hi();
            }
            return y.lo() > this.lo() && y.hi() < this.hi() || y.isEmpty();
        }
        if (y.isInverted()) {
            return this.isFull() || y.isEmpty();
        }
        return y.lo() > this.lo() && y.hi() < this.hi() || this.isFull();
    }

    public boolean intersects(S1Interval y) {
        if (this.isEmpty() || y.isEmpty()) {
            return false;
        }
        if (this.isInverted()) {
            return y.isInverted() || y.lo() <= this.hi() || y.hi() >= this.lo();
        }
        if (y.isInverted()) {
            return y.lo() <= this.hi() || y.hi() >= this.lo();
        }
        return y.lo() <= this.hi() && y.hi() >= this.lo();
    }

    public boolean interiorIntersects(S1Interval y) {
        if (this.isEmpty() || y.isEmpty() || this.lo() == this.hi()) {
            return false;
        }
        if (this.isInverted()) {
            return y.isInverted() || y.lo() < this.hi() || y.hi() > this.lo();
        }
        if (y.isInverted()) {
            return y.lo() < this.hi() || y.hi() > this.lo();
        }
        return y.lo() < this.hi() && y.hi() > this.lo() || this.isFull();
    }

    public S1Interval addPoint(double p) {
        double dhi;
        if (p == -Math.PI) {
            p = Math.PI;
        }
        if (this.fastContains(p)) {
            return new S1Interval(this);
        }
        if (this.isEmpty()) {
            return S1Interval.fromPoint(p);
        }
        double dlo = S1Interval.positiveDistance(p, this.lo());
        if (dlo < (dhi = S1Interval.positiveDistance(this.hi(), p))) {
            return new S1Interval(p, this.hi());
        }
        return new S1Interval(this.lo(), p);
    }

    public S1Interval expanded(double radius) {
        if (this.isEmpty()) {
            return this;
        }
        if (this.getLength() + 2.0 * radius >= 6.283185307179585) {
            return S1Interval.full();
        }
        double low = Math.IEEEremainder(this.lo() - radius, Math.PI * 2);
        double high = Math.IEEEremainder(this.hi() + radius, Math.PI * 2);
        if (low == -Math.PI) {
            low = Math.PI;
        }
        return new S1Interval(low, high);
    }

    public S1Interval union(S1Interval y) {
        double dhi;
        if (y.isEmpty()) {
            return this;
        }
        if (this.fastContains(y.lo())) {
            if (this.fastContains(y.hi())) {
                if (this.contains(y)) {
                    return this;
                }
                return S1Interval.full();
            }
            return new S1Interval(this.lo(), y.hi(), true);
        }
        if (this.fastContains(y.hi())) {
            return new S1Interval(y.lo(), this.hi(), true);
        }
        if (this.isEmpty() || y.fastContains(this.lo())) {
            return y;
        }
        double dlo = S1Interval.positiveDistance(y.hi(), this.lo());
        if (dlo < (dhi = S1Interval.positiveDistance(this.hi(), y.lo()))) {
            return new S1Interval(y.lo(), this.hi(), true);
        }
        return new S1Interval(this.lo(), y.hi(), true);
    }

    public S1Interval intersection(S1Interval y) {
        if (y.isEmpty()) {
            return S1Interval.empty();
        }
        if (this.fastContains(y.lo())) {
            if (this.fastContains(y.hi())) {
                if (y.getLength() < this.getLength()) {
                    return y;
                }
                return this;
            }
            return new S1Interval(y.lo(), this.hi(), true);
        }
        if (this.fastContains(y.hi())) {
            return new S1Interval(this.lo(), y.hi(), true);
        }
        if (y.fastContains(this.lo())) {
            return this;
        }
        return S1Interval.empty();
    }

    public boolean approxEquals(S1Interval y, double maxError) {
        if (this.isEmpty()) {
            return y.getLength() <= maxError;
        }
        if (y.isEmpty()) {
            return this.getLength() <= maxError;
        }
        return Math.abs(Math.IEEEremainder(y.lo() - this.lo(), Math.PI * 2)) + Math.abs(Math.IEEEremainder(y.hi() - this.hi(), Math.PI * 2)) <= maxError;
    }

    public boolean approxEquals(S1Interval y) {
        return this.approxEquals(y, 1.0E-9);
    }

    public boolean equals(Object that) {
        if (that instanceof S1Interval) {
            S1Interval thatInterval = (S1Interval)that;
            return this.lo() == thatInterval.lo() && this.hi() == thatInterval.hi();
        }
        return false;
    }

    public int hashCode() {
        long value = 17L;
        value = 37L * value + Double.doubleToLongBits(this.lo());
        value = 37L * value + Double.doubleToLongBits(this.hi());
        return (int)(value >>> 32 ^ value);
    }

    public String toString() {
        return "[" + this.lo() + ", " + this.hi() + "]";
    }

    public static double positiveDistance(double a, double b) {
        double d = b - a;
        if (d >= 0.0) {
            return d;
        }
        return b + Math.PI - (a - Math.PI);
    }
}

