/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform1D;
import org.apache.sis.referencing.operation.transform.ConstantTransform1D;
import org.apache.sis.referencing.operation.transform.IdentityTransform1D;
import org.apache.sis.util.ComparisonMode;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

final class PowerTransform1D
extends AbstractMathTransform1D
implements Serializable {
    private static final long serialVersionUID = 4618931749313510016L;
    final double power;
    private PowerTransform1D inverse;

    protected PowerTransform1D(double d) {
        this.power = d;
    }

    public static MathTransform1D create(double d) {
        if (d == 1.0) {
            return IdentityTransform1D.INSTANCE;
        }
        if (d == 0.0) {
            return ConstantTransform1D.ONE;
        }
        return new PowerTransform1D(d);
    }

    @Override
    public MathTransform1D inverse() {
        if (this.inverse == null) {
            this.inverse = new PowerTransform1D(1.0 / this.power);
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    @Override
    public double derivative(double d) {
        return this.power * Math.pow(d, this.power - 1.0);
    }

    @Override
    public double transform(double d) {
        return Math.pow(d, this.power);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray != dArray2 || n >= n2) {
            while (--n3 >= 0) {
                dArray2[n2++] = Math.pow(dArray[n++], this.power);
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                dArray2[--n2] = Math.pow(dArray[--n], this.power);
            }
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray != fArray2 || n >= n2) {
            while (--n3 >= 0) {
                fArray2[n2++] = (float)Math.pow(fArray[n++], this.power);
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                fArray2[--n2] = (float)Math.pow(fArray[--n], this.power);
            }
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        while (--n3 >= 0) {
            fArray[n2++] = (float)Math.pow(dArray[n++], this.power);
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        while (--n3 >= 0) {
            dArray[n2++] = Math.pow(fArray[n++], this.power);
        }
    }

    @Override
    protected MathTransform tryConcatenate(boolean bl, MathTransform mathTransform, MathTransformFactory mathTransformFactory) throws FactoryException {
        if (mathTransform instanceof PowerTransform1D) {
            return PowerTransform1D.create(this.power + ((PowerTransform1D)mathTransform).power);
        }
        return super.tryConcatenate(bl, mathTransform, mathTransformFactory);
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() + Double.hashCode(this.power);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            return Numerics.equals(this.power, ((PowerTransform1D)object).power);
        }
        return false;
    }
}

