/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.noding.BasicSegmentString;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;

public class BoundaryChainNoder
implements Noder {
    private List<SegmentString> chainList;

    @Override
    public void computeNodes(Collection segStrings) {
        HashSet<Segment> segSet = new HashSet<Segment>();
        BoundaryChainMap[] boundaryChains = new BoundaryChainMap[segStrings.size()];
        BoundaryChainNoder.addSegments(segStrings, segSet, boundaryChains);
        BoundaryChainNoder.markBoundarySegments(segSet);
        this.chainList = BoundaryChainNoder.extractChains(boundaryChains);
    }

    private static void addSegments(Collection<SegmentString> segStrings, HashSet<Segment> segSet, BoundaryChainMap[] boundaryChains) {
        int i = 0;
        for (SegmentString ss : segStrings) {
            BoundaryChainMap chainMap = new BoundaryChainMap(ss);
            boundaryChains[i++] = chainMap;
            BoundaryChainNoder.addSegments(ss, chainMap, segSet);
        }
    }

    private static void addSegments(SegmentString segString, BoundaryChainMap chainMap, HashSet<Segment> segSet) {
        for (int i = 0; i < segString.size() - 1; ++i) {
            Coordinate p1;
            Coordinate p0 = segString.getCoordinate(i);
            Segment seg = new Segment(p0, p1 = segString.getCoordinate(i + 1), chainMap, i);
            if (segSet.contains(seg)) {
                segSet.remove(seg);
                continue;
            }
            segSet.add(seg);
        }
    }

    private static void markBoundarySegments(HashSet<Segment> segSet) {
        for (Segment seg : segSet) {
            seg.markBoundary();
        }
    }

    private static List<SegmentString> extractChains(BoundaryChainMap[] boundaryChains) {
        ArrayList<SegmentString> chainList = new ArrayList<SegmentString>();
        for (BoundaryChainMap chainMap : boundaryChains) {
            chainMap.createChains(chainList);
        }
        return chainList;
    }

    @Override
    public Collection getNodedSubstrings() {
        return this.chainList;
    }

    private static class Segment
    extends LineSegment {
        private BoundaryChainMap segMap;
        private int index;

        public Segment(Coordinate p0, Coordinate p1, BoundaryChainMap segMap, int index) {
            super(p0, p1);
            this.segMap = segMap;
            this.index = index;
            this.normalize();
        }

        public void markBoundary() {
            this.segMap.setBoundarySegment(this.index);
        }
    }

    private static class BoundaryChainMap {
        private SegmentString segString;
        private boolean[] isBoundary;

        public BoundaryChainMap(SegmentString ss) {
            this.segString = ss;
            this.isBoundary = new boolean[ss.size() - 1];
        }

        public void setBoundarySegment(int index) {
            this.isBoundary[index] = true;
        }

        public void createChains(List<SegmentString> chainList) {
            int startIndex;
            int endIndex = 0;
            while ((startIndex = this.findChainStart(endIndex)) < this.segString.size() - 1) {
                endIndex = this.findChainEnd(startIndex);
                SegmentString ss = BoundaryChainMap.createChain(this.segString, startIndex, endIndex);
                chainList.add(ss);
            }
        }

        private static SegmentString createChain(SegmentString segString, int startIndex, int endIndex) {
            Coordinate[] pts = new Coordinate[endIndex - startIndex + 1];
            int ipts = 0;
            for (int i = startIndex; i < endIndex + 1; ++i) {
                pts[ipts++] = segString.getCoordinate(i).copy();
            }
            return new BasicSegmentString(pts, segString.getData());
        }

        private int findChainStart(int index) {
            while (index < this.isBoundary.length && !this.isBoundary[index]) {
                ++index;
            }
            return index;
        }

        private int findChainEnd(int index) {
            ++index;
            while (index < this.isBoundary.length && this.isBoundary[index]) {
                ++index;
            }
            return index;
        }
    }
}

