/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.coyote.http11.upgrade.UpgradeInfo;
import org.apache.tomcat.util.modeler.BaseModelMBean;

public class UpgradeGroupInfo
extends BaseModelMBean {
    private final Set<UpgradeInfo> upgradeInfos = new ConcurrentHashMap().keySet(Boolean.TRUE);
    private final LongAdder deadBytesReceived = new LongAdder();
    private final LongAdder deadBytesSent = new LongAdder();
    private final LongAdder deadMsgsReceived = new LongAdder();
    private final LongAdder deadMsgsSent = new LongAdder();

    public void addUpgradeInfo(UpgradeInfo upgradeInfo) {
        this.upgradeInfos.add(upgradeInfo);
    }

    public void removeUpgradeInfo(UpgradeInfo upgradeInfo) {
        if (upgradeInfo != null) {
            this.deadBytesReceived.add(upgradeInfo.getBytesReceived());
            this.deadBytesSent.add(upgradeInfo.getBytesSent());
            this.deadMsgsReceived.add(upgradeInfo.getMsgsReceived());
            this.deadMsgsSent.add(upgradeInfo.getMsgsSent());
            this.upgradeInfos.remove(upgradeInfo);
        }
    }

    public long getBytesReceived() {
        long l = this.deadBytesReceived.longValue();
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            l += upgradeInfo.getBytesReceived();
        }
        return l;
    }

    public void setBytesReceived(long l) {
        this.deadBytesReceived.reset();
        if (l != 0L) {
            this.deadBytesReceived.add(l);
        }
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            upgradeInfo.setBytesReceived(l);
        }
    }

    public long getBytesSent() {
        long l = this.deadBytesSent.longValue();
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            l += upgradeInfo.getBytesSent();
        }
        return l;
    }

    public void setBytesSent(long l) {
        this.deadBytesSent.reset();
        if (l != 0L) {
            this.deadBytesSent.add(l);
        }
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            upgradeInfo.setBytesSent(l);
        }
    }

    public long getMsgsReceived() {
        long l = this.deadMsgsReceived.longValue();
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            l += upgradeInfo.getMsgsReceived();
        }
        return l;
    }

    public void setMsgsReceived(long l) {
        this.deadMsgsReceived.reset();
        if (l != 0L) {
            this.deadMsgsReceived.add(l);
        }
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            upgradeInfo.setMsgsReceived(l);
        }
    }

    public long getMsgsSent() {
        long l = this.deadMsgsSent.longValue();
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            l += upgradeInfo.getMsgsSent();
        }
        return l;
    }

    public void setMsgsSent(long l) {
        this.deadMsgsSent.reset();
        if (l != 0L) {
            this.deadMsgsSent.add(l);
        }
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            upgradeInfo.setMsgsSent(l);
        }
    }

    public void resetCounters() {
        this.setBytesReceived(0L);
        this.setBytesSent(0L);
        this.setMsgsReceived(0L);
        this.setMsgsSent(0L);
    }
}

