/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.tribes.ByteMessage;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.ChannelReceiver;
import org.apache.catalina.tribes.ChannelSender;
import org.apache.catalina.tribes.ErrorHandler;
import org.apache.catalina.tribes.Heartbeat;
import org.apache.catalina.tribes.JmxChannel;
import org.apache.catalina.tribes.ManagedChannel;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.MembershipService;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.group.ChannelCoordinator;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.GroupChannelMBean;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.group.RpcChannel;
import org.apache.catalina.tribes.group.RpcMessage;
import org.apache.catalina.tribes.group.interceptors.MessageDispatchInterceptor;
import org.apache.catalina.tribes.io.BufferPool;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.jmx.JmxRegistry;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.catalina.tribes.util.Logs;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class GroupChannel
extends ChannelInterceptorBase
implements ManagedChannel,
JmxChannel,
GroupChannelMBean {
    private static final Log log = LogFactory.getLog(GroupChannel.class);
    protected static final StringManager sm = StringManager.getManager(GroupChannel.class);
    protected boolean heartbeat = true;
    protected long heartbeatSleeptime = 5000L;
    protected ScheduledFuture<?> heartbeatFuture = null;
    protected ScheduledFuture<?> monitorFuture;
    protected final ChannelCoordinator coordinator = new ChannelCoordinator();
    protected ChannelInterceptor interceptors = null;
    protected final List<MembershipListener> membershipListeners = new CopyOnWriteArrayList<MembershipListener>();
    protected final List<ChannelListener> channelListeners = new CopyOnWriteArrayList<ChannelListener>();
    protected boolean optionCheck = false;
    protected String name = null;
    private String jmxDomain = "ClusterChannel";
    private String jmxPrefix = "";
    private boolean jmxEnabled = true;
    protected ScheduledExecutorService utilityExecutor = null;
    private ObjectName oname = null;
    protected boolean ownExecutor = false;

    public GroupChannel() {
        this.addInterceptor(this);
    }

    @Override
    public void addInterceptor(ChannelInterceptor channelInterceptor) {
        if (this.interceptors == null) {
            this.interceptors = channelInterceptor;
            this.interceptors.setNext(this.coordinator);
            this.interceptors.setPrevious(null);
            this.coordinator.setPrevious(this.interceptors);
        } else {
            ChannelInterceptor channelInterceptor2 = this.interceptors;
            while (channelInterceptor2.getNext() != this.coordinator) {
                channelInterceptor2 = channelInterceptor2.getNext();
            }
            channelInterceptor2.setNext(channelInterceptor);
            channelInterceptor.setNext(this.coordinator);
            channelInterceptor.setPrevious(channelInterceptor2);
            this.coordinator.setPrevious(channelInterceptor);
        }
    }

    @Override
    public void heartbeat() {
        super.heartbeat();
        for (MembershipListener object : this.membershipListeners) {
            if (!(object instanceof Heartbeat)) continue;
            ((Heartbeat)((Object)object)).heartbeat();
        }
        for (ChannelListener channelListener : this.channelListeners) {
            if (!(channelListener instanceof Heartbeat)) continue;
            ((Heartbeat)((Object)channelListener)).heartbeat();
        }
    }

    @Override
    public UniqueId send(Member[] memberArray, Serializable serializable, int n) throws ChannelException {
        return this.send(memberArray, serializable, n, null);
    }

    @Override
    public UniqueId send(Member[] memberArray, Serializable serializable, int n, ErrorHandler errorHandler) throws ChannelException {
        UniqueId uniqueId;
        block11: {
            if (serializable == null) {
                throw new ChannelException(sm.getString("groupChannel.nullMessage"));
            }
            XByteBuffer xByteBuffer = null;
            try {
                byte[] byArray;
                if (memberArray == null || memberArray.length == 0) {
                    throw new ChannelException(sm.getString("groupChannel.noDestination"));
                }
                ChannelData channelData = new ChannelData(true);
                channelData.setAddress(this.getLocalMember(false));
                channelData.setTimestamp(System.currentTimeMillis());
                if (serializable instanceof ByteMessage) {
                    byArray = ((ByteMessage)serializable).getMessage();
                    n |= 1;
                } else {
                    byArray = XByteBuffer.serialize(serializable);
                    n &= 0xFFFFFFFE;
                }
                channelData.setOptions(n);
                xByteBuffer = BufferPool.getBufferPool().getBuffer(byArray.length + 128, false);
                xByteBuffer.append(byArray, 0, byArray.length);
                channelData.setMessage(xByteBuffer);
                InterceptorPayload interceptorPayload = null;
                if (errorHandler != null) {
                    interceptorPayload = new InterceptorPayload();
                    interceptorPayload.setErrorHandler(errorHandler);
                }
                this.getFirstInterceptor().sendMessage(memberArray, channelData, interceptorPayload);
                if (Logs.MESSAGES.isTraceEnabled()) {
                    Logs.MESSAGES.trace((Object)("GroupChannel - Sent msg:" + new UniqueId(channelData.getUniqueId()) + " at " + new Timestamp(System.currentTimeMillis()) + " to " + Arrays.toNameString(memberArray)));
                    Logs.MESSAGES.trace((Object)("GroupChannel - Send Message:" + new UniqueId(channelData.getUniqueId()) + " is " + serializable));
                }
                uniqueId = new UniqueId(channelData.getUniqueId());
                if (xByteBuffer == null) break block11;
            }
            catch (IOException | RuntimeException exception) {
                try {
                    throw new ChannelException(exception);
                }
                catch (Throwable throwable) {
                    if (xByteBuffer != null) {
                        BufferPool.getBufferPool().returnBuffer(xByteBuffer);
                    }
                    throw throwable;
                }
            }
            BufferPool.getBufferPool().returnBuffer(xByteBuffer);
        }
        return uniqueId;
    }

    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        if (channelMessage == null) {
            return;
        }
        try {
            Serializable serializable;
            if (Logs.MESSAGES.isTraceEnabled()) {
                Logs.MESSAGES.trace((Object)("GroupChannel - Received msg:" + new UniqueId(channelMessage.getUniqueId()) + " at " + new Timestamp(System.currentTimeMillis()) + " from " + channelMessage.getAddress().getName()));
            }
            if ((channelMessage.getOptions() & 1) == 1) {
                serializable = new ByteMessage(channelMessage.getMessage().getBytes());
            } else {
                try {
                    serializable = XByteBuffer.deserialize(channelMessage.getMessage().getBytesDirect(), 0, channelMessage.getMessage().getLength());
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("groupChannel.unable.deserialize", channelMessage), (Throwable)exception);
                    return;
                }
            }
            if (Logs.MESSAGES.isTraceEnabled()) {
                Logs.MESSAGES.trace((Object)("GroupChannel - Receive Message:" + new UniqueId(channelMessage.getUniqueId()) + " is " + serializable));
            }
            Member member = channelMessage.getAddress();
            boolean bl = false;
            boolean bl2 = false;
            for (ChannelListener channelListener : this.channelListeners) {
                if (channelListener == null || !channelListener.accept(serializable, member)) continue;
                channelListener.messageReceived(serializable, member);
                bl2 = true;
                if (!(channelListener instanceof RpcChannel)) continue;
                bl = true;
            }
            if (!bl && serializable instanceof RpcMessage) {
                this.sendNoRpcChannelReply((RpcMessage)serializable, member);
            }
            if (Logs.MESSAGES.isTraceEnabled()) {
                Logs.MESSAGES.trace((Object)("GroupChannel delivered[" + bl2 + "] id:" + new UniqueId(channelMessage.getUniqueId())));
            }
        }
        catch (Exception exception) {
            if (log.isWarnEnabled()) {
                log.warn((Object)sm.getString("groupChannel.receiving.error"), (Throwable)exception);
            }
            throw new RemoteProcessException(sm.getString("groupChannel.receiving.error"), exception);
        }
    }

    protected void sendNoRpcChannelReply(RpcMessage rpcMessage, Member member) {
        try {
            if (rpcMessage instanceof RpcMessage.NoRpcChannelReply) {
                return;
            }
            RpcMessage.NoRpcChannelReply noRpcChannelReply = new RpcMessage.NoRpcChannelReply(rpcMessage.rpcId, rpcMessage.uuid);
            this.send(new Member[]{member}, noRpcChannelReply, 8);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("groupChannel.sendFail.noRpcChannelReply"), (Throwable)exception);
        }
    }

    @Override
    public void memberAdded(Member member) {
        for (MembershipListener membershipListener : this.membershipListeners) {
            if (membershipListener == null) continue;
            membershipListener.memberAdded(member);
        }
    }

    @Override
    public void memberDisappeared(Member member) {
        for (MembershipListener membershipListener : this.membershipListeners) {
            if (membershipListener == null) continue;
            membershipListener.memberDisappeared(member);
        }
    }

    protected synchronized void setupDefaultStack() throws ChannelException {
        if (this.getFirstInterceptor() != null && this.getFirstInterceptor().getNext() instanceof ChannelCoordinator) {
            this.addInterceptor(new MessageDispatchInterceptor());
        }
        Iterator<ChannelInterceptor> iterator = this.getInterceptors();
        while (iterator.hasNext()) {
            ChannelInterceptor channelInterceptor = iterator.next();
            channelInterceptor.setChannel(this);
        }
        this.coordinator.setChannel(this);
    }

    protected void checkOptionFlags() throws ChannelException {
        StringBuilder stringBuilder = new StringBuilder();
        for (ChannelInterceptor channelInterceptor = this.interceptors; channelInterceptor != null; channelInterceptor = channelInterceptor.getNext()) {
            int n = channelInterceptor.getOptionFlag();
            if (n == 0) continue;
            for (ChannelInterceptor channelInterceptor2 = channelInterceptor.getNext(); channelInterceptor2 != null; channelInterceptor2 = channelInterceptor2.getNext()) {
                int n2 = channelInterceptor2.getOptionFlag();
                if (n2 == 0 || (n & n2) != n && (n & n2) != n2) continue;
                stringBuilder.append('[');
                stringBuilder.append(channelInterceptor.getClass().getName());
                stringBuilder.append(':');
                stringBuilder.append(n);
                stringBuilder.append(" == ");
                stringBuilder.append(channelInterceptor2.getClass().getName());
                stringBuilder.append(':');
                stringBuilder.append(n2);
                stringBuilder.append("] ");
            }
        }
        if (stringBuilder.length() > 0) {
            throw new ChannelException(sm.getString("groupChannel.optionFlag.conflict", stringBuilder.toString()));
        }
    }

    @Override
    public synchronized void start(int n) throws ChannelException {
        JmxRegistry jmxRegistry;
        this.setupDefaultStack();
        if (this.optionCheck) {
            this.checkOptionFlags();
        }
        if ((jmxRegistry = JmxRegistry.getRegistry(this)) != null) {
            this.oname = jmxRegistry.registerJmx(",component=Channel", this);
        }
        if (this.utilityExecutor == null) {
            log.warn((Object)sm.getString("groupChannel.warn.noUtilityExecutor"));
            this.utilityExecutor = new ScheduledThreadPoolExecutor(1);
            this.ownExecutor = true;
        }
        super.start(n);
        this.monitorFuture = this.utilityExecutor.scheduleWithFixedDelay(this::startHeartbeat, 0L, 60L, TimeUnit.SECONDS);
    }

    protected void startHeartbeat() {
        if (this.heartbeat && (this.heartbeatFuture == null || this.heartbeatFuture.isDone())) {
            if (this.heartbeatFuture != null && this.heartbeatFuture.isDone()) {
                try {
                    this.heartbeatFuture.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    log.error((Object)sm.getString("groupChannel.unable.sendHeartbeat"), (Throwable)exception);
                }
            }
            this.heartbeatFuture = this.utilityExecutor.scheduleWithFixedDelay(new HeartbeatRunnable(), this.heartbeatSleeptime, this.heartbeatSleeptime, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized void stop(int n) throws ChannelException {
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
            this.monitorFuture = null;
        }
        if (this.heartbeatFuture != null) {
            this.heartbeatFuture.cancel(true);
            this.heartbeatFuture = null;
        }
        super.stop(n);
        if (this.ownExecutor) {
            this.utilityExecutor.shutdown();
            this.utilityExecutor = null;
            this.ownExecutor = false;
        }
        if (this.oname != null) {
            JmxRegistry.getRegistry(this).unregisterJmx(this.oname);
            this.oname = null;
        }
    }

    public ChannelInterceptor getFirstInterceptor() {
        if (this.interceptors != null) {
            return this.interceptors;
        }
        return this.coordinator;
    }

    @Override
    public ScheduledExecutorService getUtilityExecutor() {
        return this.utilityExecutor;
    }

    @Override
    public void setUtilityExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.utilityExecutor = scheduledExecutorService;
    }

    @Override
    public ChannelReceiver getChannelReceiver() {
        return this.coordinator.getClusterReceiver();
    }

    @Override
    public ChannelSender getChannelSender() {
        return this.coordinator.getClusterSender();
    }

    @Override
    public MembershipService getMembershipService() {
        return this.coordinator.getMembershipService();
    }

    @Override
    public void setChannelReceiver(ChannelReceiver channelReceiver) {
        this.coordinator.setClusterReceiver(channelReceiver);
    }

    @Override
    public void setChannelSender(ChannelSender channelSender) {
        this.coordinator.setClusterSender(channelSender);
    }

    @Override
    public void setMembershipService(MembershipService membershipService) {
        this.coordinator.setMembershipService(membershipService);
    }

    @Override
    public void addMembershipListener(MembershipListener membershipListener) {
        if (!this.membershipListeners.contains(membershipListener)) {
            this.membershipListeners.add(membershipListener);
        }
    }

    @Override
    public void removeMembershipListener(MembershipListener membershipListener) {
        this.membershipListeners.remove(membershipListener);
    }

    @Override
    public void addChannelListener(ChannelListener channelListener) {
        if (this.channelListeners.contains(channelListener)) {
            throw new IllegalArgumentException(sm.getString("groupChannel.listener.alreadyExist", channelListener, channelListener.getClass().getName()));
        }
        this.channelListeners.add(channelListener);
    }

    @Override
    public void removeChannelListener(ChannelListener channelListener) {
        this.channelListeners.remove(channelListener);
    }

    @Override
    public Iterator<ChannelInterceptor> getInterceptors() {
        return new InterceptorIterator(this.getNext(), this.coordinator);
    }

    public void setOptionCheck(boolean bl) {
        this.optionCheck = bl;
    }

    public void setHeartbeatSleeptime(long l) {
        this.heartbeatSleeptime = l;
    }

    @Override
    public void setHeartbeat(boolean bl) {
        this.heartbeat = bl;
    }

    @Override
    public boolean getOptionCheck() {
        return this.optionCheck;
    }

    @Override
    public boolean getHeartbeat() {
        return this.heartbeat;
    }

    @Override
    public long getHeartbeatSleeptime() {
        return this.heartbeatSleeptime;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    @Override
    public void setJmxEnabled(boolean bl) {
        this.jmxEnabled = bl;
    }

    @Override
    public String getJmxDomain() {
        return this.jmxDomain;
    }

    @Override
    public void setJmxDomain(String string) {
        this.jmxDomain = string;
    }

    @Override
    public String getJmxPrefix() {
        return this.jmxPrefix;
    }

    @Override
    public void setJmxPrefix(String string) {
        this.jmxPrefix = string;
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        return null;
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        JmxRegistry.removeRegistry(this, true);
    }

    public class HeartbeatRunnable
    implements Runnable {
        @Override
        public void run() {
            GroupChannel.this.heartbeat();
        }
    }

    public static class InterceptorIterator
    implements Iterator<ChannelInterceptor> {
        private final ChannelInterceptor end;
        private ChannelInterceptor start;

        public InterceptorIterator(ChannelInterceptor channelInterceptor, ChannelInterceptor channelInterceptor2) {
            this.end = channelInterceptor2;
            this.start = channelInterceptor;
        }

        @Override
        public boolean hasNext() {
            return this.start != null && this.start != this.end;
        }

        @Override
        public ChannelInterceptor next() {
            ChannelInterceptor channelInterceptor = null;
            if (this.hasNext()) {
                channelInterceptor = this.start;
                this.start = this.start.getNext();
            }
            return channelInterceptor;
        }

        @Override
        public void remove() {
        }
    }
}

