/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.AbsoluteOrder;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.interceptors.StaticMembershipInterceptorMBean;
import org.apache.catalina.tribes.group.interceptors.TcpFailureDetector;
import org.apache.catalina.tribes.group.interceptors.TcpPingInterceptor;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class StaticMembershipInterceptor
extends ChannelInterceptorBase
implements StaticMembershipInterceptorMBean {
    private static final Log log = LogFactory.getLog(StaticMembershipInterceptor.class);
    protected static final StringManager sm = StringManager.getManager(StaticMembershipInterceptor.class);
    protected static final byte[] MEMBER_START = new byte[]{76, 111, 99, 97, 108, 32, 83, 116, 97, 116, 105, 99, 77, 101, 109, 98, 101, 114, 32, 78, 111, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 68, 97, 116, 97};
    protected static final byte[] MEMBER_STOP = new byte[]{76, 111, 99, 97, 108, 32, 83, 116, 97, 116, 105, 99, 77, 101, 109, 98, 101, 114, 32, 83, 104, 117, 116, 100, 111, 119, 110, 32, 68, 97, 116, 97};
    protected final ArrayList<Member> members = new ArrayList();
    protected Member localMember = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStaticMember(Member member) {
        ArrayList<Member> arrayList = this.members;
        synchronized (arrayList) {
            if (!this.members.contains(member)) {
                this.members.add(member);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStaticMember(Member member) {
        ArrayList<Member> arrayList = this.members;
        synchronized (arrayList) {
            this.members.remove(member);
        }
    }

    public void setLocalMember(Member member) {
        this.localMember = member;
        this.localMember.setLocal(true);
    }

    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        if (channelMessage.getMessage().getLength() == MEMBER_START.length && Arrays.equals(MEMBER_START, channelMessage.getMessage().getBytes())) {
            Member member = this.getMember(channelMessage.getAddress());
            if (member != null) {
                super.memberAdded(member);
            }
        } else if (channelMessage.getMessage().getLength() == MEMBER_STOP.length && Arrays.equals(MEMBER_STOP, channelMessage.getMessage().getBytes())) {
            Member member = this.getMember(channelMessage.getAddress());
            if (member != null) {
                try {
                    member.setCommand(Member.SHUTDOWN_PAYLOAD);
                    super.memberDisappeared(member);
                }
                finally {
                    member.setCommand(new byte[0]);
                }
            }
        } else {
            super.messageReceived(channelMessage);
        }
    }

    @Override
    public boolean hasMembers() {
        return super.hasMembers() || !this.members.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Member[] getMembers() {
        if (this.members.isEmpty()) {
            return super.getMembers();
        }
        ArrayList<Member> arrayList = this.members;
        synchronized (arrayList) {
            Member[] memberArray = super.getMembers();
            Member[] memberArray2 = new Member[this.members.size() + memberArray.length];
            System.arraycopy(memberArray, 0, memberArray2, 0, memberArray.length);
            for (int i = 0; i < this.members.size(); ++i) {
                memberArray2[i + memberArray.length] = this.members.get(i);
            }
            AbsoluteOrder.absoluteOrder(memberArray2);
            return memberArray2;
        }
    }

    @Override
    public Member getMember(Member member) {
        if (this.members.contains(member)) {
            return this.members.get(this.members.indexOf(member));
        }
        return super.getMember(member);
    }

    @Override
    public Member getLocalMember(boolean bl) {
        if (this.localMember != null) {
            return this.localMember;
        }
        return super.getLocalMember(bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start(int n) throws ChannelException {
        void var5_7;
        Object object;
        if ((1 & n) == 1) {
            super.start(1);
        }
        if ((2 & n) == 2) {
            super.start(2);
        }
        StaticMembershipInterceptor staticMembershipInterceptor = this;
        ScheduledExecutorService scheduledExecutorService = this.getChannel().getUtilityExecutor();
        for (Member object22 : this.members) {
            object = () -> {
                staticMembershipInterceptor.memberAdded(object22);
                if (this.getfirstInterceptor().getMember(object22) != null) {
                    this.sendLocalMember(new Member[]{object22});
                }
            };
            scheduledExecutorService.execute((Runnable)object);
        }
        super.start(n & 0xFFFFFFFE & 0xFFFFFFFD);
        Object object3 = null;
        Object var5_6 = null;
        for (object = this.getPrevious(); object != null; object = object.getPrevious()) {
            if (object instanceof TcpFailureDetector) {
                object3 = (TcpFailureDetector)object;
            }
            if (!(object instanceof TcpPingInterceptor)) continue;
            TcpPingInterceptor tcpPingInterceptor = (TcpPingInterceptor)object;
        }
        if (object3 == null) {
            log.warn((Object)sm.getString("staticMembershipInterceptor.no.failureDetector"));
        }
        if (var5_7 == null) {
            log.warn((Object)sm.getString("staticMembershipInterceptor.no.pingInterceptor"));
        }
    }

    @Override
    public void stop(int n) throws ChannelException {
        Member[] memberArray = this.getfirstInterceptor().getMembers();
        this.sendShutdown(memberArray);
        super.stop(n);
    }

    protected void sendLocalMember(Member[] memberArray) {
        try {
            this.sendMemberMessage(memberArray, MEMBER_START);
        }
        catch (ChannelException channelException) {
            log.warn((Object)sm.getString("staticMembershipInterceptor.sendLocalMember.failed"), (Throwable)channelException);
        }
    }

    protected void sendShutdown(Member[] memberArray) {
        try {
            this.sendMemberMessage(memberArray, MEMBER_STOP);
        }
        catch (ChannelException channelException) {
            log.warn((Object)sm.getString("staticMembershipInterceptor.sendShutdown.failed"), (Throwable)channelException);
        }
    }

    protected ChannelInterceptor getfirstInterceptor() {
        StaticMembershipInterceptor staticMembershipInterceptor;
        ChannelInterceptor channelInterceptor = this;
        do {
            staticMembershipInterceptor = channelInterceptor;
        } while ((channelInterceptor = channelInterceptor.getPrevious()).getPrevious() != null);
        return staticMembershipInterceptor;
    }

    protected void sendMemberMessage(Member[] memberArray, byte[] byArray) throws ChannelException {
        if (memberArray == null || memberArray.length == 0) {
            return;
        }
        ChannelData channelData = new ChannelData(true);
        channelData.setAddress(this.getLocalMember(false));
        channelData.setTimestamp(System.currentTimeMillis());
        channelData.setOptions(this.getOptionFlag());
        channelData.setMessage(new XByteBuffer(byArray, false));
        super.sendMessage(memberArray, channelData, null);
    }
}

