import { AccessType, ResolveContext, Rule, TriggerType } from "./types-Bt9Mdb_S.js";
import * as typescript0 from "typescript";
import ts from "typescript";

//#region src/core/types.d.ts
interface TSNode extends ts.TextRange {
  ast: ts.Node;
}
interface ReactiveNode {
  isDependency?: boolean;
  isDependent?: boolean;
  binding?: TSNode & {
    accessTypes: AccessType[];
  };
  accessor?: TSNode & {
    requireAccess?: boolean;
  };
  callback?: TSNode;
}
interface ToSourceRange {
  (pos: number, end: number): ts.TextRange | undefined;
}
//#endregion
//#region src/core/index.d.ts
interface CreateAnalyzerOptions {
  rules: Rule[];
}
interface CollectOptions {
  typescript: typeof typescript0;
  toSourceRange?: ToSourceRange;
}
interface AnalyzeOptions {
  typescript: typeof typescript0;
  languageService: ts.LanguageService;
  toSourceRange?: ToSourceRange;
}
type Analyzer = ReturnType<typeof createAnalyzer>;
declare function createAnalyzer(options: CreateAnalyzerOptions): {
  collect(sourceFile: ts.SourceFile, options: CollectOptions): {
    propertyAccesses: Map<number, string>;
    propertyCalls: Map<number, string>;
    functionCalls: Set<number>;
    signals: ReactiveNode[];
  };
  analyze(sourceFile: ts.SourceFile, position: number, options: AnalyzeOptions): {
    dependencyRanges: ts.TextRange[];
    dependentRanges: ts.TextRange[];
  } | undefined;
};
//#endregion
//#region src/rules/index.d.ts
declare function defineRules(rules: Rule[]): Rule[];
//#endregion
export { AccessType, AnalyzeOptions, Analyzer, CollectOptions, CreateAnalyzerOptions, ResolveContext, Rule, TriggerType, createAnalyzer, defineRules };