# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_alpm_db_desc_global_optspecs
	string join \n h/help V/version
end

function __fish_alpm_db_desc_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_alpm_db_desc_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_alpm_db_desc_using_subcommand
	set -l cmd (__fish_alpm_db_desc_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c alpm-db-desc -n "__fish_alpm_db_desc_needs_command" -s h -l help -d 'Print help'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_needs_command" -s V -l version -d 'Print version'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_needs_command" -f -a "create" -d 'Create a DB desc file according to a schema'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_needs_command" -f -a "validate" -d 'Validate a DB desc file according to a schema'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_needs_command" -f -a "format" -d 'Parse and output a DB desc file in a different format'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and not __fish_seen_subcommand_from v1 v2 help" -s h -l help -d 'Print help'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and not __fish_seen_subcommand_from v1 v2 help" -f -a "v1" -d 'Create a DB desc version 1 file'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and not __fish_seen_subcommand_from v1 v2 help" -f -a "v2" -d 'Create a DB desc version 2 file'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and not __fish_seen_subcommand_from v1 v2 help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l name -d 'The package name' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l version -d 'The package version' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l base -d 'The package base' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l description -d 'The package description' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l url -d 'The package URL' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l arch -d 'The package architecture' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l builddate -d 'The package build date' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l installdate -d 'The package install date' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l packager -d 'The packager' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l size -d 'The installed size' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l groups -d 'The package groups' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l reason -d 'The package install reason' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l license -d 'The package licenses' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l validation -d 'The package validation methods' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l replaces -d 'The replaces' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l depends -d 'The dependencies' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l optdepends -d 'The optional dependencies' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l conflicts -d 'The conflicts' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -l provides -d 'The provides' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v1" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l name -d 'The package name' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l version -d 'The package version' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l base -d 'The package base' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l description -d 'The package description' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l url -d 'The package URL' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l arch -d 'The package architecture' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l builddate -d 'The package build date' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l installdate -d 'The package install date' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l packager -d 'The packager' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l size -d 'The installed size' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l groups -d 'The package groups' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l reason -d 'The package install reason' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l license -d 'The package licenses' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l validation -d 'The package validation methods' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l replaces -d 'The replaces' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l depends -d 'The dependencies' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l optdepends -d 'The optional dependencies' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l conflicts -d 'The conflicts' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l provides -d 'The provides' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -l xdata -d 'Structured extra metadata' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from v2" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from help" -f -a "v1" -d 'Create a DB desc version 1 file'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from help" -f -a "v2" -d 'Create a DB desc version 2 file'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand create; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand validate" -s s -l schema -d 'Provide the schema version to use' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand validate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand format" -s s -l schema -d 'Provide the schema version to use' -r
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand format" -s o -l output-format -d 'Provide the output format' -r -f -a "json\t'The JSON output format'"
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand format" -s p -l pretty -d 'Pretty-print the output'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand format" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand help; and not __fish_seen_subcommand_from create validate format help" -f -a "create" -d 'Create a DB desc file according to a schema'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand help; and not __fish_seen_subcommand_from create validate format help" -f -a "validate" -d 'Validate a DB desc file according to a schema'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand help; and not __fish_seen_subcommand_from create validate format help" -f -a "format" -d 'Parse and output a DB desc file in a different format'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand help; and not __fish_seen_subcommand_from create validate format help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand help; and __fish_seen_subcommand_from create" -f -a "v1" -d 'Create a DB desc version 1 file'
complete -c alpm-db-desc -n "__fish_alpm_db_desc_using_subcommand help; and __fish_seen_subcommand_from create" -f -a "v2" -d 'Create a DB desc version 2 file'
