/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSourceInfo;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.exec.DBCCachedContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LocalCacheProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class GenericExecutionContext
extends JDBCExecutionContext
implements DBCExecutionContextDefaults<GenericCatalog, GenericSchema> {
    private static final Log log = Log.getLog(GenericExecutionContext.class);
    private String selectedEntityName;

    public GenericExecutionContext(@NotNull JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    @NotNull
    public GenericDataSource getDataSource() {
        return (GenericDataSource)super.getDataSource();
    }

    @Nullable
    public DBCExecutionContextDefaults<?, ?> getContextDefaults() {
        return this;
    }

    void determineSelectedEntity(DBRProgressMonitor monitor) {
        GenericDataSource dataSource;
        block42: {
            dataSource = this.getDataSource();
            this.selectedEntityName = null;
            Throwable throwable = null;
            Object var4_5 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Determine default catalog/schema");){
                if (CommonUtils.isEmpty((String)dataSource.getQueryGetActiveDB())) {
                    String schemaName;
                    String catalogName;
                    try {
                        catalogName = session.getCatalog();
                    }
                    catch (Throwable e) {
                        catalogName = null;
                        log.debug((Object)e);
                    }
                    try {
                        schemaName = session.getSchema();
                    }
                    catch (Throwable e) {
                        schemaName = null;
                        log.debug((Object)e);
                    }
                    String selectedObjectType = null;
                    if (CommonUtils.isNotEmpty((String)catalogName)) {
                        this.selectedEntityName = catalogName;
                        selectedObjectType = "catalog";
                    }
                    if (CommonUtils.isNotEmpty((String)schemaName)) {
                        this.selectedEntityName = schemaName;
                        selectedObjectType = "schema";
                    }
                    if (CommonUtils.isNotEmpty((String)selectedObjectType)) {
                        dataSource.setSelectedEntityType(selectedObjectType);
                        dataSource.setSelectedEntityFromAPI(true);
                    }
                    break block42;
                }
                try {
                    Throwable catalogName = null;
                    Object var7_17 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement(dataSource.getQueryGetActiveDB());){
                        Throwable throwable2 = null;
                        Object var10_21 = null;
                        try (JDBCResultSet resultSet = dbStat.executeQuery();){
                            int divPos;
                            resultSet.next();
                            this.selectedEntityName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (int)1);
                            if (!CommonUtils.isEmpty((String)this.selectedEntityName) && (divPos = this.selectedEntityName.lastIndexOf(44)) != -1) {
                                this.selectedEntityName = this.selectedEntityName.substring(divPos + 1);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (catalogName == null) {
                            catalogName = throwable4;
                        } else if (catalogName != throwable4) {
                            catalogName.addSuppressed(throwable4);
                        }
                        throw catalogName;
                    }
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                    this.selectedEntityName = null;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        if (CommonUtils.isEmpty((String)this.selectedEntityName)) {
            if (dataSource.hasCatalogs() && dataSource.getCatalogs().size() == 1) {
                dataSource.setSelectedEntityType("catalog");
                this.selectedEntityName = dataSource.getCatalogs().getFirst().getName();
            } else if (dataSource.hasSchemas() && dataSource.getSchemas().size() == 1) {
                dataSource.setSelectedEntityType("schema");
                this.selectedEntityName = dataSource.getSchemas().getFirst().getName();
            }
        }
    }

    public void initDefaultsFrom(DBRProgressMonitor monitor, GenericExecutionContext context) throws DBCException {
        block37: {
            GenericSchema defaultSchema;
            GenericCatalog defaultCatalog = context.getDefaultCatalog();
            String entityName = null;
            if (defaultCatalog != null && context.supportsCatalogChange()) {
                entityName = defaultCatalog.getName();
            } else if (context.supportsSchemaChange() && (defaultSchema = context.getDefaultSchema()) != null) {
                entityName = defaultSchema.getName();
            }
            if (entityName != null) {
                GenericDataSource dataSource = this.getDataSource();
                DBCTransactionManager txnManager = null;
                boolean autoCommit = true;
                boolean needToSetAutocommit = false;
                try {
                    try {
                        Throwable throwable = null;
                        Object var10_12 = null;
                        try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active catalog");){
                            if (dataSource.isSelectedEntityFromAPI()) {
                                if (!dataSource.getContainer().getDriver().isInternalDriver()) {
                                    if (context.supportsCatalogChange()) {
                                        session.setCatalog(entityName);
                                    } else {
                                        session.setSchema(entityName);
                                    }
                                } else {
                                    log.debug((Object)"Catalog/schema switch is disabled for legacy drivers");
                                }
                            } else {
                                if (CommonUtils.isEmpty((String)dataSource.getQuerySetActiveDB())) {
                                    throw new DBCException("Active database can't be changed for this kind of datasource!");
                                }
                                txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this);
                                boolean bl = needToSetAutocommit = txnManager != null && this.isSupportsTransactions() && !dataSource.supportsCatalogChangeInTransaction();
                                if (needToSetAutocommit && !(autoCommit = txnManager.isAutoCommit())) {
                                    txnManager.setAutoCommit(monitor, true);
                                }
                                String changeQuery = dataSource.getQuerySetActiveDB().replaceFirst("\\?", Matcher.quoteReplacement(entityName));
                                Throwable throwable2 = null;
                                Object var14_18 = null;
                                try (JDBCPreparedStatement dbStat = session.prepareStatement(changeQuery);){
                                    dbStat.execute();
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    throw throwable2;
                                }
                            }
                            this.selectedEntityName = entityName;
                            break block37;
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (SQLException e) {
                        throw new DBCException((Throwable)e, (DBCExecutionContext)this);
                    }
                }
                finally {
                    if (needToSetAutocommit && !autoCommit) {
                        txnManager.setAutoCommit(monitor, false);
                    }
                }
            }
            this.selectedEntityName = context.selectedEntityName;
        }
    }

    public GenericCatalog getDefaultCatalog() {
        GenericObjectContainer genericObjectContainer;
        if ("catalog".equals(this.getDataSource().getSelectedEntityType()) && (genericObjectContainer = this.getDefaultObject()) instanceof GenericCatalog) {
            GenericCatalog catalog = (GenericCatalog)genericObjectContainer;
            return catalog;
        }
        return this.getDataSource().getDefaultCatalog();
    }

    public GenericSchema getDefaultSchema() {
        GenericObjectContainer genericObjectContainer;
        if ("schema".equals(this.getDataSource().getSelectedEntityType()) && (genericObjectContainer = this.getDefaultObject()) instanceof GenericSchema) {
            GenericSchema schema = (GenericSchema)genericObjectContainer;
            return schema;
        }
        return this.getDataSource().getDefaultSchema();
    }

    /*
     * WARNING - void declaration
     */
    public boolean supportsCatalogChange() {
        GenericDataSource dataSource = this.getDataSource();
        DBPDataSourceInfo dBPDataSourceInfo = dataSource.getInfo();
        if (!(dBPDataSourceInfo instanceof GenericDataSourceInfo)) {
            if (dataSource.isSelectedEntityFromAPI()) {
                return !dataSource.getContainer().getDriver().isInternalDriver();
            }
            return CommonUtils.isNotEmpty((String)dataSource.getQuerySetActiveDB());
        }
        GenericDataSourceInfo genericDataSourceInfo = (GenericDataSourceInfo)dBPDataSourceInfo;
        if (dataSource.isSelectedEntityFromAPI() || !CommonUtils.isEmpty((String)dataSource.getQuerySetActiveDB())) {
            void info;
            if (CommonUtils.isEmpty((String)dataSource.getSelectedEntityType())) {
                return dataSource.hasCatalogs() && info.supportsCatalogSelection();
            }
            if (dataSource.hasCatalogs()) {
                return ("catalog".equals(dataSource.getSelectedEntityType()) || !dataSource.hasSchemas()) && info.supportsCatalogSelection();
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean supportsSchemaChange() {
        GenericDataSource dataSource = this.getDataSource();
        DBPDataSourceInfo dBPDataSourceInfo = dataSource.getInfo();
        if (!(dBPDataSourceInfo instanceof GenericDataSourceInfo)) {
            if (dataSource.isSelectedEntityFromAPI()) {
                return !dataSource.getContainer().getDriver().isInternalDriver();
            }
            return CommonUtils.isNotEmpty((String)dataSource.getQuerySetActiveDB());
        }
        GenericDataSourceInfo genericDataSourceInfo = (GenericDataSourceInfo)dBPDataSourceInfo;
        if (dataSource.isSelectedEntityFromAPI() || !CommonUtils.isEmpty((String)dataSource.getQuerySetActiveDB())) {
            void info;
            if (CommonUtils.isEmpty((String)dataSource.getSelectedEntityType())) {
                return !dataSource.hasCatalogs() && dataSource.hasSchemas() && info.supportsSchemaSelection();
            }
            if (dataSource.hasSchemas()) {
                return ("schema".equals(dataSource.getSelectedEntityType()) || !dataSource.hasCatalogs()) && info.supportsSchemaSelection();
            }
        }
        return false;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, GenericCatalog catalog, GenericSchema schema) throws DBCException {
        GenericCatalog oldSelectedCatalog;
        GenericDataSource dataSource;
        block31: {
            if (catalog == null) {
                log.debug((Object)"Null current catalog");
                return;
            }
            dataSource = this.getDataSource();
            oldSelectedCatalog = this.getDefaultCatalog();
            DBCTransactionManager txnManager = null;
            boolean autoCommit = true;
            boolean needToSetAutocommit = false;
            try {
                try {
                    Throwable throwable = null;
                    Object var10_12 = null;
                    try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active catalog");){
                        if (dataSource.isSelectedEntityFromAPI()) {
                            if (!dataSource.getContainer().getDriver().isInternalDriver()) {
                                session.setCatalog(catalog.getName());
                            } else {
                                log.debug((Object)"Catalog change is disabled for legacy drivers");
                            }
                            break block31;
                        }
                        if (CommonUtils.isEmpty((String)dataSource.getQuerySetActiveDB())) {
                            throw new DBCException("Active catalog can't be changed for this kind of datasource!");
                        }
                        txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this);
                        boolean bl = needToSetAutocommit = txnManager != null && this.isSupportsTransactions() && !dataSource.supportsCatalogChangeInTransaction();
                        if (needToSetAutocommit && !(autoCommit = txnManager.isAutoCommit())) {
                            txnManager.setAutoCommit(monitor, true);
                        }
                        String changeQuery = dataSource.getQuerySetActiveDB().replaceFirst("\\?", Matcher.quoteReplacement(catalog.getName()));
                        Throwable throwable2 = null;
                        Object var14_18 = null;
                        try (JDBCPreparedStatement dbStat = session.prepareStatement(changeQuery);){
                            dbStat.execute();
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException((Throwable)e, (DBCExecutionContext)this);
                }
            }
            finally {
                if (needToSetAutocommit && !autoCommit) {
                    txnManager.setAutoCommit(monitor, false);
                }
            }
        }
        this.selectedEntityName = catalog.getName();
        dataSource.setSelectedEntityType("catalog");
        if (oldSelectedCatalog != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedCatalog, (boolean)false, (DBCExecutionContext)this);
        }
        DBUtils.fireObjectSelect((DBSObject)catalog, (boolean)true, (DBCExecutionContext)this);
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, GenericSchema schema) throws DBCException {
        if (schema == null) {
            log.debug((Object)"Null current schema");
            return;
        }
        GenericSchema oldSelectedSchema = this.getDefaultSchema();
        this.setDefaultSchema(monitor, schema.getName());
        if (oldSelectedSchema != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedSchema, (boolean)false, (DBCExecutionContext)this);
        }
        DBUtils.fireObjectSelect((DBSObject)schema, (boolean)true, (DBCExecutionContext)this);
    }

    private void setDefaultSchema(DBRProgressMonitor monitor, String schemaName) throws DBCException {
        GenericDataSource dataSource;
        block22: {
            dataSource = this.getDataSource();
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active schema");){
                    if (dataSource.isSelectedEntityFromAPI()) {
                        session.setSchema(schemaName);
                        break block22;
                    }
                    if (CommonUtils.isEmpty((String)dataSource.getQuerySetActiveDB())) {
                        throw new DBCException("Active schema can't be changed for this kind of datasource!");
                    }
                    String changeQuery = dataSource.getQuerySetActiveDB().replaceFirst("\\?", Matcher.quoteReplacement(schemaName));
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement(changeQuery);){
                        dbStat.execute();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)this);
            }
        }
        this.selectedEntityName = schemaName;
        dataSource.setSelectedEntityType("schema");
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        GenericObjectContainer newDefaultObject;
        DBPConnectionBootstrap bootstrap;
        if (useBootstrapSettings && !CommonUtils.isEmpty((String)(bootstrap = this.getBootstrapSettings()).getDefaultSchemaName()) && this.supportsSchemaChange()) {
            this.setDefaultSchema(monitor, bootstrap.getDefaultSchemaName());
        }
        String oldEntityName = this.selectedEntityName;
        GenericObjectContainer oldDefaultObject = this.getDefaultObject();
        try {
            this.determineSelectedEntity(monitor);
        }
        catch (Throwable e) {
            log.debug((Object)"Error detecting active object", e);
            return false;
        }
        if (!CommonUtils.equalObjects((Object)oldEntityName, (Object)this.selectedEntityName) && (newDefaultObject = this.getDefaultObject()) != null) {
            DBUtils.fireObjectSelectionChange((DBSObject)oldDefaultObject, (DBSObject)newDefaultObject, (DBCExecutionContext)this);
            return true;
        }
        return false;
    }

    public GenericObjectContainer getDefaultObject() {
        if (!CommonUtils.isEmpty((String)this.selectedEntityName)) {
            GenericDataSource dataSource = this.getDataSource();
            if (dataSource.hasCatalogs() && "catalog".equals(dataSource.getSelectedEntityType())) {
                return dataSource.getCatalog(this.selectedEntityName);
            }
            if ("schema".equals(dataSource.getSelectedEntityType())) {
                List<GenericCatalog> catalogs;
                if (dataSource.hasSchemas()) {
                    return dataSource.getSchema(this.selectedEntityName);
                }
                if (dataSource.hasCatalogs() && (catalogs = dataSource.getCatalogs()).size() == 1) {
                    try {
                        return catalogs.getFirst().getSchema((DBRProgressMonitor)new LocalCacheProgressMonitor((DBRProgressMonitor)new VoidProgressMonitor()), this.selectedEntityName);
                    }
                    catch (DBException e) {
                        log.debug((Object)("Error reading schema in the first catalog: " + e.getMessage()));
                    }
                }
            }
            if (dataSource.hasCatalogs()) {
                if (dataSource.getSelectedEntityType() == null || dataSource.getSelectedEntityType().equals("catalog")) {
                    return dataSource.getCatalog(this.selectedEntityName);
                }
            } else if (dataSource.hasSchemas()) {
                return dataSource.getSchema(this.selectedEntityName);
            }
        }
        return null;
    }

    public String getDefaultCatalogCached() {
        GenericDataSource dataSource;
        if (!CommonUtils.isEmpty((String)this.selectedEntityName) && (dataSource = this.getDataSource()).hasCatalogs() && (dataSource.getSelectedEntityType() == null || dataSource.getSelectedEntityType().equals("catalog") || !dataSource.hasSchemas())) {
            return this.selectedEntityName;
        }
        return null;
    }

    public String getDefaultSchemaCached() {
        GenericDataSource dataSource;
        if (!(CommonUtils.isEmpty((String)this.selectedEntityName) || (dataSource = this.getDataSource()).hasCatalogs() || !dataSource.hasSchemas() || dataSource.getSelectedEntityType() != null && !dataSource.getSelectedEntityType().equals("schema") && dataSource.hasCatalogs())) {
            return this.selectedEntityName;
        }
        return null;
    }

    @NotNull
    public DBCCachedContextDefaults getCachedDefault() {
        return new DBCCachedContextDefaults(this.getDefaultCatalogCached(), this.getDefaultSchemaCached());
    }
}

