/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.pdf.CMapBuilder;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFCMap;
import org.apache.fop.render.pdf.PDFEventProducer;

public class PDFToUnicodeCMap
extends PDFCMap {
    protected char[] unicodeCharMap;
    private boolean singleByte;
    private EventBroadcaster eventBroadcaster;

    public PDFToUnicodeCMap(char[] unicodeCharMap, String name, PDFCIDSystemInfo sysInfo, boolean singleByte, EventBroadcaster eventBroadcaster) {
        super(name, sysInfo);
        if (singleByte && unicodeCharMap.length > 256) {
            throw new IllegalArgumentException("unicodeCharMap may not contain more than 256 characters for single-byte encodings");
        }
        this.unicodeCharMap = unicodeCharMap;
        this.singleByte = singleByte;
        this.eventBroadcaster = eventBroadcaster;
    }

    @Override
    protected CMapBuilder createCMapBuilder(Writer writer) {
        return new ToUnicodeCMapBuilder(writer);
    }

    class ToUnicodeCMapBuilder
    extends CMapBuilder {
        public ToUnicodeCMapBuilder(Writer writer) {
            super(writer, null);
        }

        @Override
        public void writeCMap() throws IOException {
            this.writeCIDInit();
            this.writeCIDSystemInfo("Adobe", "UCS", 0);
            this.writeName("Adobe-Identity-UCS");
            this.writeType("2");
            this.writeCodeSpaceRange(PDFToUnicodeCMap.this.singleByte);
            this.writeBFEntries();
            this.writeWrapUp();
        }

        @Override
        protected void writeBFEntries() throws IOException {
            if (PDFToUnicodeCMap.this.unicodeCharMap != null) {
                this.writeBFCharEntries(PDFToUnicodeCMap.this.unicodeCharMap);
                this.writeBFRangeEntries(PDFToUnicodeCMap.this.unicodeCharMap);
            }
        }

        protected void writeBFCharEntries(char[] charArray) throws IOException {
            int entriesThisSection;
            int totalEntries = 0;
            int charIndex = 0;
            if (charArray.length > 0) {
                do {
                    if (!this.partOfRange(charArray, charIndex)) {
                        ++totalEntries;
                    }
                    if (!Character.isHighSurrogate(charArray[charIndex])) continue;
                    ++charIndex;
                } while (++charIndex < charArray.length);
            }
            if (totalEntries < 1) {
                return;
            }
            int remainingEntries = totalEntries;
            charIndex = 0;
            do {
                entriesThisSection = Math.min(remainingEntries, 100);
                this.writer.write(entriesThisSection + " beginbfchar\n");
                int sectionEntryCount = 0;
                while (true) {
                    if (this.partOfRange(charArray, charIndex)) {
                        if (Character.isHighSurrogate(charArray[charIndex])) {
                            ++charIndex;
                        }
                        ++charIndex;
                        continue;
                    }
                    this.writer.write("<" + this.padCharIndex(charIndex) + "> ");
                    if (Character.isHighSurrogate(charArray[charIndex])) {
                        char secondChar = '\u0000';
                        if (charIndex + 1 < charArray.length) {
                            secondChar = charArray[charIndex + 1];
                        } else if (PDFToUnicodeCMap.this.eventBroadcaster != null) {
                            PDFEventProducer pdfEventProducer = PDFEventProducer.Provider.get(PDFToUnicodeCMap.this.eventBroadcaster);
                            pdfEventProducer.unpairedSurrogate(this);
                        }
                        this.writer.write("<" + this.padHexString(Integer.toHexString(charArray[charIndex]), 4) + this.padHexString(Integer.toHexString(secondChar), 4) + ">\n");
                        ++charIndex;
                    } else {
                        this.writer.write("<" + this.padHexString(Integer.toHexString(charArray[charIndex]), 4) + ">\n");
                    }
                    ++charIndex;
                    if (++sectionEntryCount >= entriesThisSection) break;
                }
                this.writer.write("endbfchar\n");
            } while ((remainingEntries -= entriesThisSection) > 0);
        }

        private String padCharIndex(int charIndex) {
            return this.padHexString(Integer.toHexString(charIndex), PDFToUnicodeCMap.this.singleByte ? 2 : 4);
        }

        protected void writeBFRangeEntries(char[] charArray) throws IOException {
            int entriesThisSection;
            int totalEntries = 0;
            int charIndex = 0;
            if (charArray.length > 0) {
                do {
                    if (this.startOfRange(charArray, charIndex)) {
                        ++totalEntries;
                    }
                    if (!Character.isHighSurrogate(charArray[charIndex])) continue;
                    ++charIndex;
                } while (++charIndex < charArray.length);
            }
            if (totalEntries < 1) {
                return;
            }
            int remainingEntries = totalEntries;
            charIndex = 0;
            do {
                entriesThisSection = Math.min(remainingEntries, 100);
                this.writer.write(entriesThisSection + " beginbfrange\n");
                int sectionEntryCount = 0;
                while (true) {
                    if (!this.startOfRange(charArray, charIndex)) {
                        if (Character.isHighSurrogate(charArray[charIndex])) {
                            ++charIndex;
                        }
                        ++charIndex;
                        continue;
                    }
                    this.writer.write("<" + this.padCharIndex(charIndex) + "> ");
                    this.writer.write("<" + this.padCharIndex(this.endOfRange(charArray, charIndex)) + "> ");
                    if (Character.isHighSurrogate(charArray[charIndex])) {
                        char secondChar = '\u0000';
                        if (charIndex + 1 < charArray.length) {
                            secondChar = charArray[charIndex + 1];
                        } else if (PDFToUnicodeCMap.this.eventBroadcaster != null) {
                            PDFEventProducer pdfEventProducer = PDFEventProducer.Provider.get(PDFToUnicodeCMap.this.eventBroadcaster);
                            pdfEventProducer.unpairedSurrogate(this);
                        }
                        this.writer.write("<" + this.padHexString(Integer.toHexString(charArray[charIndex]), 4) + this.padHexString(Integer.toHexString(secondChar), 4) + ">\n");
                    } else {
                        this.writer.write("<" + this.padHexString(Integer.toHexString(charArray[charIndex]), 4) + ">\n");
                    }
                    ++charIndex;
                    if (++sectionEntryCount >= entriesThisSection) break;
                }
                this.writer.write("endbfrange\n");
            } while ((remainingEntries -= entriesThisSection) > 0);
        }

        private int endOfRange(char[] charArray, int startOfRange) {
            int i = startOfRange;
            if (Character.isHighSurrogate(charArray[i])) {
                while (i < charArray.length - 3 && this.sameRangeEntryAsNext(charArray, i)) {
                    i += 2;
                }
            } else {
                while (i < charArray.length - 1 && this.sameRangeEntryAsNext(charArray, i)) {
                    ++i;
                }
            }
            return i;
        }

        private boolean partOfRange(char[] charArray, int arrayIndex) {
            int minBytesInRange = 2;
            if (Character.isHighSurrogate(charArray[arrayIndex])) {
                minBytesInRange = 4;
            }
            if (charArray.length < minBytesInRange) {
                return false;
            }
            if (arrayIndex == 0) {
                return this.sameRangeEntryAsNext(charArray, 0);
            }
            if (Character.isHighSurrogate(charArray[arrayIndex]) && arrayIndex == charArray.length - 2) {
                return this.sameRangeEntryAsNext(charArray, arrayIndex - 2);
            }
            if (arrayIndex == charArray.length - 1) {
                return this.sameRangeEntryAsNext(charArray, arrayIndex - 1);
            }
            if (Character.isHighSurrogate(charArray[arrayIndex]) && this.sameRangeEntryAsNext(charArray, arrayIndex - 2)) {
                return true;
            }
            if (this.sameRangeEntryAsNext(charArray, arrayIndex - 1)) {
                return true;
            }
            return this.sameRangeEntryAsNext(charArray, arrayIndex);
        }

        private boolean sameRangeEntryAsNext(char[] charArray, int firstItem) {
            boolean retval = false;
            if (firstItem >= 0 && firstItem < charArray.length - 1) {
                if (Character.isHighSurrogate(charArray[firstItem])) {
                    if (firstItem < charArray.length - 3 && charArray[firstItem + 2] == charArray[firstItem] && charArray[firstItem + 3] == charArray[firstItem + 1] + '\u0001' && firstItem / 256 == (firstItem + 2) / 256) {
                        retval = true;
                    }
                } else if (charArray[firstItem] + '\u0001' == charArray[firstItem + 1] && firstItem / 256 == (firstItem + 1) / 256) {
                    retval = true;
                }
            }
            return retval;
        }

        private boolean startOfRange(char[] charArray, int arrayIndex) {
            if (!this.partOfRange(charArray, arrayIndex)) {
                return false;
            }
            if (arrayIndex == 0) {
                return true;
            }
            if (Character.isHighSurrogate(charArray[arrayIndex]) && arrayIndex == charArray.length - 2) {
                return false;
            }
            if (arrayIndex == charArray.length - 1) {
                return false;
            }
            if (Character.isHighSurrogate(charArray[arrayIndex]) && this.sameRangeEntryAsNext(charArray, arrayIndex - 2)) {
                return false;
            }
            return !this.sameRangeEntryAsNext(charArray, arrayIndex - 1);
        }

        private String padHexString(String input, int numChars) {
            int length = input.length();
            if (length >= numChars) {
                return input;
            }
            StringBuffer returnString = new StringBuffer();
            for (int i = 1; i <= numChars - length; ++i) {
                returnString.append("0");
            }
            returnString.append(input);
            return returnString.toString();
        }
    }
}

